/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.util.StringConverter;

public class TripleValueWidgetColumn<M>
extends TableWidgetColumn<M, ComboBoxWidget<Boolean>> {
    private final Function<M, Boolean> getter;
    private final BiConsumer<M, Boolean> setter;
    private StringConverter<Boolean> converter = new StringConverter<Boolean>(){

        public String toString(Boolean object) {
            if (object == null) {
                return TripleValueWidgetColumn.this.getOwner().getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
            }
            return (String)StandardRenderers.BOOLEAN.apply(object);
        }

        public Boolean fromString(String string) {
            return null;
        }
    };

    public TripleValueWidgetColumn(Function<M, Boolean> aGetter, BiConsumer<M, Boolean> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setConverter(StringConverter<Boolean> value) {
        this.converter = Objects.requireNonNull(value);
        this.applyToAllRows(widget -> widget.setConverter(this.converter));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public ComboBoxWidget<Boolean> createNode() {
        ComboBoxWidget<Boolean> result = new ComboBoxWidget<Boolean>(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setConverter(this.converter);
        result.setItemsSupplier(Suppliers.TRUE_FALSE);
        return result;
    }

    @Override
    public void readData(M model, ComboBoxWidget<Boolean> node) {
        node.setValue(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, ComboBoxWidget<Boolean> node) {
        this.setter.accept(model, node.getValue());
    }

    @Override
    public void setReadonly(ComboBoxWidget<Boolean> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(ComboBoxWidget<Boolean> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, ComboBoxWidget<Boolean> node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.getValue(), (Object)this.getter.apply(model));
    }
}

