/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.util.StringConverter;

public class ValuesWidgetColumn<M, I>
extends TableWidgetColumn<M, ValuesWidget<I>> {
    private final Function<M, List<I>> getter;
    private Supplier<List<I>> itemsSupplier = () -> Collections.emptyList();
    private StringConverter<I> converter;
    private boolean async;

    public ValuesWidgetColumn(Function<M, List<I>> aGetter) {
        this.getter = aGetter;
    }

    public void setItemsSupplier(Supplier<List<I>> value) {
        this.itemsSupplier = Objects.requireNonNull(value);
        this.applyToAllRows(widget -> widget.setItemsSupplier(this.itemsSupplier));
    }

    public void setConverter(StringConverter<I> value) {
        this.converter = value;
        this.applyToAllRows(widget -> widget.setConverter(this.converter));
    }

    public void setAsync(boolean value) {
        this.async = value;
        this.applyToAllRows(widget -> widget.setAsync(this.async));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public ValuesWidget<I> createNode() {
        ValuesWidget<Object> result = new ValuesWidget<Object>(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setItemsSupplier(this.itemsSupplier);
        if (this.converter != null) {
            result.setConverter(this.converter);
        }
        result.setAsync(this.async);
        return result;
    }

    @Override
    public void readData(M model, ValuesWidget<I> node) {
        node.getValues().setAll((Collection)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, ValuesWidget<I> node) {
        List<I> list = this.getter.apply(model);
        list.clear();
        list.addAll((Collection<I>)node.getValues());
    }

    @Override
    public void setReadonly(ValuesWidget<I> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(ValuesWidget<I> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, ValuesWidget<I> node) {
        return !node.getViewState().isImmutable() && !CollectionUtil.equals(node.getValues(), (Collection)this.getter.apply(model), (obj1, obj2) -> MiscUtil.equals((Object)obj1, (Object)obj2), (boolean)false);
    }
}

