/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.File;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.collections.ObservableList;

public class FileChooserWidgetColumn<M>
extends TableWidgetColumn<M, FileChooserWidget> {
    private final Function<M, MiscUtil.Pair<File, byte[]>> getter;
    private final BiConsumer<M, File> setter;
    private final FileChooserWidget.ChoosingMode mode;

    public FileChooserWidgetColumn(Function<M, MiscUtil.Pair<File, byte[]>> aGetter, BiConsumer<M, File> aSetter, FileChooserWidget.ChoosingMode aMode) {
        this.getter = aGetter;
        this.setter = aSetter;
        this.mode = aMode;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public FileChooserWidget createNode() {
        FileChooserWidget result = new FileChooserWidget(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setMode(this.mode);
        return result;
    }

    @Override
    public void readData(M model, FileChooserWidget node) {
        node.getFiles().clear();
        MiscUtil.Pair<File, byte[]> data = this.getter.apply(model);
        node.getFiles().addAll((Object[])new File[]{(File)data.getFirst()});
        node.setContent((byte[])data.getSecond());
    }

    @Override
    public void writeData(M model, FileChooserWidget node) {
        this.setter.accept(model, node.getFiles().size() > 0 ? (File)node.getFiles().get(0) : null);
    }

    @Override
    public void setReadonly(FileChooserWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(FileChooserWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, FileChooserWidget node) {
        return !node.getViewState().isImmutable() && this.checkFilesChanged(node.getFiles(), this.getter.apply(model));
    }

    private boolean checkFilesChanged(ObservableList<File> files, MiscUtil.Pair<File, byte[]> apply) {
        return false;
    }
}

