/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.model.system.Money;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MoneyValueWidgetColumn<M>
extends TableWidgetColumn<M, MoneyValueWidget> {
    private final Function<M, Money> getter;
    private final BiConsumer<M, Money> setter;
    private boolean fixedCurrency;

    public MoneyValueWidgetColumn(Function<M, Money> aGetter, BiConsumer<M, Money> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setFixedCurrency(boolean fixedCurrency) {
        this.fixedCurrency = fixedCurrency;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public MoneyValueWidget createNode() {
        MoneyValueWidget result = new MoneyValueWidget(this.getOwner().getViewState().isReadonly());
        result.setFixedCurrency(this.fixedCurrency);
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, MoneyValueWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, MoneyValueWidget node) {
        this.setter.accept(model, (Money)node.valueProperty().get());
    }

    @Override
    public void setReadonly(MoneyValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(MoneyValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, MoneyValueWidget node) {
        return !node.getViewState().isImmutable() && !node.hasSameValue(this.getter.apply(model));
    }
}

