/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class MultiEntityWidgetColumn<M, E extends BaseEntity>
extends TableWidgetColumn<M, MultiEntityWidget<E>> {
    protected final Class<E> entityType;
    private final Function<M, Collection<EntityReference<E>>> getter;
    private Supplier<List<EntityReference<E>>> itemsSupplier;
    private Supplier<IndexListParameters<E, ?>> listParametersSupplier;
    private MultiSupplier<IndexListParameters<E, ?>> listParametersMultiSupplier;
    private boolean noNulls;
    private boolean itemsSupplierAsync;

    public MultiEntityWidgetColumn(Class<E> cls, Function<M, Collection<EntityReference<E>>> aGetter) {
        this.entityType = cls;
        this.getter = aGetter;
    }

    public void setItemsSupplier(Supplier<List<EntityReference<E>>> supplier, boolean async) {
        this.itemsSupplier = supplier;
        this.itemsSupplierAsync = async;
        this.applyToAllRows(widget -> widget.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync));
    }

    public <I extends EntityIndex<E>> void setListParametersSupplier(Supplier<IndexListParameters<E, I>> value) {
        this.listParametersSupplier = value;
        this.applyToAllRows(widget -> widget.setListParametersSupplier(this.listParametersSupplier));
    }

    public void setListParametersSupplier(MultiSupplier<IndexListParameters<E, ?>> value) {
        this.listParametersMultiSupplier = value;
        this.applyToAllRows(widget -> widget.setListParametersSupplier(this.listParametersMultiSupplier));
    }

    public void setNoNulls(boolean value) {
        this.noNulls = value;
        this.applyToAllRows(widget -> widget.setNoNulls(this.noNulls));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public MultiEntityWidget<E> createNode() {
        MultiEntityWidget<E> result = new MultiEntityWidget<E>(this.entityType, this.getOwner().getViewState().isReadonly());
        result.setFieldName(this.getFieldName());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setMaxWidth(Double.MAX_VALUE);
        if (this.itemsSupplier != null) {
            result.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync);
        }
        if (this.listParametersSupplier != null) {
            result.setListParametersSupplier(this.listParametersSupplier);
        }
        if (this.listParametersMultiSupplier != null) {
            result.setListParametersSupplier(this.listParametersMultiSupplier);
        }
        result.setNoNulls(this.noNulls);
        return result;
    }

    @Override
    public void readData(M model, MultiEntityWidget<E> node) {
        node.getValues().setAll(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, MultiEntityWidget<E> node) {
        Collection modelValues = this.getter.apply(model);
        modelValues.clear();
        modelValues.addAll(node.getValues());
    }

    @Override
    public void setReadonly(MultiEntityWidget<E> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(MultiEntityWidget<E> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, MultiEntityWidget<E> node) {
        return !node.getViewState().isImmutable() && !CollectionUtil.equals(node.getValues(), this.getter.apply(model), (boolean)true);
    }
}

