/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.list;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.WritableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javafx.util.Pair;

class FiltersPane
extends VBox {
    private static final Duration SHOW_HIDE_ANIMATION_DURATION = Duration.millis((double)300.0);
    private final VBox contentPane;
    private final Button closeButton;
    private final Button resetButton;
    private final Button applyButton;
    private final ScrollPane scrollPane;
    private final ReadOnlyBooleanWrapper shown = new ReadOnlyBooleanWrapper(false);
    private final Map<String, List<Object>> appliedFiltersData = new HashMap<String, List<Object>>();
    private final Map<String, FilterHandler> handlers = new HashMap<String, FilterHandler>();
    private final List<IntConsumer> applyListeners = new ArrayList<IntConsumer>();
    private boolean animationInProgress = false;

    FiltersPane() {
        this.getStyleClass().addAll((Object[])new String[]{"xtrip-filters-pane", "sidepane"});
        Label titleLabel = new Label(Messages.General_Filters);
        titleLabel.getStyleClass().add((Object)"title-label");
        this.closeButton = new Button();
        this.closeButton.setGraphic((Node)new IconNode(StandardIconShapes.CANCEL, (Styleable)this.closeButton, StandardIconIntentions.CLOSE_BUTTON_ACTION, (Styleable)this.closeButton));
        this.closeButton.getStyleClass().add((Object)"close-button");
        this.closeButton.setOnAction(evt -> this.hide());
        this.resetButton = new Button(Messages.General_Reset);
        this.resetButton.getStyleClass().add((Object)"reset-button");
        this.applyButton = new Button(Messages.General_Apply);
        this.applyButton.getStyleClass().add((Object)"apply-button");
        this.applyButton.setDefaultButton(true);
        this.applyButton.setOnAction(evt -> {
            this.populateFiltersData();
            int filtersCount = this.getFiltersData().size();
            for (IntConsumer listener : this.applyListeners) {
                listener.accept(filtersCount);
            }
        });
        this.resetButton.setOnAction(evt -> {
            for (FilterHandler handler : this.handlers.values()) {
                handler.reset();
            }
            this.applyButton.fire();
        });
        BorderPane firstTitleRow = new BorderPane(null, null, (Node)this.closeButton, null, (Node)titleLabel);
        firstTitleRow.getStyleClass().add((Object)"buttons-pane");
        BorderPane secondTitleRow = new BorderPane(null, null, (Node)this.applyButton, null, (Node)this.resetButton);
        secondTitleRow.getStyleClass().add((Object)"buttons-pane");
        this.contentPane = new VBox();
        this.contentPane.setFillWidth(true);
        this.scrollPane = new ScrollPane();
        this.scrollPane.getStyleClass().addAll((Object[])new String[]{"edge-to-edge", "xtrip-scroll-pane-hidden"});
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.scrollPane.setContent((Node)this.contentPane);
        this.getChildren().addAll((Object[])new Node[]{firstTitleRow, secondTitleRow, this.scrollPane});
        this.setVisible(false);
        this.setPrefWidth(0.0);
    }

    private void populateFiltersData() {
        this.appliedFiltersData.clear();
        for (Map.Entry<String, FilterHandler> entry : this.handlers.entrySet()) {
            List<Object> data = entry.getValue().getData();
            if (data == null) continue;
            this.appliedFiltersData.put(entry.getKey(), data);
        }
    }

    private void show() {
        if (this.isShown() || this.animationInProgress) {
            return;
        }
        this.animationInProgress = true;
        this.setVisible(true);
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        KeyValue kv = new KeyValue((WritableValue)this.prefWidthProperty(), (Object)this.scrollPane.getMaxWidth(), Interpolator.EASE_OUT);
        KeyFrame kf = new KeyFrame(SHOW_HIDE_ANIMATION_DURATION, new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.setOnFinished(e -> {
            Styles.removeStyle((Styleable)this.scrollPane, "xtrip-scroll-pane-hidden");
            Styles.addStyle((Styleable)this.scrollPane, "xtrip-scroll-pane-shown");
            this.shown.set(true);
            this.animationInProgress = false;
        });
        timeline.play();
    }

    private void hide() {
        if (!this.isShown() || this.animationInProgress) {
            return;
        }
        this.animationInProgress = true;
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        KeyValue kv = new KeyValue((WritableValue)this.prefWidthProperty(), (Object)this.scrollPane.getMinWidth(), Interpolator.EASE_OUT);
        KeyFrame kf = new KeyFrame(SHOW_HIDE_ANIMATION_DURATION, new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.setOnFinished(e -> {
            Styles.removeStyle((Styleable)this.scrollPane, "xtrip-scroll-pane-shown");
            Styles.addStyle((Styleable)this.scrollPane, "xtrip-scroll-pane-hidden");
            this.shown.set(false);
            this.setVisible(false);
            this.animationInProgress = false;
        });
        timeline.play();
    }

    void populate(List<Pair<TableColumnSettings, FilterHandler>> filtes) {
        this.handlers.clear();
        this.contentPane.getChildren().clear();
        for (Pair<TableColumnSettings, FilterHandler> pair : filtes) {
            this.handlers.put(((TableColumnSettings)pair.getKey()).getId(), (FilterHandler)pair.getValue());
            ((FilterHandler)pair.getValue()).build((Pane)this.contentPane);
        }
        this.populateFiltersData();
    }

    Map<String, List<Object>> getFiltersData() {
        return this.appliedFiltersData;
    }

    void setFiltersData(Map<String, List<Object>> value) {
        Iterator<Map.Entry<String, FilterHandler>> iterator = this.handlers.entrySet().iterator();
        while (iterator.hasNext()) {
            List<Object> data;
            Map.Entry<String, FilterHandler> entry;
            entry.getValue().setData((data = value.get((entry = iterator.next()).getKey())) == null ? Collections.emptyList() : data);
        }
        this.populateFiltersData();
    }

    void addApplyListener(IntConsumer listener) {
        this.applyListeners.add(listener);
    }

    ReadOnlyBooleanProperty shownProperty() {
        return this.shown.getReadOnlyProperty();
    }

    boolean isShown() {
        return this.shown.get();
    }

    void showHide() {
        if (this.isShown()) {
            this.hide();
        } else {
            this.show();
        }
    }
}

