/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.list;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.Action;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindings;
import com.gridnine.xtrip.client.fx.core.kb.ShortcutHandler;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.SearchTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsSupport;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.ProjectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.FiltersPane;
import com.gridnine.xtrip.client.fx.core.list.ListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import com.gridnine.xtrip.client.fx.core.list.ProjectionsPane;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasPersistableState;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.shape.Rectangle;
import javafx.util.Pair;
import javafx.util.StringConverter;
import org.jboss.remoting.CannotConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListPane<I, C extends ListPaneConfiguration>
extends BaseContentPane
implements HasPersistableState,
ShortcutHandler {
    public static final boolean PROJECTIONS_ENABLED = "true".equalsIgnoreCase(System.getProperty("client.fx.listPane.projectionsEnabled", "true"));
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    final MultiSupplier<C> configurator;
    private final ObservableMutex mutex;
    private final ReadOnlyBooleanWrapper selectionPresent = new ReadOnlyBooleanWrapper(false);
    CustomTableView<I> tableView;
    int offset = 0;
    private int configurationIndex;
    private C configuration;
    private SearchTextField patternField;
    private FiltersPane filtersPane;
    private Button filterButton;
    private ActionsPane<?> actionsPane;
    private ProjectionsPane projectionsPane;
    private final ChangeListener<? super Boolean> acquiredListener;

    protected ListPane(MultiSupplier<C> supplier, ObservableMutex mtx) {
        this.configurator = supplier;
        this.mutex = mtx;
        this.acquiredListener = (s, o, n) -> {
            if (this.actionsPane != null) {
                this.actionsPane.revalidate();
            }
            if (this.tableView != null && this.tableView.getItems().isEmpty()) {
                this.tableView.setPlaceholder((Node)new Label(n != false ? Messages.General_Data_loading : Messages.General_No_data_for_view));
            }
        };
        this.mutex.acquiredProperty().addListener(this.acquiredListener);
        this.getStyleClass().add((Object)"xtrip-list-pane");
        if (supplier.count() <= 0) {
            FxUtil.submitToFxThread(() -> this.composePane(ContentError.BAD_CONFIGURATION.createNode(""), null, null, null));
        }
    }

    @Override
    public void dispose() {
        this.mutex.acquiredProperty().removeListener(this.acquiredListener);
        super.dispose();
    }

    @Override
    public void handleShortcut(KeyEvent event) {
        if (this.mutex.isAcquired()) {
            return;
        }
        KeyBindings kb = KeyBindings.get();
        if (kb.getKeyCombination(StandardKeyBindingActions.RELOAD).match(event)) {
            this.reloadData();
            event.consume();
        } else if (kb.getKeyCombination(StandardKeyBindingActions.SEARCH).match(event)) {
            if (this.patternField != null) {
                this.patternField.requestFocus();
                this.patternField.selectAll();
                event.consume();
            }
        } else if (this.actionsPane != null) {
            this.actionsPane.handleShortcut(event);
        }
    }

    public void selectConfiguration(int idx) {
        if (this.configurator.count() <= 0) {
            return;
        }
        this.configurationIndex = idx;
        this.configuration = (ListPaneConfiguration)this.configurator.get(idx);
        AclQuery aclQuery = this.getListACLQuery();
        if (aclQuery == null) {
            this.populateConfiguration();
            this.scheduleReloadData();
            return;
        }
        Notifications.get().submitTask(() -> {
            if (this.isDisposed() || this.configurationIndex != idx) {
                return;
            }
            Set<String> grantedIds = FxAclUtil.applyACL(Collections.singletonMap("list-type", aclQuery));
            FxUtil.submitToFxThread(() -> {
                if (grantedIds.contains("list-type")) {
                    this.populateConfiguration();
                    this.scheduleReloadData();
                } else {
                    this.populateDeniedConfiguration(idx);
                }
            });
        }, this.mutex);
    }

    private void scheduleReloadData() {
        if (this.getScene() != null) {
            this.reloadData();
            return;
        }
        this.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                if (newValue != null) {
                    ListPane.this.sceneProperty().removeListener((ChangeListener)this);
                    ListPane.this.reloadData();
                }
            }
        });
    }

    public final CustomTableView<I> getTableView() {
        return this.tableView;
    }

    public final List<I> getSelectedItems() {
        return this.tableView.getSelectionModel().getSelectedItems();
    }

    public final ReadOnlyBooleanProperty selectionPresentProperty() {
        return this.selectionPresent.getReadOnlyProperty();
    }

    public final ObservableMutex getMutex() {
        return this.mutex;
    }

    public final void reloadData() {
        Notifications.get().submitTask(() -> {
            if (this.isDisposed()) {
                return;
            }
            String queryInfo = this.getQueryInfo();
            this.log.debug(queryInfo);
            try {
                this.loadData((data, newOffset) -> FxUtil.runInFxThread(() -> this.populateData((List<I>)data, newOffset)));
            }
            catch (CannotConnectException cce) {
                throw new Xeption(L10nResourcesManager.createL10nMessage((String)Messages.General_Receiving_data_failed, (Object[])new Object[0]), null, queryInfo, (Throwable)cce);
            }
        }, this.mutex);
    }

    public final C getConfiguration() {
        return this.configuration;
    }

    protected final int getOffset() {
        return this.offset;
    }

    protected final Map<String, SortOrder> getSortOrder() {
        LinkedHashMap<String, SortOrder> result = new LinkedHashMap<String, SortOrder>();
        if (this.tableView != null) {
            for (TableColumn column : this.tableView.getSortOrder()) {
                TableColumn.SortType sortType = column.getSortType();
                result.put(((TableColumnSettings)column.getUserData()).getId(), sortType == TableColumn.SortType.ASCENDING ? SortOrder.ASC : SortOrder.DESC);
            }
        }
        return result;
    }

    protected final String getPatternText() {
        return this.patternField == null ? null : this.patternField.getText();
    }

    protected final Map<String, List<Object>> getFiltersData() {
        return this.filtersPane == null ? Collections.emptyMap() : this.filtersPane.getFiltersData();
    }

    protected final ActionsPane<?> getActionsPane() {
        return this.actionsPane;
    }

    protected void newConfigurationPopulated() {
    }

    protected void collectAdminTools(List<MenuItem> items) {
        CustomMenuItem item = new CustomMenuItem("UI Technical Data");
        item.setOnAction(evt -> {
            StringBuilder buf = new StringBuilder();
            this.buildConfigurationInfo(buf, this.getConfiguration());
            TextAreaWidget widget = new TextAreaWidget(true);
            widget.setValue(buf.toString());
            widget.setMonospace(true);
            widget.getViewState().setNotEditable(true);
            new Dialog().setTitle("List UI Technical Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this);
        });
        items.add((MenuItem)item);
    }

    protected void buildConfigurationInfo(StringBuilder buf, C config) {
        buf.append("Number of available configurations: ").append(this.configurator.count()).append('\n');
        buf.append("Configuration class: ").append(config.getClass().getName()).append('\n');
        buf.append("Columns [id/type/renderer]:\n");
        if (config.getColumnsSettings().isEmpty()) {
            buf.append("\tno columns configured\n");
        } else {
            for (TableColumnSettings col : config.getColumnsSettings()) {
                buf.append('\t').append(col.getId()).append('/').append(col.getType()).append('/').append(col.getRenderer()).append('\n');
            }
        }
        buf.append("Filters [id/type]:\n");
        if (config.getFiltersSettings().isEmpty()) {
            buf.append("\tno filters configured\n");
        } else {
            for (TableColumnSettings col : config.getFiltersSettings()) {
                buf.append('\t').append(col.getId()).append('/').append(col.getType()).append('\n');
            }
        }
    }

    protected void setProjectionValues(List<Pair<ProjectionField, String>> data) {
        if (this.projectionsPane != null) {
            this.projectionsPane.setValues(data);
        }
    }

    protected abstract void loadData(ObjIntConsumer<List<I>> var1) throws Exception;

    protected abstract String getQueryInfo();

    protected abstract Object getItemValue(I var1, String var2);

    protected abstract ActionsPane<?> createActionsPane();

    protected abstract <A extends Action<?>> void executeAction(Control var1, A var2);

    protected abstract AclQuery getListACLQuery();

    private void populateDeniedConfiguration(int idx) {
        GridPane headerPane = null;
        if (this.configurator.count() > 1) {
            headerPane = new GridPane();
            headerPane.getStyleClass().add((Object)"xtrip-tool-pane");
            headerPane.addRow(0, new Node[]{this.createConfigurationSelector(idx)});
        }
        this.composePane(ContentError.ACCESS_DENIED.createNode(""), (Node)headerPane, null, null);
    }

    private void populateConfiguration() {
        this.offset = 0;
        this.tableView = new CustomTableView();
        this.tableView.getSelectionModel().setSelectionMode(this.configuration.getSelectionMode());
        this.tableView.getSelectionModel().getSelectedItems().addListener(change -> {
            this.selectionPresent.set(this.tableView.getSelectionModel().getSelectedIndices().size() > 0);
            if (this.actionsPane != null) {
                this.actionsPane.revalidate();
            }
        });
        this.tableView.setPlaceholder((Node)new Label(this.mutex.isAcquired() ? Messages.General_Data_loading : Messages.General_No_data_for_view));
        ArrayList columns = new ArrayList();
        for (TableColumnSettings tableColumnSettings : this.configuration.getColumnsSettings()) {
            columns.add(this.createTableColumn(tableColumnSettings));
        }
        ArrayList<TableColumn> sortColumns = new ArrayList<TableColumn>();
        block3: for (Map.Entry<String, SortOrder> entry : this.configuration.getSorting().entrySet()) {
            for (TableColumn tableColumn : columns) {
                if (!entry.getKey().equals(tableColumn.getId())) continue;
                tableColumn.setSortable(true);
                tableColumn.setSortType(entry.getValue() == SortOrder.ASC ? TableColumn.SortType.ASCENDING : TableColumn.SortType.DESCENDING);
                sortColumns.add(tableColumn);
                continue block3;
            }
        }
        this.tableView.getSortOrder().addAll(sortColumns);
        this.tableView.getColumns().addAll(columns);
        this.tableView.setOnSort(evt -> {
            evt.consume();
            this.reloadData();
        });
        ArrayList<Object> nodes = new ArrayList<Object>();
        if (this.configurator.count() > 1) {
            nodes.add(this.createConfigurationSelector(this.configurationIndex));
        } else {
            String string = this.configurator.getDisplayName(0);
            if (!TextUtil.isBlank((String)string)) {
                CustomLabel customLabel = new CustomLabel(string);
                customLabel.getStyleClass().add((Object)"configuration-name");
                nodes.add((Object)customLabel);
            }
        }
        Button button = new Button();
        button.setGraphic((Node)new IconNode(StandardIconShapes.RELOAD_12x12, (Styleable)button, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button));
        button.getStyleClass().add((Object)"xtrip-button");
        GridPane.setHgrow((Node)button, (Priority)Priority.NEVER);
        button.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
        button.setOnAction(evt -> this.reloadData());
        UiUtil.setTooltip((Node)button, Messages.General_Refresh_data);
        nodes.add(button);
        Button button2 = new Button();
        button2.setGraphic((Node)new IconNode(StandardIconShapes.LIST_BEGIN_12x12, (Styleable)button2, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button2));
        button2.getStyleClass().add((Object)"xtrip-button");
        GridPane.setHgrow((Node)button2, (Priority)Priority.NEVER);
        button2.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{ListPane.this.getMutex().acquiredProperty()});
            }

            protected boolean computeValue() {
                return ListPane.this.getMutex().isAcquired() || ListPane.this.getOffset() <= 0;
            }
        });
        button2.setOnAction(evt -> {
            this.offset = 0;
            this.reloadData();
        });
        UiUtil.setTooltip((Node)button2, Messages.General_Go_to_first_page);
        nodes.add(button2);
        Button button3 = new Button();
        button3.setGraphic((Node)new IconNode(StandardIconShapes.LIST_PREV_14x14, (Styleable)button3, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button3));
        button3.getStyleClass().add((Object)"xtrip-button");
        GridPane.setHgrow((Node)button3, (Priority)Priority.NEVER);
        button3.disableProperty().bind((ObservableValue)button2.disabledProperty());
        button3.setOnAction(evt -> {
            this.offset -= this.configuration.getLimit();
            if (this.offset < 0) {
                this.offset = 0;
            }
            this.reloadData();
        });
        UiUtil.setTooltip((Node)button3, Messages.General_Go_to_previous_page);
        nodes.add(button3);
        Button button4 = new Button();
        button4.setGraphic((Node)new IconNode(StandardIconShapes.LIST_NEXT_14x14, (Styleable)button4, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button4));
        button4.getStyleClass().add((Object)"xtrip-button");
        GridPane.setHgrow((Node)button4, (Priority)Priority.NEVER);
        button4.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{ListPane.this.getMutex().acquiredProperty()});
            }

            protected boolean computeValue() {
                return ListPane.this.getMutex().isAcquired() || ListPane.this.getTableView().getItems().size() < ListPane.this.getConfiguration().getLimit();
            }
        });
        button4.setOnAction(evt -> {
            this.offset += this.configuration.getLimit();
            this.reloadData();
        });
        UiUtil.setTooltip((Node)button4, Messages.General_Go_to_next_page);
        nodes.add(button4);
        Label label = new Label();
        label.getStyleClass().add((Object)"xtrip-page-label");
        GridPane.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        label.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
        label.textProperty().bind((ObservableValue)new StringBinding(){
            {
                this.bind(new Observable[]{ListPane.this.tableView.getItems()});
            }

            protected String computeValue() {
                ObservableList data = ListPane.this.tableView.getItems();
                return data.isEmpty() ? "0 - 0" : ListPane.this.offset + 1 + " - " + (ListPane.this.offset + data.size()) + " " + Messages.General_Entries;
            }
        });
        nodes.add(label);
        if (this.configuration.isPatternSearchEnabled()) {
            this.patternField = new SearchTextField(){

                public void clear() {
                    super.clear();
                    ListPane.this.offset = 0;
                    ListPane.this.reloadData();
                }
            };
            this.patternField.getStyleClass().add((Object)"xtrip-pattern-field");
            GridPane.setHgrow((Node)this.patternField, (Priority)Priority.NEVER);
            Tooltip.install((Node)this.patternField.getLeft(), (Tooltip)new Tooltip(Messages.General_Enter_text_to_find));
            this.patternField.editableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.mutex.acquiredProperty()));
            this.patternField.setOnAction(evt -> {
                this.offset = 0;
                this.reloadData();
            });
            this.patternField.focusedProperty().addListener((obj, o, n) -> {
                if (n.booleanValue()) {
                    this.tableView.getSelectionModel().clearSelection();
                }
            });
            nodes.add((Object)this.patternField);
        } else {
            this.patternField = null;
        }
        if (!this.configuration.getFiltersSettings().isEmpty()) {
            Function<String, Supplier<List<?>>> function = this.getFilterItemsSuppliers();
            ArrayList<Pair<TableColumnSettings, FilterHandler>> filters = new ArrayList<Pair<TableColumnSettings, FilterHandler>>();
            for (TableColumnSettings filter : this.configuration.getFiltersSettings()) {
                try {
                    FilterHandler handler = this.createFilterHandler(filter, function.apply(filter.getId()));
                    if (handler == null) continue;
                    filters.add((Pair<TableColumnSettings, FilterHandler>)new Pair((Object)filter, (Object)handler));
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
            }
            this.filtersPane = new FiltersPane();
            this.filtersPane.populate(filters);
            this.filtersPane.shownProperty().addListener(obj -> this.updateFilterCaption());
            this.filtersPane.addApplyListener(count -> {
                this.updateFilterCaption();
                this.offset = 0;
                this.reloadData();
            });
            this.filterButton = new Button();
            this.filterButton.setGraphic((Node)new IconNode(StandardIconShapes.LIST_FILTER_12x12, (Styleable)this.filterButton, StandardIconIntentions.LIST_FILTER_BUTTON_ACTION, (Styleable)this.filterButton));
            this.filterButton.getStyleClass().add((Object)"xtrip-button");
            UiUtil.setTooltip((Node)this.filterButton, this.getFilterTooltipText());
            this.filterButton.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
            this.filterButton.setOnAction(evt -> this.filtersPane.showHide());
            nodes.add(this.filterButton);
            this.updateFilterCaption();
        } else {
            this.filtersPane = null;
        }
        GridPane headerPane = new GridPane();
        headerPane.getStyleClass().add((Object)"xtrip-tool-pane");
        headerPane.addRow(0, nodes.toArray(new Node[nodes.size()]));
        this.actionsPane = this.configuration.isActionsEnabled() ? this.createActionsPane() : null;
        this.tableView.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
            boolean isTargetRectangle = evt.getTarget().getClass().isAssignableFrom(Rectangle.class);
            if (evt.getClickCount() > 1 && !isTargetRectangle) {
                this.executeDefaultAction((Control)evt.getSource());
            }
        });
        this.tableView.addEventHandler(KeyEvent.KEY_RELEASED, evt -> {
            if (!this.tableView.getSelectionModel().getSelectedCells().isEmpty() && evt.getCode() == KeyCode.ENTER) {
                this.executeDefaultAction((Control)evt.getSource());
            }
        });
        headerPane.setOnMouseClicked(evt -> {
            if (!evt.isAltDown() || evt.getClickCount() != 1 || evt.getButton() != MouseButton.PRIMARY) {
                return;
            }
            ArrayList<MenuItem> items = new ArrayList<MenuItem>();
            this.collectAdminTools(items);
            if (items.isEmpty()) {
                return;
            }
            CustomContextMenu menu = new CustomContextMenu();
            menu.getItems().addAll(items);
            menu.show((Node)headerPane, evt.getScreenX(), evt.getScreenY());
        });
        this.projectionsPane = !PROJECTIONS_ENABLED || this.configuration.getProjections().isEmpty() ? null : new ProjectionsPane(this.configuration.getProjections());
        this.newConfigurationPopulated();
        this.composePane((Node)(this.projectionsPane == null ? this.tableView : new BorderPane(this.tableView, null, null, (Node)this.projectionsPane, null)), (Node)headerPane, this.actionsPane, (Node)this.filtersPane);
    }

    protected FilterHandler createFilterHandler(TableColumnSettings filter, Supplier<List<?>> itemsSupplier) throws Exception {
        return ListPaneFilterFactory.getFor(filter, itemsSupplier);
    }

    protected Function<String, Supplier<List<?>>> getFilterItemsSuppliers() {
        return id -> null;
    }

    protected void executeDefaultAction(Control source) {
        if (this.actionsPane == null) {
            return;
        }
        Object action = this.actionsPane.getDefaultAction();
        if (action != null) {
            this.executeAction(source, (Action)action);
        }
    }

    private CustomComboBox<Integer> createConfigurationSelector(int idx) {
        CustomComboBox<Integer> result = new CustomComboBox<Integer>();
        result.getStyleClass().add((Object)"xtrip-category-box");
        GridPane.setHgrow(result, (Priority)Priority.NEVER);
        result.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
        result.setConverter((StringConverter)new StringConverter<Integer>(){

            public String toString(Integer object) {
                return ListPane.this.configurator.getDisplayName(object);
            }

            public Integer fromString(String string) {
                return null;
            }
        });
        ArrayList<Integer> items = new ArrayList<Integer>(this.configurator.count());
        for (int i = 0; i < this.configurator.count(); ++i) {
            items.add(i);
        }
        SuggestionsSupport.installSuggestions(result, new SimpleSuggestionsHandler(result.getConverter(), () -> items, false));
        result.setValue(idx);
        result.getItems().setAll(items);
        result.valueProperty().addListener((crs, o, n) -> {
            if (n == null) {
                IncidentsLog.reportStackTrace((String)this.toString());
            } else {
                this.selectConfiguration((int)n);
            }
        });
        result.setNoNulls(true);
        return result;
    }

    private void updateFilterCaption() {
        Map<String, List<Object>> filters = this.getFiltersData();
        String filtersHint = "";
        if (filters.isEmpty()) {
            this.filterButton.setText(null);
        } else {
            this.filterButton.setText(String.format("%d %s", filters.size(), this.filterCaption(filters.size())));
            filtersHint = filtersHint + String.format("%d %s:", filters.size(), this.activeFilterCaption(filters.size()));
        }
        for (Map.Entry<String, List<Object>> entry : filters.entrySet()) {
            String fieldId = entry.getKey();
            List<Object> value = entry.getValue();
            TableColumnSettings sett = this.findFilterSettings(fieldId);
            String fieldName = sett == null ? fieldId : sett.getDisplayName();
            StandardRenderers renderer = sett == null || sett.getRenderer() == null ? StandardRenderers.GENERIC : sett.getRenderer();
            String caption = value.size() == 1 ? String.format("%s: %s", fieldName, renderer.apply(value.get(0))) : String.format("%s: %s - %s", fieldName, renderer.apply(value.get(0)), renderer.apply(value.get(1)));
            filtersHint = filtersHint + '\n' + caption;
        }
        UiUtil.setTooltip((Node)this.filterButton, this.getFilterTooltipText() + '\n' + filtersHint);
    }

    private String getFilterTooltipText() {
        return this.filtersPane.isShown() ? Messages.General_Hide_filters : Messages.General_Show_filters;
    }

    private TableColumnSettings findFilterSettings(String id) {
        for (TableColumnSettings settings : this.configuration.getFiltersSettings()) {
            if (!settings.getId().equals(id)) continue;
            return settings;
        }
        return null;
    }

    private String filterCaption(int count) {
        if (count == 1) {
            return Messages.General_Filter;
        }
        if (count < 5) {
            return Messages.General_Filter1;
        }
        return Messages.General_Filter2;
    }

    private String activeFilterCaption(int count) {
        if (count == 1) {
            return Messages.General_Active_filter;
        }
        if (count < 5) {
            return Messages.General_Active_filter1;
        }
        return Messages.General_Active_filter2;
    }

    private final void populateData(List<I> data, int newOffset) {
        if (this.isDisposed()) {
            return;
        }
        this.offset = newOffset;
        if (this.offset > 0 && data.isEmpty()) {
            this.offset -= this.configuration.getLimit();
            this.reloadData();
            return;
        }
        this.tableView.getItems().setAll(data);
        this.tableView.scrollTo(0);
        this.tableView.refresh();
        if (this.actionsPane != null) {
            this.actionsPane.revalidate();
        }
    }

    protected TableColumn<I, ?> createTableColumn(TableColumnSettings colSettings) {
        return colSettings.createColumn(item -> this.getItemValue(item, colSettings.getId()));
    }

    @Override
    public Serializable persistState() {
        PersistableState result = new PersistableState();
        result.selectedConfigurationIndex = this.configurationIndex;
        result.offset = this.offset;
        result.sortOrder = this.getSortOrder();
        if (this.patternField != null) {
            result.pattern = this.patternField.getText();
        }
        if (this.filtersPane != null) {
            result.filtersData = this.filtersPane.getFiltersData();
        }
        return result;
    }

    @Override
    public void restoreState(Serializable data) {
        Notifications.get().submitTask(() -> FxUtil.submitToFxThread(() -> {
            PersistableState state = (PersistableState)data;
            if (this.configurationIndex != state.selectedConfigurationIndex && state.selectedConfigurationIndex < this.configurator.count()) {
                this.configurationIndex = state.selectedConfigurationIndex;
                this.configuration = (ListPaneConfiguration)this.configurator.get(this.configurationIndex);
                this.populateConfiguration();
            }
            this.offset = state.offset;
            if (this.tableView != null && state.sortOrder != null) {
                ArrayList<TableColumn> sortColumns = new ArrayList<TableColumn>();
                block0: for (Map.Entry<String, SortOrder> entry : state.sortOrder.entrySet()) {
                    for (TableColumn col : this.tableView.getColumns()) {
                        if (!entry.getKey().equals(col.getId())) continue;
                        col.setSortable(true);
                        col.setSortType(entry.getValue() == SortOrder.ASC ? TableColumn.SortType.ASCENDING : TableColumn.SortType.DESCENDING);
                        sortColumns.add(col);
                        continue block0;
                    }
                }
                this.tableView.getSortOrder().setAll(sortColumns);
            }
            if (this.patternField != null) {
                this.patternField.setText(state.pattern);
            }
            if (this.filtersPane != null && state.filtersData != null) {
                this.filtersPane.setFiltersData(state.filtersData);
                this.updateFilterCaption();
            }
            this.scheduleReloadData();
        }), this.mutex);
    }

    private static class PersistableState
    implements Serializable {
        int selectedConfigurationIndex;
        int offset;
        Map<String, SortOrder> sortOrder;
        String pattern;
        Map<String, List<Object>> filtersData;

        PersistableState() {
        }
    }
}

