/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.list.filter;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.TripleValueWidget;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

class BooleanValueFilterFactory
implements ListPaneFilterFactory {
    BooleanValueFilterFactory() {
    }

    @Override
    public boolean isApplicableTo(TableColumnSettings settings) {
        return "boolean".equals(settings.getType());
    }

    @Override
    public FilterHandler createFor(final TableColumnSettings settings, Supplier<List<?>> itemsSupplier) throws Exception {
        return new FilterHandler(){
            private TripleValueWidget control;

            @Override
            public void reset() {
                this.control.setValue(null);
            }

            @Override
            public List<Object> getData() {
                if (this.control.getValue() != null) {
                    return Collections.singletonList(this.control.getValue());
                }
                return null;
            }

            @Override
            public void setData(List<Object> value) {
                if (value.isEmpty()) {
                    this.reset();
                } else {
                    this.control.setValue((Boolean)value.get(0));
                }
            }

            @Override
            public void build(Pane pane) {
                this.control = new TripleValueWidget(false, false);
                FilterHandler.buildFilter(pane, settings.getDisplayName(), (Node)this.control);
            }
        };
    }
}

