/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.list.filter;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.layout.Pane;

class DictFilterFactory
implements ListPaneFilterFactory {
    DictFilterFactory() {
    }

    @Override
    public boolean isApplicableTo(TableColumnSettings settings) {
        return MetaRegistry.get().getDictionaries().containsKey(settings.getType());
    }

    @Override
    public FilterHandler createFor(final TableColumnSettings settings, final Supplier<List<?>> itemsSupplier) throws Exception {
        final Class type = XSHelper.getClass((String)settings.getType());
        return new FilterHandler(){
            private DictBoxWidget<BaseDictionary> control;

            @Override
            public void reset() {
                this.control.setValue(null);
            }

            @Override
            public List<Object> getData() {
                if (this.control.getValue() != null) {
                    return Collections.singletonList(this.control.getValue());
                }
                return null;
            }

            @Override
            public void setData(List<Object> value) {
                if (value.isEmpty()) {
                    this.reset();
                } else {
                    this.control.setValue((DictionaryReference<BaseDictionary>)((DictionaryReference)value.get(0)));
                }
            }

            @Override
            public void build(Pane pane) {
                this.control = new DictBoxWidget(type, false);
                if (itemsSupplier != null) {
                    this.control.setItemsSupplier(itemsSupplier, true);
                }
                this.control.setFieldName(settings.getDisplayName());
                FilterHandler.buildFilter(pane, settings.getDisplayName(), this.control);
            }
        };
    }
}

