/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.list.filter;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.LocaleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

class LocaleFilterFactory
implements ListPaneFilterFactory {
    LocaleFilterFactory() {
    }

    @Override
    public boolean isApplicableTo(TableColumnSettings settings) {
        return Locale.class.getName().equals(settings.getType());
    }

    @Override
    public FilterHandler createFor(final TableColumnSettings settings, final Supplier<List<?>> itemsSupplier) throws Exception {
        return new FilterHandler(){
            private HasValue<Locale> control;

            @Override
            public void reset() {
                this.control.valueProperty().set(null);
            }

            @Override
            public List<Object> getData() {
                Locale value = (Locale)this.control.valueProperty().get();
                return value == null ? null : Collections.singletonList(value);
            }

            @Override
            public void setData(List<Object> value) {
                if (value.isEmpty()) {
                    this.reset();
                } else {
                    this.control.valueProperty().set((Object)((Locale)value.get(0)));
                }
            }

            @Override
            public void build(Pane pane) {
                StackPane node;
                if (itemsSupplier != null) {
                    ComboBoxWidget<Locale> widget = new ComboBoxWidget<Locale>(false);
                    widget.setItemsSupplier(itemsSupplier);
                    widget.setAsync(true);
                    SimpleSuggestionsHandler suggestionsHandler = new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems());
                    suggestionsHandler.setAsync(true);
                    widget.setSuggestionsHandler(suggestionsHandler);
                    node = widget;
                    this.control = widget;
                } else {
                    LocaleValueWidget widget;
                    node = widget = new LocaleValueWidget(false);
                    this.control = widget;
                }
                FilterHandler.buildFilter(pane, settings.getDisplayName(), (Node)node);
            }
        };
    }
}

