/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.registry;

import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.model.Xeption;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class ClientRegistry
implements Disposable {
    private final Map<RegistryItemType<?>, Map<String, RegistryItem<?>>> all = new HashMap();
    private final ConcurrentMap<String, Function<String, String>> resMap = new ConcurrentHashMap<String, Function<String, String>>();

    public static ClientRegistry get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (ClientRegistry)Environment.getPublished(ClientRegistry.class);
    }

    public void dispose() {
        this.all.clear();
    }

    public void register(RegistryItem<?> item) {
        Map<String, RegistryItem<?>> map = this.all.get(item.getType());
        if (map == null) {
            map = new LinkedHashMap();
            this.all.put(item.getType(), map);
        }
        if (map.containsKey(item.getId())) {
            throw Xeption.forDeveloper((String)"duplicate registry item registering: type={0}, ID={1}", (Object[])new Object[]{item.getType(), item.getId()});
        }
        map.put(item.getId(), item);
    }

    public void register(RegistryItem<?> ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (RegistryItem<?> item : items) {
            if (item == null) continue;
            this.register(item);
        }
    }

    public Set<RegistryItemType<?>> getTypes() {
        return this.all.keySet();
    }

    public <T extends RegistryItem<?>> Map<String, T> allOf(RegistryItemType<T> type) {
        Map<String, RegistryItem<?>> result = this.all.get(type);
        return result == null ? Collections.emptyMap() : result;
    }

    public String getResourceFor(RegistryItem<?> item, String suffix) {
        return this.getResources(item).apply(item.getId() + '.' + suffix);
    }

    private Function<String, String> getResources(RegistryItem<?> item) {
        String key = item.getClass().getPackage().getName() + '.' + item.getType();
        Function<String, String> result = (Function<String, String>)this.resMap.get(key);
        if (result != null) {
            return result;
        }
        URL url = item.getClass().getResource("l10n/");
        if (url == null) {
            result = resKey -> null;
        } else {
            Resources resources = new Resources(url, item.getType().toString());
            result = arg_0 -> ((Resources)resources).findResource(arg_0);
        }
        Function<String, String> prev = this.resMap.putIfAbsent(key, result);
        return prev == null ? result : prev;
    }

    private static class Holder {
        public static final ClientRegistry INSTANCE = (ClientRegistry)Environment.getPublished(ClientRegistry.class);

        private Holder() {
        }
    }
}

