/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.registry.basic;

import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.util.StringConverter;

public interface Renderer
extends RegistryItem<Renderer>,
Function<Object, String> {
    public static final RegistryItemType<Renderer> TYPE = new RegistryItemType("RENDERER");

    public static Renderer forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    @Override
    default public RegistryItemType<Renderer> getType() {
        return TYPE;
    }

    default public <T> StringConverter<T> createConverter() {
        return this.createConverter(() -> UiUtil.NULL_TEXT);
    }

    default public <T> StringConverter<T> createStatefulConverter(Supplier<Boolean> readonlyStateSupplier) {
        return this.createConverter(() -> (Boolean)readonlyStateSupplier.get() != false ? "\u2014" : UiUtil.NULL_TEXT);
    }

    default public <T> StringConverter<T> createConverter(final Supplier<String> def) {
        return new StringConverter<T>(){

            public String toString(T object) {
                return object == null && def != null ? (String)def.get() : (String)Renderer.this.apply(object);
            }

            public T fromString(String string) {
                return null;
            }
        };
    }
}

