/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.registry.basic;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.ThreadLocalFormat;
import com.gridnine.xtrip.common.l10n.model.LocaleData;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum StandardRenderers implements Renderer
{
    GENERIC{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 1.toString((Iterable)obj, item -> item.toString()) : obj.toString();
        }
    }
    ,
    GENERIC_SORTING{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            if (obj instanceof Set) {
                return 2.toStringSorted((Set)obj, item -> item.toString());
            }
            return obj instanceof Iterable ? 2.toString((Iterable)obj, item -> item.toString()) : obj.toString();
        }
    }
    ,
    CODE_VARIANTS{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            if (!(obj instanceof Map)) {
                return obj.toString();
            }
            return ((Map)obj).entrySet().stream().sorted((entry1, entry2) -> String.valueOf(entry1.getKey()).compareTo(String.valueOf(entry2.getKey()))).map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining("; "));
        }
    }
    ,
    TRANSLATIONS{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            if (!(obj instanceof Map)) {
                return obj.toString();
            }
            return ((Map)obj).entrySet().stream().sorted((entry1, entry2) -> String.valueOf(entry1.getKey()).compareTo(String.valueOf(entry2.getKey()))).map(entry -> (String)entry.getValue()).collect(Collectors.joining(", "));
        }
    }
    ,
    SPELL_VARIANTS{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            if (!(obj instanceof List)) {
                return obj.toString();
            }
            return String.join((CharSequence)", ", (List)obj);
        }
    }
    ,
    BOOLEAN{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            if (!(obj instanceof Boolean)) {
                return obj.toString();
            }
            return (Boolean)obj != false ? Messages.General_Yes : Messages.General_No;
        }
    }
    ,
    UPDATE{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            if (!(obj instanceof Boolean)) {
                return obj.toString();
            }
            return (Boolean)obj != false ? Messages.General_Dont_Update : Messages.General_Update;
        }
    }
    ,
    DICT_CODE{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 8.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (!(obj instanceof DictionaryReference)) {
                return obj.toString();
            }
            return ((DictionaryReference)obj).getCode();
        }
    }
    ,
    DICT_CAPTION{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 9.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (!(obj instanceof DictionaryReference)) {
                return obj.toString();
            }
            DictionaryReference ref = (DictionaryReference)obj;
            return TextUtil.isBlank((String)ref.getCaption()) ? ref.getCode() : ref.getCaption();
        }
    }
    ,
    PRICE{
        private final ThreadLocalFormat<NumberFormat> format = new ThreadLocalFormat<NumberFormat>(){

            @Override
            protected NumberFormat create(LocaleData data) {
                return data.getPriceFormat();
            }
        };

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 10.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (!(obj instanceof Number)) {
                return obj.toString();
            }
            return this.format.get().format(obj);
        }
    }
    ,
    NUMBER_NON_INTEGRAL{
        private final ThreadLocalFormat<NumberFormat> format = new ThreadLocalFormat<NumberFormat>(){

            @Override
            protected NumberFormat create(LocaleData data) {
                return data.getNumberFormat();
            }
        };

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 11.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (!(obj instanceof Number)) {
                return obj.toString();
            }
            return this.format.get().format(obj);
        }
    }
    ,
    NUMBER_INTEGRAL{
        private final ThreadLocalFormat<NumberFormat> format = new ThreadLocalFormat<NumberFormat>(){

            @Override
            protected NumberFormat create(LocaleData data) {
                DecimalFormat result = new DecimalFormat("#,##0");
                DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                dfs.setGroupingSeparator(' ');
                result.setDecimalFormatSymbols(dfs);
                return result;
            }
        };

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 12.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (!(obj instanceof Number)) {
                return obj.toString();
            }
            return this.format.get().format(obj);
        }
    }
    ,
    DATE{
        private final ThreadLocalFormat<DateFormat> dateFormat = new ThreadLocalFormat<DateFormat>(){

            @Override
            protected DateFormat create(LocaleData data) {
                return data.getDateFormat();
            }
        };
        private final ThreadLocalFormat<DateTimeFormatter> localDateFormat = new ThreadLocalFormat<DateTimeFormatter>(){

            @Override
            protected DateTimeFormatter create(LocaleData data) {
                return DateTimeFormatter.ofPattern(data.getDateFormatPattern());
            }
        };

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 13.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (obj instanceof Date) {
                return this.dateFormat.get().format(obj);
            }
            if (obj instanceof LocalDate || obj instanceof LocalDateTime) {
                return this.localDateFormat.get().format((TemporalAccessor)obj);
            }
            return obj.toString();
        }
    }
    ,
    DATE_TIME{
        private final ThreadLocalFormat<DateFormat> dateFormat = new ThreadLocalFormat<DateFormat>(){

            @Override
            protected DateFormat create(LocaleData data) {
                return data.getDateTimeFormat();
            }
        };
        private final ThreadLocalFormat<DateTimeFormatter> localDateFormat = new ThreadLocalFormat<DateTimeFormatter>(){

            @Override
            protected DateTimeFormatter create(LocaleData data) {
                return DateTimeFormatter.ofPattern(data.getDateTimeFormatPattern());
            }
        };

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 14.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (obj instanceof Date) {
                return this.dateFormat.get().format(obj);
            }
            if (obj instanceof LocalDateTime) {
                return this.localDateFormat.get().format((TemporalAccessor)obj);
            }
            return obj.toString();
        }
    }
    ,
    TIME{
        private final ThreadLocalFormat<DateFormat> format = new ThreadLocalFormat<DateFormat>(){

            @Override
            protected DateFormat create(LocaleData data) {
                return data.getTimeFormat();
            }
        };

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 15.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (obj instanceof Number) {
                return MiscUtil.formatTime((Number)((Number)obj));
            }
            if (!(obj instanceof Date)) {
                return obj.toString();
            }
            return this.format.get().format(obj);
        }
    }
    ,
    CURRENCY_NAME{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 16.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (obj instanceof String) {
                String str = (String)obj;
                try {
                    return Currency.getInstance(str).getDisplayName(LocaleManager.get().getCurrentLocale());
                }
                catch (IllegalArgumentException ex) {
                    return str;
                }
            }
            return obj.toString();
        }
    }
    ,
    LOCALE{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 17.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            return obj instanceof Locale ? ((Locale)obj).getDisplayName(LocaleManager.get().getCurrentLocale()) : obj.toString();
        }
    }
    ,
    TIME_ZONE{

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 18.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (!(obj instanceof TimeZone)) {
                return obj.toString();
            }
            TimeZone tz = (TimeZone)obj;
            long hours = TimeUnit.MILLISECONDS.toHours(tz.getRawOffset());
            long minutes = TimeUnit.MILLISECONDS.toMinutes(tz.getRawOffset()) - TimeUnit.HOURS.toMinutes(hours);
            return String.format(hours > 0L ? "%s GMT+%d:%02d" : "%s GMT%d:%02d", tz.getID(), hours, Math.abs(minutes));
        }
    }
    ,
    INFINITABLE_DECIMAL{
        private final ThreadLocalFormat<NumberFormat> format = new ThreadLocalFormat<NumberFormat>(){

            @Override
            protected NumberFormat create(LocaleData data) {
                return data.getPriceFormat();
            }
        };

        @Override
        public String apply(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj instanceof Iterable ? 19.toString((Iterable)obj, this::convert) : this.convert(obj);
        }

        private String convert(Object obj) {
            if (!(obj instanceof Number)) {
                return obj.toString();
            }
            if (obj instanceof BigDecimal) {
                if (((BigDecimal)obj).compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) == 0) {
                    return this.format.get().format(Double.POSITIVE_INFINITY);
                }
                if (((BigDecimal)obj).compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) == 0) {
                    return this.format.get().format(Double.NEGATIVE_INFINITY);
                }
            }
            return this.format.get().format(obj);
        }
    };


    @Override
    public String getId() {
        return this.name().toLowerCase();
    }

    public static Renderer guessFor(String type) {
        if (TextUtil.isBlank((String)type)) {
            return GENERIC;
        }
        switch (type) {
            case "boolean": 
            case "Boolean": 
            case "java.lang.Boolean": {
                return BOOLEAN;
            }
            case "java.util.Date": {
                return DATE;
            }
            case "java.util.Locale": {
                return LOCALE;
            }
            case "java.util.TimeZone": {
                return TIME_ZONE;
            }
            case "java.math.BigDecimal": {
                return PRICE;
            }
            case "int": 
            case "Integer": 
            case "java.lang.Integer": 
            case "long": 
            case "Long": 
            case "java.lang.Long": 
            case "java.math.BigInteger": {
                return NUMBER_INTEGRAL;
            }
            case "double": 
            case "Double": 
            case "java.lang.Double": 
            case "float": 
            case "Float": 
            case "java.lang.Float": {
                return NUMBER_NON_INTEGRAL;
            }
        }
        return GENERIC;
    }

    public static String toString(Object value) {
        return value == null ? "" : (String)StandardRenderers.guessFor(value.getClass().getName()).apply(value);
    }

    protected static String toString(Iterable<?> coll, Function<Object, String> converter) {
        StringBuilder buf = new StringBuilder();
        for (Object item : coll) {
            String str;
            if (item == null || TextUtil.isBlank((String)(str = converter.apply(item)))) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(str);
        }
        return buf.toString();
    }

    protected static String toStringSorted(Set<?> coll, Function<Object, String> converter) {
        if (coll.isEmpty()) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object item : coll) {
            String str;
            if (item == null || TextUtil.isBlank((String)(str = converter.apply(item)))) continue;
            list.add(str);
        }
        if (list.isEmpty()) {
            return "";
        }
        Collections.sort(list);
        return TextUtil.join((String)", ", list);
    }
}

