/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.startup;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.util.Executable;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.Boot;

public class AutoUpdate {
    public static final String PREFIX = "com.gridnine.xtrip.boot";

    public static void startup(Application application) throws Exception {
        AutoUpdate.copyJREIfNeeed(application);
        AutoUpdate.deleteJRE();
        System.setProperty("com.gridnine.xtrip.boot.init", "true");
    }

    public static void restart(Application application, Map<String, String> params) throws IOException {
        File newJre = new File("jre_update");
        if (!newJre.exists()) {
            AutoUpdate.restart(application, new File(System.getProperty("java.home")), null, params);
            return;
        }
        AutoUpdate.restart(application, newJre, "update.jre", params);
    }

    private static void restart(Application application, File home, String mode, Map<String, String> params) throws IOException {
        try {
            Boot.stopApplication((Application)application);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> props = new ArrayList<String>();
        File java = new File(new File(home.getAbsolutePath(), "bin"), System.getProperty("os.name").startsWith("Windows") ? "javaw.exe" : "java");
        props.add(java.getAbsolutePath());
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        for (String string : arguments) {
            if (string.startsWith("-Dcom.gridnine.xtrip.boot.mode=") || string.startsWith("-Dcom.gridnine.xtrip.boot.repair=")) continue;
            props.add(string);
        }
        if (mode != null) {
            props.add("-Dcom.gridnine.xtrip.boot.mode=" + mode);
        }
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                props.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        if (Integer.parseInt(System.getProperty("java.version").substring(2, 3)) < 7) {
            props.add("-jar");
            props.add("lib/jpf-boot.jar");
        } else {
            props.add("-cp");
            props.add("lib/*");
            props.add("org.java.plugin.boot.Boot");
        }
        new ProcessBuilder(props).start();
        Runtime.getRuntime().exit(0);
    }

    private static void copyJREIfNeeed(Application application) throws Exception {
        if (!"update.jre".equals(System.getProperty("com.gridnine.xtrip.boot.mode"))) {
            return;
        }
        File home = new File(System.getProperty("java.home"));
        if (!"jre_update".equals(home.getName())) {
            return;
        }
        File jre = new File("jre");
        AutoUpdate.execWithUI(Messages.General_JRE_updating, () -> {
            Thread.sleep(1000L);
            FileUtils.deleteDirectory((File)jre);
            FileUtils.copyDirectory((File)home, (File)jre);
        });
        AutoUpdate.restart(application, jre, "delete.jre", null);
    }

    private static void deleteJRE() throws Exception {
        if (!"delete.jre".equals(System.getProperty("com.gridnine.xtrip.boot.mode"))) {
            return;
        }
        AutoUpdate.execWithUI(Messages.General_Deleting_old_files, () -> {
            File jre = new File("jre_update");
            FileUtils.deleteDirectory((File)jre);
        });
    }

    private static void execWithUI(String message, Executable job) throws Exception {
        ValueHolder frameHolder = new ValueHolder();
        CountDownLatch doneLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(() -> {
            try {
                JFrame frame = new JFrame(Messages.General_App_updating);
                frame.setDefaultCloseOperation(0);
                frame.setAlwaysOnTop(true);
                frame.setResizable(false);
                frame.setUndecorated(true);
                JLabel label = new JLabel(message);
                label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(15, 15, 15, 15)));
                label.setFont(label.getFont().deriveFont(17.0f));
                frame.getContentPane().add(label);
                frame.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension dialogSize = frame.getSize();
                frame.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
                frame.setVisible(true);
                frame.toFront();
                frameHolder.set(frame);
            }
            finally {
                doneLatch.countDown();
            }
        });
        doneLatch.await();
        job.execute();
        if (frameHolder.get() != null) {
            doneLatch = new CountDownLatch(1);
            SwingUtilities.invokeLater(() -> {
                try {
                    ((JFrame)frameHolder.get()).dispose();
                }
                finally {
                    doneLatch.countDown();
                }
            });
            doneLatch.await();
        }
    }
}

