/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.tasks;

import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.TerminationType;
import com.gridnine.xtrip.client.fx.core.tasks.NotificationPane;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.tasks.UserTaskNotificationItem;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.fx.assets.AsyncTaskAssignment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public abstract class ClientTask {
    final ObjectProperty<AsyncTaskAssignment.TaskState> state = new SimpleObjectProperty((Object)AsyncTaskAssignment.TaskState.ENQUEUED);
    private Future<?> future;
    final List<Message> messageLog = new ArrayList<Message>();
    Throwable error;
    private UserTaskNotificationItem item;

    void init(NotificationPane notificationPane) {
        this.item = new UserTaskNotificationItem(() -> ServerTaskHandler.showTaskInfo((AsyncTaskAssignment.TaskState)this.state.get(), this.error, this.messageLog), () -> this.doInterrupt());
        this.item.caption.set((Object)this.getTitle());
        notificationPane.add(this.item);
        this.state.addListener(obj -> {
            this.item.caption.set((Object)this.getTitle());
            if (!((AsyncTaskAssignment.TaskState)this.state.get()).isFinished()) {
                return;
            }
            if (this.hasErrors()) {
                this.item.terminationType.set((Object)TerminationType.FAIL);
            } else if (this.state.get() == AsyncTaskAssignment.TaskState.INTERRUPTED) {
                this.item.terminationType.set((Object)TerminationType.ABORT);
            } else {
                this.item.terminationType.set((Object)TerminationType.SUCCESS);
            }
            this.item.progress.set(1.0);
        });
    }

    private boolean hasErrors() {
        return this.error != null || MessagesHelper.hasErrorMessage(this.messageLog);
    }

    void doInterrupt() {
        if (this.future == null || this.future.isCancelled() || this.future.isDone()) {
            return;
        }
        this.future.cancel(true);
        if (this.future.isCancelled()) {
            this.state.set((Object)AsyncTaskAssignment.TaskState.INTERRUPTED);
        }
    }

    void submit(ExecutorService executor) {
        this.future = executor.submit(() -> {
            Date startDate = new Date();
            SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                FxUtil.waitForFxThread(() -> {
                    this.state.set((Object)AsyncTaskAssignment.TaskState.RUNNING);
                    this.messageLog.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"started {0}", (Object[])new Object[]{dtf.format(startDate)}));
                });
                this.execute();
                Date stopDate = new Date();
                FxUtil.waitForFxThread(() -> {
                    this.state.set((Object)AsyncTaskAssignment.TaskState.COMPLETED);
                    this.messageLog.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"stopped {0}", (Object[])new Object[]{dtf.format(stopDate)}));
                });
            }
            catch (InterruptedException ie) {
                try {
                    Date stopDate = new Date();
                    FxUtil.waitForFxThread(() -> {
                        this.state.set((Object)AsyncTaskAssignment.TaskState.INTERRUPTED);
                        this.messageLog.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"stopped {0}", (Object[])new Object[]{dtf.format(stopDate)}));
                    });
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
            }
            catch (Throwable t) {
                try {
                    Date stopDate = new Date();
                    this.error = t;
                    FxUtil.waitForFxThread(() -> {
                        this.state.set((Object)AsyncTaskAssignment.TaskState.COMPLETED);
                        this.messageLog.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"stopped {0}", (Object[])new Object[]{dtf.format(stopDate)}));
                    });
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
            }
        });
        FxUtil.submitToFxThread(() -> this.item.caption.set((Object)this.getTitle()));
    }

    protected abstract void execute() throws Exception;

    protected abstract String getTitle();

    protected final void setProgress(byte progress, String message) {
        FxUtil.runInFxThread(() -> {
            this.item.caption.set((Object)this.getTitle());
            if (this.item == null) {
                return;
            }
            this.item.progress.set(progress < 0 || progress > 100 ? -1.0 : (double)progress / 100.0);
            this.item.tooltip.set(message);
        });
    }

    protected final void addMessages(Message ... messages) {
        if (messages == null || messages.length == 0) {
            return;
        }
        FxUtil.runInFxThread(() -> {
            this.item.caption.set((Object)this.getTitle());
            if (messages.length == 1) {
                this.messageLog.add(messages[0]);
            } else {
                for (Message message : messages) {
                    this.messageLog.add(message);
                }
            }
        });
    }

    protected final void addMessages(List<Message> messages) {
        if (messages.isEmpty()) {
            return;
        }
        FxUtil.runInFxThread(() -> {
            this.item.caption.set((Object)this.getTitle());
            this.messageLog.addAll(messages);
        });
    }
}

