/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.tab;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPane;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTab;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTabSkin;
import com.gridnine.xtrip.client.fx.core.util.ObservableListWrapper;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class TabPaneSkin
extends SkinBase<TabPane> {
    private static final PseudoClass SHOWING_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"showing");
    private static final Duration ANIMATION_DURATION = Duration.millis((double)500.0);
    private static final Interpolator ANIMATION_INTERPOLATOR = new Interpolator(){

        protected double curve(double t) {
            return Math.sqrt(t);
        }
    };
    private Pane backgroundPane;
    private Pane specialTabsPane;
    private Pane regularTabsPane;
    private Pane controlsPane;
    private ContextMenu contextMenu;
    private MenuItem closeSelectedMenuItem;
    private MenuItem closeAllMenuItem;
    private MenuItem closeOthersMenuItem;
    private final AnimationData animationData = new AnimationData();
    private final DoubleProperty animationTransition = new SimpleDoubleProperty();
    private Timeline animation;

    public TabPaneSkin(TabPane tabPane) {
        super((Control)tabPane);
        int i;
        this.createGUI();
        this.createListeners();
        this.createAnimations();
        for (i = 0; i < tabPane.getSpecialTabs().size(); ++i) {
            this.addSpecialTab((TabPaneTab)tabPane.getSpecialTabs().get(i), i);
        }
        for (i = 0; i < tabPane.getRegularTabs().size(); ++i) {
            this.addRegularTab((TabPaneTab)tabPane.getRegularTabs().get(i), i);
        }
    }

    private void createGUI() {
        Pane tabPaneArea = this.createTabPanePane();
        this.getChildren().add((Object)tabPaneArea);
    }

    private Pane createTabPanePane() {
        this.backgroundPane = this.createBackgroundPane();
        this.specialTabsPane = this.createSpecialTabsPane();
        this.regularTabsPane = this.createRegularTabsPane();
        this.controlsPane = this.createControlsPane();
        UiUtil.setHidden((Node)this.controlsPane, true);
        StackPane tabsPane = new StackPane();
        tabsPane.getChildren().addAll((Object[])new Node[]{this.backgroundPane, this.specialTabsPane, this.regularTabsPane});
        GridPane pane = new GridPane();
        UiUtil.gridPosition(pane, (Node)tabsPane).col(0).row(0).hAlignment(HPos.LEFT).hAlignment(HPos.LEFT).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        UiUtil.gridPosition(pane, (Node)this.controlsPane).col(1).row(0).hAlignment(HPos.LEFT).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.ALWAYS).place();
        return pane;
    }

    private Pane createBackgroundPane() {
        StackPane pane = new StackPane();
        pane.getStyleClass().add((Object)"background-pane");
        return pane;
    }

    private Pane createSpecialTabsPane() {
        final Rectangle clip = new Rectangle();
        StackPane pane = new StackPane(){

            protected void layoutChildren() {
                TabPane tabPane = (TabPane)TabPaneSkin.this.getSkinnable();
                double tabSpecialWidth = this.snapSize(tabPane.getTabSpecialWidth());
                double width = this.snapSize(this.getWidth());
                double height = this.snapSize(this.getHeight());
                double clipWidth = Math.min(tabSpecialWidth * (double)tabPane.getSpecialTabs().size(), width);
                double clipHeight = height;
                double clipX = 0.0;
                double clipY = 0.0;
                clip.setX(clipX);
                clip.setY(clipY);
                clip.setWidth(clipWidth);
                clip.setHeight(clipHeight);
                double tabWidth = tabSpecialWidth;
                double tabHeight = height;
                double tabX = 0.0;
                double tabY = 0.0;
                for (int i = 0; i < tabPane.getSpecialTabs().size(); ++i) {
                    TabPaneTabSkin tab = (TabPaneTabSkin)((Object)TabPaneSkin.this.specialTabsPane.getChildren().get(i));
                    double tabActualWidth = tabWidth;
                    double tabActualHeight = tabHeight;
                    tab.relocate(tabX, tabY);
                    tab.resize(tabActualWidth, tabActualHeight);
                    tabX += tabActualWidth;
                }
            }
        };
        pane.getStyleClass().setAll((Object[])new String[]{"special-tabs-pane"});
        pane.setClip((Node)clip);
        return pane;
    }

    private Pane createRegularTabsPane() {
        final Rectangle clip = new Rectangle();
        StackPane pane = new StackPane(){

            protected void layoutChildren() {
                TabPane tabPane = (TabPane)TabPaneSkin.this.getSkinnable();
                double tabSpecialWidth = this.snapSize(tabPane.getTabSpecialWidth());
                double tabRegularMaxWidth = this.snapSize(tabPane.getTabMaxWidth());
                double width = this.snapSize(this.getWidth());
                double height = this.snapSize(this.getHeight());
                double specialTabsWidth = (double)tabPane.getSpecialTabs().size() * tabSpecialWidth;
                double regularTabsWidth = Math.min(tabRegularMaxWidth * (double)tabPane.getRegularTabs().size(), width - specialTabsWidth);
                double clipWidth = width - specialTabsWidth;
                double clipHeight = height;
                double clipX = specialTabsWidth;
                double clipY = 0.0;
                clip.setX(clipX);
                clip.setY(clipY);
                clip.setWidth(clipWidth);
                clip.setHeight(clipHeight);
                int visibleTabsCount = TabPaneSkin.this.getVisibleTabsCount();
                double tabWidth = visibleTabsCount > 0 ? regularTabsWidth / (double)visibleTabsCount : 0.0;
                double tabHeight = height;
                double usedWidth = 0.0;
                double[] pattern = new double[visibleTabsCount];
                for (int i = 0; i < visibleTabsCount; ++i) {
                    pattern[i] = i < visibleTabsCount - 1 ? (i % 2 == 0 ? Math.floor(tabWidth) : Math.ceil(tabWidth)) : regularTabsWidth - usedWidth;
                    usedWidth += pattern[i];
                }
                double visibleOffset = this.getOffset(((TabPaneSkin)TabPaneSkin.this).animationData.visibleTabIndex, regularTabsWidth, pattern);
                double pivotOffset = this.getOffset(((TabPaneSkin)TabPaneSkin.this).animationData.pivotTabIndex, regularTabsWidth, pattern);
                double currentOffset = this.getOffset(((TabPaneSkin)TabPaneSkin.this).animationData.currentTabIndex, regularTabsWidth, pattern);
                double tabX = specialTabsWidth;
                double tabY = 0.0;
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    TabPaneTabSkin tab = (TabPaneTabSkin)((Object)this.getChildren().get(i));
                    double tabActualX = tabX + (TabPaneSkin.this.animation.getStatus() != Animation.Status.STOPPED && i >= ((TabPaneSkin)TabPaneSkin.this).animationData.startIndex && i <= ((TabPaneSkin)TabPaneSkin.this).animationData.endIndex ? pivotOffset - visibleOffset - currentOffset : 0.0 - visibleOffset);
                    double tabActualY = tabY;
                    double tabActualWidth = visibleTabsCount > 0 ? pattern[i % pattern.length] : 0.0;
                    double tabActualHeight = tabHeight;
                    tab.relocate(tabActualX, tabActualY);
                    tab.resize(tabActualWidth, tabActualHeight);
                    tabX += tabActualWidth;
                }
            }

            private double getOffset(double index, double width, double[] pattern) {
                if (pattern.length == 0) {
                    return 0.0;
                }
                double offset = (double)((int)index / pattern.length) * width;
                double remains = index % (double)pattern.length;
                int i = 0;
                while ((double)i < remains) {
                    offset = remains - (double)i >= 1.0 ? (offset += pattern[i]) : (offset += pattern[i] * (remains - (double)i));
                    ++i;
                }
                return offset;
            }
        };
        pane.getStyleClass().setAll((Object[])new String[]{"regular-tabs-pane"});
        pane.setClip((Node)clip);
        return pane;
    }

    private Pane createControlsPane() {
        this.closeSelectedMenuItem = new MenuItem(Messages.General_Close_active_tab);
        this.closeSelectedMenuItem.setDisable(true);
        this.closeSelectedMenuItem.setOnAction(event -> ((TabPane)this.getSkinnable()).closeMultiple(false, true));
        this.closeAllMenuItem = new MenuItem(Messages.General_Close_all_tabs);
        this.closeAllMenuItem.setOnAction(event -> ((TabPane)this.getSkinnable()).closeMultiple(true, true));
        this.closeOthersMenuItem = new MenuItem(Messages.General_Close_all_except_active_tab);
        this.closeOthersMenuItem.setDisable(true);
        this.closeOthersMenuItem.setOnAction(event -> ((TabPane)this.getSkinnable()).closeMultiple(true, false));
        StackPane pane = new StackPane();
        pane.getStyleClass().add((Object)"controls-pane");
        Tooltip.install((Node)pane, (Tooltip)new Tooltip(Messages.General_Manage_tabs));
        IconNode menuButtonIcon = new IconNode(StandardIconShapes.MORE_18X18, (Styleable)pane, StandardIconIntentions.TABS_MENU, (Styleable)pane);
        menuButtonIcon.getStyleClass().add((Object)"button-icon");
        pane.getChildren().add((Object)menuButtonIcon);
        return pane;
    }

    private void createListeners() {
        ((ObservableListWrapper)((TabPane)this.getSkinnable()).getSpecialTabs()).addFirstListener(change -> {
            while (change.next()) {
                for (TabPaneTab tab : change.getRemoved()) {
                    this.removeSpecialTab(tab);
                }
                int index = change.getFrom() == -1 ? this.specialTabsPane.getChildren().size() : change.getFrom();
                int count = 0;
                for (TabPaneTab tab : change.getAddedSubList()) {
                    this.addSpecialTab(tab, index + count);
                    ++count;
                }
            }
            this.specialTabsPane.requestLayout();
            this.regularTabsPane.requestLayout();
        });
        ((ObservableListWrapper)((TabPane)this.getSkinnable()).getRegularTabs()).addFirstListener(change -> {
            while (change.next()) {
                for (TabPaneTab tab : change.getRemoved()) {
                    this.removeRegularTab(tab);
                }
                int index = change.getFrom() == -1 ? this.regularTabsPane.getChildren().size() : change.getFrom();
                int count = 0;
                for (TabPaneTab tab : change.getAddedSubList()) {
                    this.addRegularTab(tab, index + count);
                    ++count;
                }
            }
            UiUtil.setHidden((Node)this.controlsPane, ((TabPane)this.getSkinnable()).getRegularTabs().size() == 0);
            this.specialTabsPane.requestLayout();
            this.regularTabsPane.requestLayout();
        });
        ((TabPane)this.getSkinnable()).getSpecialTabsSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.specialTabsPane.requestLayout());
        ((TabPane)this.getSkinnable()).getRegularTabsSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            TabPane tabPane = (TabPane)this.getSkinnable();
            this.closeSelectedMenuItem.setDisable(newValue == null);
            this.closeOthersMenuItem.setDisable(newValue == null);
            int selectedTabIndex = tabPane.getRegularTabsSelectionModel().getSelectedIndex();
            if (selectedTabIndex >= 0) {
                int visibleTabsCount = this.getVisibleTabsCount();
                if ((double)selectedTabIndex < this.animationData.visibleTabIndex || (double)selectedTabIndex > this.animationData.visibleTabIndex + (double)visibleTabsCount - 1.0) {
                    ChangeType oldChangeType = this.animationData.changeType;
                    double oldVisibleTabIndex = this.animationData.visibleTabIndex;
                    this.animationData.changeType = ChangeType.POSITION_CHANGE;
                    this.animationData.startIndex = 0;
                    this.animationData.endIndex = tabPane.getRegularTabs().size();
                    this.animationData.pivotTabIndex = this.animationData.visibleTabIndex = Math.min((double)selectedTabIndex, Math.max((double)(selectedTabIndex - (visibleTabsCount - 1)), this.animationData.visibleTabIndex));
                    this.animationData.startTabIndex = this.animation.getStatus() != Animation.Status.STOPPED && oldChangeType == ChangeType.POSITION_CHANGE ? this.animationData.currentTabIndex : oldVisibleTabIndex;
                    this.animationData.endTabIndex = this.animationData.visibleTabIndex;
                    this.animationTransition.set(0.0);
                    this.animation.playFromStart();
                }
            }
            this.regularTabsPane.requestLayout();
        });
        this.animationTransition.addListener((observable, oldValue, newValue) -> {
            this.animationData.currentTabIndex = this.animationData.startTabIndex + (this.animationData.endTabIndex - this.animationData.startTabIndex) * this.animationTransition.get();
            this.regularTabsPane.requestLayout();
        });
        this.regularTabsPane.setOnScroll(event -> {
            TabPane tabPane = (TabPane)this.getSkinnable();
            if (event.getDeltaY() >= 0.0) {
                if (this.animationData.visibleTabIndex > 0.0) {
                    ChangeType oldChangeType = this.animationData.changeType;
                    double oldVisibleTabIndex = this.animationData.visibleTabIndex;
                    this.animationData.changeType = ChangeType.POSITION_CHANGE;
                    this.animationData.startIndex = 0;
                    this.animationData.endIndex = tabPane.getRegularTabs().size();
                    this.animationData.visibleTabIndex -= 1.0;
                    this.animationData.pivotTabIndex = this.animationData.visibleTabIndex;
                    this.animationData.startTabIndex = this.animation.getStatus() != Animation.Status.STOPPED && oldChangeType == ChangeType.POSITION_CHANGE ? this.animationData.currentTabIndex : oldVisibleTabIndex;
                    this.animationData.endTabIndex = this.animationData.visibleTabIndex;
                    this.animationTransition.set(0.0);
                    this.animation.playFromStart();
                }
            } else if (this.animationData.visibleTabIndex < (double)(tabPane.getRegularTabs().size() - this.getVisibleTabsCount())) {
                ChangeType oldChangeType = this.animationData.changeType;
                double oldVisibleTabIndex = this.animationData.visibleTabIndex;
                this.animationData.changeType = ChangeType.POSITION_CHANGE;
                this.animationData.startIndex = 0;
                this.animationData.endIndex = tabPane.getRegularTabs().size();
                this.animationData.visibleTabIndex += 1.0;
                this.animationData.pivotTabIndex = this.animationData.visibleTabIndex;
                this.animationData.startTabIndex = this.animation.getStatus() != Animation.Status.STOPPED && oldChangeType == ChangeType.POSITION_CHANGE ? this.animationData.currentTabIndex : oldVisibleTabIndex;
                this.animationData.endTabIndex = this.animationData.visibleTabIndex;
                this.animationTransition.set(0.0);
                this.animation.playFromStart();
            }
            this.regularTabsPane.requestLayout();
        });
        this.controlsPane.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    if (TabPaneSkin.this.contextMenu == null) {
                        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
                        TabPane tabPane = (TabPane)TabPaneSkin.this.getSkinnable();
                        int selectedIndex = tabPane.getRegularTabsSelectionModel().getSelectedIndex();
                        if (selectedIndex >= 0) {
                            items.add(TabPaneSkin.this.closeSelectedMenuItem);
                        }
                        items.add(TabPaneSkin.this.closeAllMenuItem);
                        if (selectedIndex >= 0) {
                            items.add(TabPaneSkin.this.closeOthersMenuItem);
                        }
                        int count = 0;
                        for (MenuItem item : items) {
                            item.getStyleClass().remove((Object)"menu-item-first");
                            if (count == 0) {
                                item.getStyleClass().add((Object)"menu-item-first");
                            }
                            ++count;
                        }
                        count = 0;
                        for (TabPaneTab tab : tabPane.getRegularTabs()) {
                            MenuItem item = new MenuItem(tab.getText());
                            if (count == 0) {
                                item.getStyleClass().add((Object)"menu-item-separator");
                            }
                            item.setOnAction(event2 -> tabPane.getRegularTabsSelectionModel().select((Object)tab));
                            items.add(item);
                            ++count;
                        }
                        TabPaneSkin.this.contextMenu = new ContextMenu();
                        TabPaneSkin.this.contextMenu.getItems().clear();
                        TabPaneSkin.this.contextMenu.getItems().addAll(items);
                        TabPaneSkin.this.contextMenu.show((Node)TabPaneSkin.this.controlsPane, Side.BOTTOM, Double.MIN_VALUE, Double.MIN_VALUE);
                        TabPaneSkin.this.contextMenu.hide();
                        double offset = TabPaneSkin.this.controlsPane.getWidth() - TabPaneSkin.this.contextMenu.getWidth();
                        Effect effect = TabPaneSkin.this.contextMenu.getSkin().getNode().getEffect();
                        if (effect != null && effect instanceof DropShadow) {
                            offset += ((DropShadow)effect).getRadius() * 2.0;
                        }
                        TabPaneSkin.this.contextMenu.setOnShown(e -> TabPaneSkin.this.controlsPane.pseudoClassStateChanged(SHOWING_PSEUDOCLASS_STATE, true));
                        TabPaneSkin.this.contextMenu.setOnHidden(e -> {
                            TabPaneSkin.this.contextMenu.getItems().clear();
                            TabPaneSkin.this.contextMenu = null;
                            TabPaneSkin.this.controlsPane.pseudoClassStateChanged(SHOWING_PSEUDOCLASS_STATE, false);
                        });
                        TabPaneSkin.this.contextMenu.show((Node)TabPaneSkin.this.controlsPane, Side.BOTTOM, offset, -1.0);
                    } else {
                        TabPaneSkin.this.contextMenu.hide();
                    }
                    event.consume();
                }
            }
        });
    }

    private void createAnimations() {
        this.animation = new Timeline();
        KeyValue keyValue = new KeyValue((WritableValue)this.animationTransition, (Object)1.0, ANIMATION_INTERPOLATOR);
        KeyFrame keyFrame = new KeyFrame(ANIMATION_DURATION, new KeyValue[]{keyValue});
        this.animation.getKeyFrames().clear();
        this.animation.getKeyFrames().add((Object)keyFrame);
        this.animation.setOnFinished(e -> {
            this.animationData.currentTabIndex = this.animationData.endTabIndex;
        });
    }

    private int getVisibleTabsCount() {
        TabPane tabPane = (TabPane)this.getSkinnable();
        if (tabPane.getRegularTabs().isEmpty()) {
            return 0;
        }
        double tabSpecialWidth = this.snapSize(tabPane.getTabSpecialWidth());
        double tabRegularMinWidth = this.snapSize(tabPane.getTabMinWidth());
        double width = Math.max(this.snapSize(this.regularTabsPane.getWidth()) - (double)tabPane.getSpecialTabs().size() * tabSpecialWidth, 0.0);
        return Math.min((int)(width / tabRegularMinWidth), tabPane.getRegularTabs().size());
    }

    private void addSpecialTab(TabPaneTab tab, int index) {
        TabPaneTabSkin tabSkin = new TabPaneTabSkin(tab);
        this.specialTabsPane.getChildren().add(index, (Object)tabSkin);
    }

    private void removeSpecialTab(TabPaneTab tab) {
        Iterator iterator = this.specialTabsPane.getChildren().iterator();
        while (iterator.hasNext()) {
            TabPaneTabSkin tabSkin = (TabPaneTabSkin)((Object)iterator.next());
            if (!tabSkin.getTab().equals(tab)) continue;
            iterator.remove();
            break;
        }
    }

    private void addRegularTab(TabPaneTab tab, int index) {
        TabPaneTabSkin tabSkin = new TabPaneTabSkin(tab);
        this.regularTabsPane.getChildren().add(index, (Object)tabSkin);
        this.animation.stop();
        int visibleTabsCount = this.getVisibleTabsCount();
        if ((double)index >= this.animationData.visibleTabIndex && (double)index <= this.animationData.visibleTabIndex + (double)visibleTabsCount - 1.0) {
            TabPane tabPane = (TabPane)this.getSkinnable();
            if (index < tabPane.getRegularTabs().size() - 1) {
                this.animationData.changeType = ChangeType.STRUCTURE_CHANGE;
                this.animationData.startIndex = index + 1;
                this.animationData.endIndex = tabPane.getRegularTabs().size();
                this.animationData.visibleTabIndex = this.animationData.visibleTabIndex;
                this.animationData.pivotTabIndex = index + 1;
                this.animationData.startTabIndex = index + 2;
                this.animationData.endTabIndex = index + 1;
                this.animationTransition.set(0.0);
                this.animation.playFromStart();
            }
        } else if ((double)index < this.animationData.visibleTabIndex) {
            this.animationData.visibleTabIndex += 1.0;
        }
    }

    private void removeRegularTab(TabPaneTab tab) {
        Iterator iterator = this.regularTabsPane.getChildren().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            TabPaneTabSkin tabSkin = (TabPaneTabSkin)((Object)iterator.next());
            if (tabSkin.getTab().equals(tab)) {
                iterator.remove();
                this.animation.stop();
                int visibleTabsCount = this.getVisibleTabsCount();
                if ((double)index >= this.animationData.visibleTabIndex && (double)index <= this.animationData.visibleTabIndex + (double)visibleTabsCount) {
                    TabPane tabPane = (TabPane)this.getSkinnable();
                    if (this.animationData.visibleTabIndex == 0.0 || this.animationData.visibleTabIndex < (double)(tabPane.getRegularTabs().size() - visibleTabsCount)) {
                        if (index >= tabPane.getRegularTabs().size()) break;
                        this.animationData.changeType = ChangeType.STRUCTURE_CHANGE;
                        this.animationData.startIndex = index;
                        this.animationData.endIndex = tabPane.getRegularTabs().size();
                        this.animationData.visibleTabIndex = this.animationData.visibleTabIndex;
                        this.animationData.pivotTabIndex = index + 1;
                        this.animationData.startTabIndex = index;
                        this.animationData.endTabIndex = index + 1;
                        this.animationTransition.set(0.0);
                        this.animation.playFromStart();
                        break;
                    }
                    if (!(this.animationData.visibleTabIndex > 0.0)) break;
                    this.animationData.changeType = ChangeType.STRUCTURE_CHANGE;
                    this.animationData.startIndex = 0;
                    this.animationData.endIndex = index - 1;
                    this.animationData.visibleTabIndex -= 1.0;
                    this.animationData.pivotTabIndex = index - 1;
                    this.animationData.startTabIndex = index;
                    this.animationData.endTabIndex = index - 1;
                    this.animationTransition.set(0.0);
                    this.animation.playFromStart();
                    break;
                }
                if (!((double)index < this.animationData.visibleTabIndex)) break;
                this.animationData.visibleTabIndex -= 1.0;
                break;
            }
            ++index;
        }
    }

    private static enum ChangeType {
        POSITION_CHANGE,
        STRUCTURE_CHANGE;

    }

    private static class AnimationData {
        ChangeType changeType;
        int startIndex;
        int endIndex;
        double visibleTabIndex;
        double pivotTabIndex;
        double startTabIndex;
        double endTabIndex;
        double currentTabIndex;

        private AnimationData() {
        }
    }
}

