/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.tab;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTab;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import javafx.animation.FadeTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

class TabPaneTabSkin
extends StackPane {
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private static final PseudoClass HIGHLIGHTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"highligted");
    private static final Duration ANIMATION_DURATION = Duration.millis((double)350.0);
    private final TabPaneTab tab;
    private Rectangle clip;
    private Label textLabel;
    private IconNode imageIcon;
    private IconNode closeButtonIcon;
    private Label decorationLabel;
    private ProgressBar progressBar;
    private FadeTransition animation;

    public TabPaneTabSkin(TabPaneTab tab) {
        this.getStyleClass().setAll(tab.getStyleClass());
        this.setId(tab.getId());
        this.setStyle(tab.getStyle());
        if (this.getId() == null) {
            this.setId("debug-tab");
        }
        this.tab = tab;
        this.createGUI();
        this.createBindings();
        this.createListeners();
        this.createAnimations();
    }

    private void createGUI() {
        this.clip = new Rectangle();
        this.setClip((Node)this.clip);
        this.textLabel = new Label();
        this.textLabel.getStyleClass().addAll((Object[])new String[]{"text-label"});
        this.textLabel.setId("debug-tab-text-label");
        this.textLabel.setVisible(false);
        this.imageIcon = new IconNode(null, StandardIconIntentions.TAB_DECORATION);
        this.imageIcon.getStyleClass().addAll((Object[])new String[]{"image-icon"});
        this.imageIcon.setId("debug-tab-image-icon");
        this.imageIcon.setVisible(this.tab.getIcon() != null);
        this.imageIcon.setIconShape(this.tab.getIcon());
        this.closeButtonIcon = new IconNode(StandardIconShapes.CLOSE_14X14, StandardIconIntentions.TAB_ACTION);
        this.closeButtonIcon.getStyleClass().addAll((Object[])new String[]{"button-icon"});
        this.closeButtonIcon.setId("debug-tab-button-icon");
        this.closeButtonIcon.setVisible(false);
        this.decorationLabel = new Label();
        this.decorationLabel.getStyleClass().addAll((Object[])new String[]{"decoration-label"});
        this.decorationLabel.setId("debug-tab-decoration-label");
        this.decorationLabel.setVisible(false);
        this.progressBar = new ProgressBar();
        this.progressBar.getStyleClass().setAll((Object[])new String[]{"progress-bar"});
        this.progressBar.setId("debug-tab-progress-bar");
        this.progressBar.setVisible(false);
        this.getChildren().addAll((Object[])new Node[]{this.textLabel, this.imageIcon, this.closeButtonIcon, this.decorationLabel, this.progressBar});
        this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, this.tab.isSelected());
        this.pseudoClassStateChanged(HIGHLIGHTED_PSEUDOCLASS_STATE, this.tab.highlightedProperty().get());
    }

    private void createBindings() {
        this.textLabel.textProperty().bind((ObservableValue)this.tab.textProperty());
        this.textLabel.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.tab.getText() != null, (Observable[])new Observable[]{this.tab.textProperty()}));
        this.imageIcon.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.tab.getIcon() != null, (Observable[])new Observable[]{this.tab.iconProperty()}));
        this.closeButtonIcon.visibleProperty().bind((ObservableValue)this.tab.closableProperty());
        this.decorationLabel.visibleProperty().bind((ObservableValue)this.tab.selectedProperty());
        this.progressBar.progressProperty().bind((ObservableValue)this.tab.progressProperty());
        FxUtil.addListener(this.tab.tooltipProperty(), (s, o, n) -> {
            if (n == null) {
                Tooltip.uninstall((Node)this, null);
            } else {
                Tooltip.install((Node)this, (Tooltip)n);
            }
        });
    }

    private void createListeners() {
        this.tab.iconProperty().addListener((observable, oldValue, newValue) -> this.imageIcon.setIconShape((IconShape)newValue));
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton().equals((Object)MouseButton.MIDDLE)) {
                    if (!TabPaneTabSkin.this.tab.isSpecial()) {
                        TabPaneTabSkin.this.tab.close();
                    }
                } else if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    if (TabPaneTabSkin.this.tab.isSpecial()) {
                        TabPaneTabSkin.this.tab.getTabPane().getSpecialTabsSelectionModel().select((Object)TabPaneTabSkin.this.tab);
                    } else {
                        TabPaneTabSkin.this.tab.getTabPane().getRegularTabsSelectionModel().select((Object)TabPaneTabSkin.this.tab);
                    }
                }
            }
        });
        this.closeButtonIcon.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                TabPaneTabSkin.this.tab.close();
                mouseEvent.consume();
            }
        });
        this.tab.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.tab.isBusy() && newValue.booleanValue()) {
                this.tab.setProgress(0.0);
                this.progressBar.setVisible(false);
                this.animation.stop();
            }
            this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, (boolean)newValue);
        });
        this.tab.busyProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.progressBar.setVisible(true);
                this.animation.stop();
            } else if (this.tab.isSelected()) {
                this.tab.setProgress(0.0);
                this.progressBar.setVisible(false);
            } else {
                this.tab.setProgress(100.0);
                this.animation.play();
            }
        });
        this.tab.highlightedProperty().addListener((observable, oldValue, newValue) -> this.pseudoClassStateChanged(HIGHLIGHTED_PSEUDOCLASS_STATE, (boolean)newValue));
    }

    private void createAnimations() {
        this.animation = new FadeTransition(ANIMATION_DURATION, (Node)this.progressBar);
        this.animation.setFromValue(1.0);
        this.animation.setToValue(0.5);
        this.animation.setCycleCount(14);
        this.animation.setAutoReverse(true);
    }

    protected void layoutChildren() {
        double width = this.snapSize(this.getWidth());
        double height = this.snapSize(this.getHeight());
        double clipWidth = width;
        double clipHeight = height;
        double clipX = 0.0;
        double clipY = 0.0;
        this.clip.setX(clipX);
        this.clip.setY(clipY);
        this.clip.setWidth(clipWidth);
        this.clip.setHeight(clipHeight);
        double imageIconWidth = this.snapSize(this.imageIcon.prefWidth(-1.0));
        double imageIconHeight = this.snapSize(this.imageIcon.prefHeight(-1.0));
        double imageIconX = this.snappedLeftInset();
        double imageIconY = this.snapSize((height - imageIconHeight) / 2.0);
        this.imageIcon.resize(imageIconWidth, imageIconHeight);
        this.imageIcon.relocate(imageIconX, imageIconY);
        double closeButtonIconWidth = this.snapSize(this.closeButtonIcon.prefWidth(-1.0));
        double closeButtonIconHeight = this.snapSize(this.closeButtonIcon.prefHeight(-1.0));
        double closeButtonIconX = width - this.snappedRightInset() - closeButtonIconWidth;
        double closeButtonIconY = this.snapSize((height - closeButtonIconHeight) / 2.0);
        this.closeButtonIcon.resize(closeButtonIconWidth, closeButtonIconHeight);
        this.closeButtonIcon.relocate(closeButtonIconX, closeButtonIconY);
        double textLabelLeftOffset = this.imageIcon.isVisible() ? imageIconWidth - Math.min(this.imageIcon.snappedRightInset(), this.textLabel.snappedLeftInset()) : 0.0;
        double textLabelRightOffset = this.closeButtonIcon.isVisible() ? closeButtonIconWidth - Math.min(this.closeButtonIcon.snappedLeftInset(), this.textLabel.snappedRightInset()) : 0.0;
        double textLabelWidth = width - this.snappedLeftInset() - this.snappedRightInset() - textLabelLeftOffset - textLabelRightOffset;
        double textLabelHeight = this.snapSize(this.textLabel.prefHeight(-1.0));
        double textLabelX = this.snappedLeftInset() + textLabelLeftOffset;
        double textLabelY = this.snapSize((height - textLabelHeight) / 2.0);
        this.textLabel.resize(textLabelWidth, textLabelHeight);
        this.textLabel.relocate(textLabelX, textLabelY);
        double decorationLabelWidth = width;
        double decorationLabelHeight = this.snapSize(this.decorationLabel.prefHeight(-1.0));
        double decorationLabelX = 0.0;
        double decorationLabelY = 0.0;
        this.decorationLabel.resize(decorationLabelWidth, decorationLabelHeight);
        this.decorationLabel.relocate(decorationLabelX, decorationLabelY);
        double progressBarWidth = width;
        double progressBarHeight = this.snapSize(this.progressBar.prefHeight(-1.0));
        double progressBarX = 0.0;
        double progressBarY = 0.0;
        this.progressBar.resize(progressBarWidth, progressBarHeight);
        this.progressBar.relocate(progressBarX, progressBarY);
    }

    public TabPaneTab getTab() {
        return this.tab;
    }
}

