/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.client.fx.core.util.UiSettings;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.java.plugin.util.ExtendedProperties;

public final class ClientSettings {
    private static ClientSettings instance;
    boolean enabledRemoteFiscalServiceProvider;
    Locale uiLocale;
    Locale dataLocale;
    List<Locale> userLocales = new ArrayList<Locale>();
    boolean useSortByLocale;
    String selectedActivity;
    File fileChooserDirectory;
    File lastExportFile;
    int scaleFactor;
    private final UiSettings data = new UiSettings(ClientSettings.class.getName(), new UiSettings.Persister(){

        @Override
        public void read(Properties props) throws Exception {
            String[] arr;
            String prop = props.getProperty("locale.ui");
            ClientSettings.this.uiLocale = prop == null ? LocaleManager.get().getCurrentLocale() : TextUtil.str2locale((String)prop);
            if (!LocaleManager.get().isSupportedLocale(ClientSettings.this.uiLocale)) {
                ClientSettings.this.uiLocale = LocaleManager.get().getCurrentLocale();
            }
            ClientSettings.this.dataLocale = LocaleUtil.createNormalizedLocale((Locale)((prop = props.getProperty("locale.data")) == null ? LocaleManager.get().getCurrentLocale() : TextUtil.str2locale((String)prop)));
            prop = props.getProperty("useSortByLocale");
            ClientSettings.this.useSortByLocale = !TextUtil.isBlank((String)prop) ? Boolean.parseBoolean(prop) : false;
            prop = props.getProperty("enabledRemoteFiscalServiceProvider");
            ClientSettings.this.enabledRemoteFiscalServiceProvider = !TextUtil.isBlank((String)prop) ? Boolean.parseBoolean(prop) : false;
            ClientSettings.this.userLocales.clear();
            prop = props.getProperty("userLocales");
            if (prop != null && (arr = prop.split("\\|")) != null) {
                for (String str : arr) {
                    Locale loc = TextUtil.str2locale((String)str);
                    if (loc == null || ClientSettings.this.userLocales.contains(loc)) continue;
                    ClientSettings.this.userLocales.add(loc);
                }
            }
            ClientSettings.this.selectedActivity = props.getProperty("selectedActivity");
            prop = props.getProperty("fileChooserDirectory");
            if (prop == null) {
                ClientSettings.this.fileChooserDirectory = null;
            } else {
                ClientSettings.this.fileChooserDirectory = new File(prop);
                if (!ClientSettings.this.fileChooserDirectory.isDirectory()) {
                    ClientSettings.this.fileChooserDirectory = null;
                }
            }
            try {
                ClientSettings.this.scaleFactor = Integer.parseInt(props.getProperty("scaleFactor", "0"));
            }
            catch (NumberFormatException prop2) {
                // empty catch block
            }
            prop = props.getProperty("lastExportFile");
            ClientSettings.this.lastExportFile = prop == null ? null : new File(prop);
        }

        @Override
        public void write(Properties props) throws Exception {
            props.setProperty("locale.ui", ClientSettings.this.uiLocale.toString());
            props.setProperty("locale.data", ClientSettings.this.dataLocale.toString());
            if (!ClientSettings.this.userLocales.isEmpty()) {
                props.setProperty("userLocales", ClientSettings.this.userLocales.stream().map(Locale::toString).collect(Collectors.joining("|")));
            } else {
                props.remove("userLocales");
            }
            props.setProperty("useSortByLocale", Boolean.toString(ClientSettings.this.useSortByLocale));
            props.setProperty("enabledRemoteFiscalServiceProvider", Boolean.toString(ClientSettings.this.enabledRemoteFiscalServiceProvider));
            if (ClientSettings.this.selectedActivity != null) {
                props.setProperty("selectedActivity", ClientSettings.this.selectedActivity);
            } else {
                props.remove("selectedActivity");
            }
            if (ClientSettings.this.fileChooserDirectory != null) {
                props.setProperty("fileChooserDirectory", ClientSettings.this.fileChooserDirectory.getAbsolutePath());
            } else {
                props.remove("fileChooserDirectory");
            }
            if (ClientSettings.this.scaleFactor != 0) {
                props.setProperty("scaleFactor", String.valueOf(ClientSettings.this.scaleFactor));
            } else {
                props.remove("scaleFactor");
            }
            if (ClientSettings.this.lastExportFile != null) {
                props.setProperty("lastExportFile", ClientSettings.this.lastExportFile.getAbsolutePath());
            } else {
                props.remove("lastExportFile");
            }
        }
    });
    private ExtendedProperties properties;

    public static synchronized ClientSettings get() {
        if (instance != null) {
            return instance;
        }
        ClientSettings settings = new ClientSettings();
        settings.load();
        instance = settings;
        return instance;
    }

    private ClientSettings() {
    }

    private void load() {
        this.data.load();
    }

    public void save() {
        this.data.save();
    }

    public Locale getUiLocale() {
        return this.uiLocale;
    }

    public void setUiLocale(Locale value) {
        this.uiLocale = Objects.requireNonNull(value);
        LocaleManager lm = LocaleManager.get();
        lm.setDefaultLocale(this.uiLocale);
        lm.setCurrentLocale(this.uiLocale);
        if (Environment.isPublished(ServiceInvocationContext.class)) {
            ServiceInvocationContext.get().setLocale(this.uiLocale);
        }
    }

    public Locale getDataLocale() {
        return this.dataLocale;
    }

    public void setDataLocale(Locale value) {
        this.dataLocale = Objects.requireNonNull(value);
    }

    public List<Locale> getUserLocales() {
        return this.userLocales;
    }

    public boolean isUseSortByLocale() {
        return this.useSortByLocale;
    }

    public void setUseSortByLocale(boolean value) {
        this.useSortByLocale = value;
    }

    public String getSelectedActivity() {
        return this.selectedActivity;
    }

    public void setSelectedActivity(String value) {
        this.selectedActivity = value;
    }

    public File getFileChooserDirectory() {
        return this.fileChooserDirectory;
    }

    public void setFileChooserDirectory(File value) {
        this.fileChooserDirectory = value;
    }

    public File getLastExportFile() {
        return this.lastExportFile;
    }

    public void setLastExportFile(File value) {
        this.lastExportFile = value;
    }

    public boolean isEnabledRemoteFiscalServiceProvider() {
        return this.enabledRemoteFiscalServiceProvider;
    }

    public void setEnabledRemoteFiscalServiceProvider(boolean enabledRemoteFiscalServiceProvider) {
        this.enabledRemoteFiscalServiceProvider = enabledRemoteFiscalServiceProvider;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(int value) {
        if (this.scaleFactor < -5 || this.scaleFactor > 10) {
            throw new IllegalArgumentException("scale factor should be in range [-5:10]");
        }
        this.scaleFactor = value;
    }

    public void setProperties(ExtendedProperties props) {
        if (this.properties != null) {
            throw Xeption.forDeveloper((String)"setProperties() cannot be used more than once", (Object[])new Object[0]);
        }
        this.properties = props;
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(name);
    }

    public String getProperty(String name, String def) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(name, def);
    }
}

