/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;

public final class DateUtils {
    public static Date asDate(LocalDate localDate) {
        return localDate == null ? null : Date.from(DateUtils.toInstant(localDate));
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return localDateTime == null ? null : Date.from(DateUtils.toInstant(localDateTime));
    }

    public static Date asDate(LocalTime localTime) {
        return localTime == null ? null : Date.from(DateUtils.toInstant(localTime));
    }

    public static Instant toInstant(LocalDate localDate) {
        return localDate == null ? null : localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        LocalDate date = LocalDate.ofEpochDay(0L);
        return LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano()).atZone(ZoneId.systemDefault()).toInstant();
    }

    public static LocalDate asLocalDate(Date date) {
        return date == null ? null : date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return date == null ? null : date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalTime asLocalTime(Date date) {
        return date == null ? null : date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
    }

    private DateUtils() {
    }
}

