/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.common.Environment;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DumpDataUtil {
    public static File newFile(DataKind kind) {
        File result = new File(Environment.getTempFolder(), kind.buildFileName());
        int limit = kind.getMaxFilesCount();
        if (limit > 1) {
            List<File> files = kind.listFiles();
            if (files.size() < limit) {
                return result;
            }
            files.stream().sorted((lhs, rhs) -> Long.compare(rhs.lastModified(), lhs.lastModified())).skip(limit - 2).forEach(File::delete);
        }
        return result;
    }

    private DumpDataUtil() {
    }

    public static enum DataKind {
        HEAP_DUMP{

            @Override
            String buildFileName() {
                return "heapdump.hprof";
            }

            @Override
            int getMaxFilesCount() {
                return 1;
            }

            @Override
            protected FileFilter getFilesFilter() {
                return file -> file.isFile() && file.getName().startsWith("heapdump");
            }
        }
        ,
        MERGE_CONFLICT_DATA{

            @Override
            String buildFileName() {
                return "merge-conflict-" + System.currentTimeMillis() + ".xml.gz";
            }

            @Override
            int getMaxFilesCount() {
                return 5;
            }

            @Override
            protected FileFilter getFilesFilter() {
                return file -> file.isFile() && file.getName().startsWith("merge-conflict");
            }
        };


        abstract String buildFileName();

        abstract int getMaxFilesCount();

        protected abstract FileFilter getFilesFilter();

        public List<File> listFiles() {
            File[] files = Environment.getTempFolder().listFiles(this.getFilesFilter());
            if (files == null || files.length == 0) {
                return Collections.emptyList();
            }
            return Arrays.asList(files);
        }
    }
}

