/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.common.model.Xeption;
import java.util.Date;
import java.util.function.Function;

class ErrorHandlers {
    static final String UNCAUGHT_ERROR_MESSAGE_PREFIX = "uncaught exception in thread ";
    private static ErrorHandler errorHandler;
    static Function<Throwable, Boolean> repairHandler;

    ErrorHandlers() {
    }

    static void register(ErrorHandler handler) {
        errorHandler = handler;
    }

    static void registerRepairHandler(Function<Throwable, Boolean> handler) {
        repairHandler = handler;
    }

    static void handle(Throwable error) {
        if (error == null) {
            return;
        }
        if (repairHandler != null) {
            try {
                if (Boolean.TRUE.equals(repairHandler.apply(error))) {
                    return;
                }
            }
            catch (Throwable t) {
                ErrorHandlers.handle(t);
            }
        }
        if (errorHandler != null) {
            errorHandler.handleError(error);
            return;
        }
        System.out.println(String.format("%tFT%1$tT [%s] %s:", new Date(), Thread.currentThread().getName(), error.getMessage()));
        error.printStackTrace();
    }

    private static boolean isSuppress(Throwable error) {
        if (error instanceof IllegalArgumentException) {
            StackTraceElement[] stackTrace = error.getStackTrace();
            if (stackTrace == null || stackTrace.length < 3) {
                return false;
            }
            StackTraceElement elm = stackTrace[2];
            if ("com.sun.javafx.scene.control.skin.Utils".equals(elm.getClassName())) {
                return true;
            }
            return "javafx.scene.control.TextInputControl".equals(elm.getClassName());
        }
        if (error instanceof StringIndexOutOfBoundsException) {
            StackTraceElement[] stackTrace = error.getStackTrace();
            if (stackTrace == null || stackTrace.length < 4) {
                return false;
            }
            StackTraceElement elm = stackTrace[3];
            return "javafx.scene.control.TextInputControl".equals(elm.getClassName());
        }
        if (error instanceof ArrayIndexOutOfBoundsException) {
            StackTraceElement[] stackTrace = error.getStackTrace();
            if (stackTrace == null || stackTrace.length < 3) {
                return false;
            }
            StackTraceElement elm = stackTrace[2];
            return "com.sun.javafx.collections.ObservableListWrapper".equals(elm.getClassName());
        }
        if (error instanceof UnsupportedOperationException) {
            StackTraceElement elm;
            StackTraceElement[] stackTrace = error.getStackTrace();
            if (stackTrace == null) {
                return false;
            }
            return stackTrace.length >= 20 && "javafx.css.StyleableObjectProperty".equals((elm = stackTrace[20]).getClassName()) && "applyStyle".equals(elm.getMethodName());
        }
        if (error instanceof NullPointerException) {
            StackTraceElement ste;
            StackTraceElement[] stackTrace = error.getStackTrace();
            if (stackTrace == null || stackTrace.length == 0) {
                return true;
            }
            StackTraceElement elm = stackTrace[0];
            if ("javafx.scene.control.TextInputControl".equals(elm.getClassName())) {
                return true;
            }
            if ("com.sun.javafx.tk.quantum.QuantumToolkit".equals(elm.getClassName())) {
                return true;
            }
            if ("javafx.scene.control.Tooltip$TooltipBehavior".equals(elm.getClassName())) {
                return true;
            }
            if ("com.sun.javafx.binding.ExpressionHelper".equals(elm.getClassName())) {
                return true;
            }
            if ("com.sun.javafx.scene.traversal.TabOrderHelper".equals(elm.getClassName())) {
                return true;
            }
            if ("javafx.scene.Scene.ScenePulseListener".equals(elm.getClassName())) {
                return true;
            }
            if ("com.sun.javafx.scene.input.PickResultChooser".equals(elm.getClassName())) {
                return true;
            }
            return stackTrace.length >= 2 && "javafx.scene.Node".equals((ste = stackTrace[2]).getClassName()) && "invalidatedScenes".equals(ste.getMethodName());
        }
        return false;
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler((thread, error) -> {
            if (ErrorHandlers.isSuppress(error)) {
                return;
            }
            ErrorHandlers.handle((Throwable)Xeption.forDeveloper((String)(UNCAUGHT_ERROR_MESSAGE_PREFIX + thread), (Throwable)error, (Object[])new Object[0]));
        });
    }
}

