/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ModelCheckUtil {
    public static void check(Object obj) throws CheckFailedException {
        ModelCheckUtil.check(obj, new VisitsTracker(), new HashMap<String, Object>());
    }

    private static void check(Object obj, VisitsTracker tracker, Map<String, Object> uid2entity) throws CheckFailedException {
        EntityType ett;
        if (obj == null || tracker.isVisited(obj)) {
            return;
        }
        tracker.visited(obj);
        if (obj instanceof Iterable) {
            for (Object item : (Iterable)obj) {
                ModelCheckUtil.check(item, tracker, uid2entity);
            }
            return;
        }
        if (obj instanceof Map) {
            for (Map.Entry item : ((Map)obj).entrySet()) {
                ModelCheckUtil.check(item.getKey(), tracker, uid2entity);
                ModelCheckUtil.check(item.getValue(), tracker, uid2entity);
            }
            return;
        }
        if (!(obj instanceof Introspectable)) {
            return;
        }
        if (obj instanceof Identity) {
            Identity idt = (Identity)obj;
            Iterator visited = uid2entity.get(idt.getUid());
            if (visited == null) {
                uid2entity.put(idt.getUid(), idt);
            } else if (visited != idt) {
                throw new CheckFailedException(idt.getUid(), idt.getClass());
            }
        }
        if ((ett = MetaRegistryHelper.getEntityType((String)obj.getClass().getName())) != null) {
            for (String prop : MetaRegistryHelper.getAllProperties((EntityType)ett).keySet()) {
                ModelCheckUtil.check(((Introspectable)obj).getValue(prop), tracker, uid2entity);
            }
            for (String prop : MetaRegistryHelper.getAllCollections((BaseClassType)ett).keySet()) {
                ModelCheckUtil.check(((Introspectable)obj).getValue(prop), tracker, uid2entity);
            }
            return;
        }
        DictionaryType dct = MetaRegistryHelper.getDictionaryType((String)obj.getClass().getName());
        if (dct != null) {
            for (String prop : MetaRegistryHelper.getAllProperties((DictionaryType)dct).keySet()) {
                ModelCheckUtil.check(((Introspectable)obj).getValue(prop), tracker, uid2entity);
            }
            for (String prop : MetaRegistryHelper.getAllCollections((BaseClassType)dct).keySet()) {
                ModelCheckUtil.check(((Introspectable)obj).getValue(prop), tracker, uid2entity);
            }
            return;
        }
    }

    public static <T extends Identity & Introspectable> void compare(T expected, T actual) {
        ModelCheckUtil.compare(expected.getClass().getName(), expected, actual, new HashMap<String, String>());
    }

    private static <T extends Identity & Introspectable> void compare(String path, T expected, T actual, Map<String, String> uidContext) {
        Collection collections;
        Object actualValue;
        Object expectedValue;
        ModelCheckUtil.assertEquals(path, expected, actual);
        ModelCheckUtil.assertEquals(path, expected.getClass(), actual.getClass());
        if (uidContext.containsKey(expected.getUid())) {
            ModelCheckUtil.assertEquals(path + ".uid (innerReference)", uidContext.get(expected.getUid()), actual.getUid());
            return;
        }
        uidContext.put(expected.getUid(), actual.getUid());
        if (expected instanceof BaseDictionary) {
            DictionaryType dt = MetaRegistryHelper.getDictionaryType((String)expected.getClass().getName());
            for (DictionaryProperty p : MetaRegistryHelper.getAllProperties((DictionaryType)dt).values()) {
                expectedValue = ((Introspectable)expected).getValue(p.getId());
                actualValue = ((Introspectable)actual).getValue(p.getId());
                ModelCheckUtil.compareValues(String.format("%s.%s", path, p.getId()), expectedValue, actualValue, uidContext);
            }
            collections = MetaRegistryHelper.getAllCollections((BaseClassType)dt).values();
        } else if (expected instanceof BaseEntity) {
            EntityType et = MetaRegistryHelper.getEntityType((String)expected.getClass().getName());
            if (et == null) {
                return;
            }
            for (DictionaryProperty p : MetaRegistryHelper.getAllProperties((EntityType)et).values()) {
                expectedValue = ((Introspectable)expected).getValue(p.getId());
                actualValue = ((Introspectable)actual).getValue(p.getId());
                ModelCheckUtil.compareValues(String.format("%s.%s", path, p.getId()), expectedValue, actualValue, uidContext);
            }
            collections = MetaRegistryHelper.getAllCollections((BaseClassType)et).values();
        } else {
            return;
        }
        for (EntityCollection ec : collections) {
            Object expectedValue2 = ((Introspectable)expected).getValue(ec.getId());
            Object actualValue2 = ((Introspectable)actual).getValue(ec.getId());
            if (expectedValue2 instanceof List) {
                if (!(actualValue2 instanceof List)) {
                    throw new MatchFailedException(String.format("%s.%s", path, ec.getId()), "List expected");
                }
                List expectedList = (List)expectedValue2;
                List actualList = (List)actualValue2;
                if (ec.getUnitTestParameters() != null && !ec.getUnitTestParameters().isOrdered() && !ec.getUnitTestParameters().getDesignators().isEmpty()) {
                    Collections.sort(expectedList, (a, b) -> MiscUtil.compare((Comparable)((Object)ModelCheckUtil.buildSortKey(a, ec.getUnitTestParameters().getDesignators())), (Comparable)((Object)ModelCheckUtil.buildSortKey(b, ec.getUnitTestParameters().getDesignators()))));
                    Collections.sort(actualList, (a, b) -> MiscUtil.compare((Comparable)((Object)ModelCheckUtil.buildSortKey(a, ec.getUnitTestParameters().getDesignators())), (Comparable)((Object)ModelCheckUtil.buildSortKey(b, ec.getUnitTestParameters().getDesignators()))));
                }
                ModelCheckUtil.assertEquals(String.format("%s.%s.size()", path, ec.getId()), expectedList.size(), actualList.size());
                for (int i = 0; i < expectedList.size(); ++i) {
                    Object expectedObject = expectedList.get(i);
                    Object actualObject = actualList.get(i);
                    ModelCheckUtil.compareValues(String.format("%s.%s[%d]", path, ec.getId(), i), expectedObject, actualObject, uidContext);
                }
            }
            if (expectedValue2 instanceof Set) {
                if (!(actualValue2 instanceof Set)) {
                    throw new MatchFailedException(String.format("%s.%s", path, ec.getId()), "Set expected");
                }
                Set expectedSet = (Set)expectedValue2;
                Set actualSet = (Set)actualValue2;
                ModelCheckUtil.assertEquals(String.format("%s.%s.size()", path, ec.getId()), expectedSet.size(), actualSet.size());
            }
            if (!(expectedValue2 instanceof Map)) continue;
            if (!(actualValue2 instanceof Map)) {
                throw new MatchFailedException(String.format("%s.%s", path, ec.getId()), "Map expected");
            }
            Map expectedMap = (Map)expectedValue2;
            Map actualMap = (Map)actualValue2;
            ModelCheckUtil.assertEquals(String.format("%s.%s.size()", path, ec.getId()), expectedMap.size(), actualMap.size());
        }
    }

    private static String buildSortKey(Object obj, List<String> designators) {
        Introspectable in = (Introspectable)obj;
        StringBuilder sb = new StringBuilder();
        for (String designator : designators) {
            Object value;
            if (sb.length() > 0) {
                sb.append("|");
            }
            if ((value = in.getValue(designator)) instanceof DictionaryReference) {
                sb.append(((DictionaryReference)value).getCode());
                continue;
            }
            if (value instanceof EntityReference) {
                sb.append(((EntityReference)value).getUid());
                continue;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private static void compareValues(String path, Object expected, Object actual, Map<String, String> uidContext) {
        if (expected == null) {
            if (actual != null && (actual instanceof Collection ? ((Collection)actual).isEmpty() : actual instanceof Map && ((Map)actual).isEmpty())) {
                return;
            }
            ModelCheckUtil.assertNull(path, actual);
            return;
        }
        if (actual == null && (expected instanceof Collection ? ((Collection)expected).isEmpty() : expected instanceof Map && ((Map)expected).isEmpty())) {
            return;
        }
        if (actual == null) {
            throw new MatchFailedException(path, "not null expected");
        }
        ModelCheckUtil.assertEquals(path, expected.getClass(), actual.getClass());
        if (expected instanceof BaseEntity) {
            ModelCheckUtil.compare(path, (BaseEntity)expected, (BaseEntity)actual, uidContext);
        } else {
            try {
                ModelCheckUtil.assertEquals(path, expected, actual);
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void assertEquals(String message, Object expected, Object actual) {
        if (!MiscUtil.equals((Object)expected, (Object)actual)) {
            throw new MatchFailedException(message, String.format("expected: %s\nactual: %s", expected, actual));
        }
    }

    private static void assertEquals(String message, int expected, int actual) {
        if (expected != actual) {
            throw new MatchFailedException(message, String.format("expected: %s\nactual: %s", expected, actual));
        }
    }

    private static void assertNull(String message, Object obj) {
        if (obj != null) {
            throw new MatchFailedException(message, "expected null, but was: " + obj);
        }
    }

    private ModelCheckUtil() {
    }

    public static class MatchFailedException
    extends RuntimeException {
        private static final long serialVersionUID = -1552598851209960664L;
        private final String path;
        private final String details;

        MatchFailedException(String p, String d) {
            this.path = p;
            this.details = d;
        }

        public String getPath() {
            return this.path;
        }

        public String getDetails() {
            return this.details;
        }
    }

    public static class CheckFailedException
    extends Exception {
        private static final long serialVersionUID = -807016373717337524L;
        private final String entityUid;
        private final Class<?> entityType;

        CheckFailedException(String uid, Class<?> type) {
            this.entityUid = uid;
            this.entityType = type;
        }

        public String getEntityUid() {
            return this.entityUid;
        }

        public Class<?> getEntityType() {
            return this.entityType;
        }
    }

    private static class VisitsTracker {
        private final Map<Object, Void> map = new IdentityHashMap<Object, Void>();

        VisitsTracker() {
        }

        void visited(Object obj) {
            this.map.put(obj, null);
        }

        boolean isVisited(Object obj) {
            return this.map.containsKey(obj);
        }
    }
}

