/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.w3c.dom.Element;

public interface Serializer<T> {
    public static final Serializer<Void> VOID = new Serializer<Void>(){

        @Override
        public byte[] serialize(Void obj) {
            return null;
        }

        @Override
        public Void deserialize(byte[] data) {
            return null;
        }
    };
    public static final Serializer<String> STRING = new Serializer<String>(){

        @Override
        public byte[] serialize(String obj) throws Exception {
            return obj == null ? null : obj.getBytes("utf-8");
        }

        @Override
        public String deserialize(byte[] data) throws Exception {
            return data == null ? null : new String(data, "utf-8");
        }
    };

    public static <T extends XSerializable & XSSerializable> Serializer<T> xSerializer() {
        return new Serializer<T>(){

            @Override
            public byte[] serialize(T obj) throws Exception {
                if (obj == null) {
                    return null;
                }
                return XSUtil.toByteArray((XSSerializable)((XSSerializable)obj));
            }

            @Override
            public T deserialize(byte[] data) throws Exception {
                if (data == null || data.length == 0) {
                    return null;
                }
                return (XSerializable)XHelper.readObject((Element)XUtil.fromBytes((byte[])data), (String)".");
            }
        };
    }

    public static <T extends Serializable> Serializer<T> javaSerializer() {
        return new Serializer<T>(){

            @Override
            public byte[] serialize(T obj) throws Exception {
                if (obj == null) {
                    return null;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (ObjectOutputStream oos = new ObjectOutputStream(out);){
                    oos.writeObject(obj);
                }
                return out.toByteArray();
            }

            @Override
            public T deserialize(byte[] data) throws Exception {
                if (data == null || data.length == 0) {
                    return null;
                }
                try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));){
                    Serializable serializable = (Serializable)in.readObject();
                    return serializable;
                }
            }
        };
    }

    public byte[] serialize(T var1) throws Exception;

    public T deserialize(byte[] var1) throws Exception;
}

