/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.kkt.client;

import com.gridnine.kkt.client.RestConnector;
import com.gridnine.kkt.client.RestResponse;
import com.gridnine.kkt.common.model.JsonSerializable;
import com.gridnine.kkt.common.model.api.ChangeCashAmountRequest;
import com.gridnine.kkt.common.model.api.CheckPasswordRequest;
import com.gridnine.kkt.common.model.api.MidofficeCashier;
import com.gridnine.kkt.common.model.api.OpenSessionRequest;
import com.gridnine.kkt.common.model.api.PrintReceiptResponse;
import com.gridnine.kkt.common.model.api.Receipt;
import com.gridnine.kkt.common.model.api.SessionOpenResponse;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class FiscalRestClient {
    private final String serverAddress;
    private final RestConnector connector;

    public FiscalRestClient(String serverAddress) {
        this.serverAddress = serverAddress;
        this.connector = new RestConnector(this.formatServerAddress(serverAddress));
    }

    private static String toString(InputStream stream) throws Exception {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = stream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public RestResponse<Boolean> isCloseSessionRequirePassword() throws Exception {
        return this.connector.get("close_session_require_password", Boolean.class, null);
    }

    public RestResponse<Boolean> checkCloseSessionPassword(String password) throws Exception {
        CheckPasswordRequest checkPasswordRequest = new CheckPasswordRequest();
        checkPasswordRequest.setPassword(password);
        return this.connector.get("check_close_session_password", Boolean.class, (JsonSerializable)checkPasswordRequest);
    }

    public RestResponse<Void> closeSession() throws Exception {
        return this.connector.get("close_session", Void.class, null);
    }

    public RestResponse<Boolean> isDeviceReady() throws Exception {
        return this.connector.get("device_ready", Boolean.class, null);
    }

    public RestResponse<SessionOpenResponse> isSessionOpen() throws Exception {
        return this.connector.get("session_open", SessionOpenResponse.class, null);
    }

    public RestResponse<Boolean> isSessionExpired() throws Exception {
        return this.connector.get("session_expired", Boolean.class, null);
    }

    public RestResponse<PrintReceiptResponse> printReceipt(Receipt receipt) throws Exception {
        return this.connector.get("print_receipt", PrintReceiptResponse.class, (JsonSerializable)receipt);
    }

    public RestResponse<Void> printXReport() throws Exception {
        return this.connector.get("print_x_report", Void.class, null);
    }

    public RestResponse<Void> openSession(String cashier, MidofficeCashier midofficeCashier) throws Exception {
        OpenSessionRequest request = new OpenSessionRequest();
        request.setCashierName(cashier);
        request.setMidofficeCashier(midofficeCashier);
        return this.connector.get("open_session", Void.class, (JsonSerializable)request);
    }

    public RestResponse<Boolean> isFiscalMode() throws Exception {
        return this.connector.get("is_fiscal_mode", Boolean.class, null);
    }

    public RestResponse<String> getOrganizationCode() throws Exception {
        return this.connector.get("get_organization_code", String.class, null);
    }

    public RestResponse<String> checkOFDConnection() throws Exception {
        return this.connector.get("check_ofd_connection", String.class, null);
    }

    public RestResponse<Double> getCashBoxAmount() throws Exception {
        return this.connector.get("cash_box_amount", Double.class, null);
    }

    public RestResponse<Double> cashIncome(Double amount, String cashier, MidofficeCashier midofficeCashier) throws Exception {
        ChangeCashAmountRequest request = new ChangeCashAmountRequest();
        request.setAmount(amount);
        request.setCashierLogin(cashier);
        request.setMidofficeCashier(midofficeCashier);
        return this.connector.get("cash_income", Double.class, (JsonSerializable)request);
    }

    public RestResponse<Double> cashOutcome(Double amount, String cashier, MidofficeCashier midofficeCashier) throws Exception {
        ChangeCashAmountRequest request = new ChangeCashAmountRequest();
        request.setAmount(amount);
        request.setCashierLogin(cashier);
        request.setMidofficeCashier(midofficeCashier);
        return this.connector.get("cash_outcome", Double.class, (JsonSerializable)request);
    }

    private String formatServerAddress(String s) {
        if (!s.startsWith("http://")) {
            s = "http://" + s;
        }
        return s.endsWith("/") ? s + "kkt/rest/" : s + "/kkt/rest/";
    }
}

