/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.rpc;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class VoucherProperties
implements Serializable,
XSerializable {
    private static final long serialVersionUID = 5894432879713175477L;
    private final Map<String, EntityReference<BookingFile>> productUids2BookingFileRefs = new HashMap<String, EntityReference<BookingFile>>();
    private final List<DictionaryReference<InformationNote>> notes = new ArrayList<DictionaryReference<InformationNote>>();
    private final Collection<EntityReference<TemplateDocument>> templateRefs = new ArrayList<EntityReference<TemplateDocument>>();
    private String agencyContacts;
    private boolean hidePrice;
    private boolean hideMeal;
    private boolean hideBasicEssentialInfo;
    private boolean hideAmenities;
    private boolean includeFeesInTotalPrice;

    public VoucherProperties(Map<String, EntityReference<BookingFile>> productUids2BookingFileRefs, List<DictionaryReference<InformationNote>> notesRefs, Collection<EntityReference<TemplateDocument>> templateRefs, String agencyContacts, boolean hidePrise, boolean hideMeal, boolean hideBasicEssentialInfo, boolean hideAmenities, boolean includeFeesInTotalPrice) {
        this.templateRefs.addAll(templateRefs);
        this.agencyContacts = agencyContacts;
        this.notes.addAll(notesRefs);
        this.productUids2BookingFileRefs.putAll(productUids2BookingFileRefs);
        this.hidePrice = hidePrise;
        this.hideMeal = hideMeal;
        this.hideBasicEssentialInfo = hideBasicEssentialInfo;
        this.hideAmenities = hideAmenities;
        this.includeFeesInTotalPrice = includeFeesInTotalPrice;
    }

    public VoucherProperties() {
    }

    public Map<String, EntityReference<BookingFile>> getProductUids2BookingFileRefs() {
        return this.productUids2BookingFileRefs;
    }

    public List<DictionaryReference<InformationNote>> getNotes() {
        return this.notes;
    }

    public Collection<EntityReference<TemplateDocument>> getTemplateRefs() {
        return this.templateRefs;
    }

    public String getAgencyContacts() {
        return this.agencyContacts;
    }

    public boolean isHidePrice() {
        return this.hidePrice;
    }

    public boolean isHideMeal() {
        return this.hideMeal;
    }

    public boolean isHideBasicEssentialInfo() {
        return this.hideBasicEssentialInfo;
    }

    public boolean isHideAmenities() {
        return this.hideAmenities;
    }

    public boolean isIncludeFeesInTotalPrice() {
        return this.includeFeesInTotalPrice;
    }

    public void toXML(Element elm) throws Exception {
        for (EntityReference<TemplateDocument> templateRef : this.templateRefs) {
            XHelper.writeObject((Element)elm, (String)"templateRef", templateRef);
        }
        XHelper.writeString((Element)elm, (String)"agencyContacts", (String)this.agencyContacts);
        XHelper.writeCollection((Element)elm, (String)"notes", this.notes);
        XHelper.writeBoolean((Element)elm, (String)"hidePrice", (boolean)this.hidePrice);
        XHelper.writeBoolean((Element)elm, (String)"hideMeal", (boolean)this.hideMeal);
        XHelper.writeBoolean((Element)elm, (String)"hideBasicEssentialInfo", (boolean)this.hideBasicEssentialInfo);
        XHelper.writeBoolean((Element)elm, (String)"hideAmenities", (boolean)this.hideAmenities);
        XHelper.writeBoolean((Element)elm, (String)"includeFeesInTotalPrice", (boolean)this.includeFeesInTotalPrice);
    }

    public void fromXML(Element elm) throws Exception {
        this.templateRefs.clear();
        for (Element objElm : XmlUtil.getElements((Element)elm, (String)"templateRef")) {
            EntityReference templateRef;
            if (objElm == null) continue;
            String className = objElm.getAttribute("class");
            if (TextUtil.isBlank((String)className)) {
                String ecUid = XmlUtil.getValue((Element)objElm, (String)"uid");
                String refCaption = XmlUtil.getValue((Element)objElm, (String)"caption");
                Class etType = XHelper.getClass((String)XmlUtil.getValue((Element)objElm, (String)"type"));
                templateRef = new EntityReference(ecUid, etType, refCaption);
            } else {
                templateRef = (EntityReference)XHelper.readObject((Element)elm, (String)"templateRef");
            }
            this.templateRefs.add((EntityReference<TemplateDocument>)templateRef);
        }
        this.agencyContacts = XHelper.readString((Element)elm, (String)"agencyContacts");
        this.notes.clear();
        this.notes.addAll(XHelper.readCollection((Element)elm, (String)"notes"));
        this.hidePrice = XHelper.readBoolean((Element)elm, (String)"hidePrice");
        this.hideMeal = XHelper.readBoolean((Element)elm, (String)"hideMeal");
        this.hideBasicEssentialInfo = XHelper.readBoolean((Element)elm, (String)"hideBasicEssentialInfo");
        this.hideAmenities = XHelper.readBoolean((Element)elm, (String)"hideAmenities");
        this.includeFeesInTotalPrice = XHelper.readBoolean((Element)elm, (String)"includeFeesInTotalPrice");
    }
}

