/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.security.acl;

import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.DoubleKeyHashMap;
import com.gridnine.xtrip.common.util.DoubleKeyMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class AclRegistry
implements Serializable {
    private static final long serialVersionUID = -6737552766762378045L;
    private final Map<String, AclGroup> groups = new HashMap<String, AclGroup>();
    private final Map<String, AclUser> users = new HashMap<String, AclUser>();
    private final Map<String, String> group2parent = new HashMap<String, String>();
    private final Map<String, Set<String>> group2children = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> group2users = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> user2groups = new HashMap<String, Set<String>>();
    private final DoubleKeyMap<String, String, AclEntry> entries = new DoubleKeyHashMap();

    public Collection<AclGroup> getGroups() {
        return new HashSet<AclGroup>(this.groups.values());
    }

    public AclGroup getGroup(String groupId) {
        if (groupId == null) {
            return null;
        }
        return this.groups.get(groupId);
    }

    public String getGroupParent(String groupId) {
        if (groupId == null) {
            return null;
        }
        return this.group2parent.get(groupId);
    }

    public Collection<String> getGroupChildren(String groupId) {
        if (groupId == null) {
            return Collections.emptyList();
        }
        Set<String> childIds = this.group2children.get(groupId);
        if (childIds == null) {
            return Collections.emptyList();
        }
        return new HashSet<String>(childIds);
    }

    public Collection<String> getGroupUsers(String groupId) {
        if (groupId == null) {
            return Collections.emptyList();
        }
        Set<String> userIds = this.group2users.get(groupId);
        if (userIds == null) {
            return Collections.emptyList();
        }
        return new HashSet<String>(userIds);
    }

    public void addGroup(AclGroup group) {
        if (group == null || group.getId() == null) {
            return;
        }
        if (this.groups.get(group.getId()) != null) {
            throw new IllegalArgumentException(String.format("group with id %s already added", group.getId()));
        }
        if (group.getParentId() != null) {
            this.registerGroupParent(group.getId(), group.getParentId());
        }
        this.groups.put(group.getId(), group);
    }

    public void removeGroup(AclGroup group) {
        String string;
        Set<String> childIds;
        if (group == null || group.getId() == null) {
            return;
        }
        Set<String> userIds = this.group2users.get(group.getId());
        if (userIds != null) {
            for (String string2 : userIds) {
                this.unregisterGroupUser(group.getId(), string2);
            }
        }
        if ((childIds = this.group2children.get(group.getId())) != null) {
            for (String childId : new HashSet<String>(childIds)) {
                this.unregisterGroupChild(group.getId(), childId);
            }
        }
        if ((string = this.group2parent.get(group.getId())) != null) {
            this.unregisterGroupParent(group.getId(), string);
        }
        this.entries.removeKey1Values((Object)group.getId());
        this.groups.remove(group.getId());
    }

    public void registerGroupParent(String groupId, String parentId) {
        if (groupId == null || parentId == null) {
            return;
        }
        Set<String> groupIds = this.group2children.get(parentId);
        if (groupIds == null) {
            groupIds = new HashSet<String>();
            this.group2children.put(parentId, groupIds);
        }
        groupIds.add(groupId);
        this.group2parent.put(groupId, parentId);
    }

    public void unregisterGroupParent(String groupId, String parentId) {
        if (groupId == null || parentId == null) {
            return;
        }
        Set<String> groupIds = this.group2children.get(parentId);
        if (groupIds != null) {
            groupIds.remove(groupId);
            if (groupIds.isEmpty()) {
                this.group2children.remove(parentId);
            }
        }
        this.group2parent.remove(groupId);
    }

    public void registerGroupChild(String groupId, String childId) {
        this.registerGroupParent(childId, groupId);
    }

    public void unregisterGroupChild(String groupId, String childId) {
        this.unregisterGroupParent(childId, groupId);
    }

    public void registerGroupUser(String groupId, String userId) {
        this.registerUserGroup(userId, groupId);
    }

    public void unregisterGroupUser(String groupId, String userId) {
        this.unregisterUserGroup(userId, groupId);
    }

    public Collection<AclUser> getUsers() {
        return new HashSet<AclUser>(this.users.values());
    }

    public AclUser getUser(String userId) {
        if (userId == null) {
            return null;
        }
        return this.users.get(userId);
    }

    public Collection<String> getUserGroups(String userId) {
        if (userId == null) {
            return Collections.emptyList();
        }
        Set<String> groupIds = this.user2groups.get(userId);
        if (groupIds == null) {
            return Collections.emptyList();
        }
        return new HashSet<String>(groupIds);
    }

    public void addUser(AclUser user) {
        if (user == null || user.getId() == null) {
            return;
        }
        if (this.users.get(user.getId()) != null) {
            throw new IllegalArgumentException(String.format("user with id %s already added", user.getId()));
        }
        for (String groupId : user.getGroupIds()) {
            this.registerUserGroup(user.getId(), groupId);
        }
        this.users.put(user.getId(), user);
    }

    public void removeUser(AclUser user) {
        if (user == null || user.getId() == null) {
            return;
        }
        Set<String> groupIds = this.user2groups.get(user.getId());
        if (groupIds != null) {
            for (String groupId : new HashSet<String>(groupIds)) {
                this.unregisterUserGroup(user.getId(), groupId);
            }
        }
        this.entries.removeKey1Values((Object)user.getId());
        this.users.remove(user.getId());
    }

    public void registerUserGroup(String userId, String groupId) {
        if (userId == null || groupId == null) {
            return;
        }
        Set<String> userIds = this.group2users.get(groupId);
        if (userIds == null) {
            userIds = new HashSet<String>();
            this.group2users.put(groupId, userIds);
        }
        userIds.add(userId);
        Set<String> groupIds = this.user2groups.get(userId);
        if (groupIds == null) {
            groupIds = new HashSet<String>();
            this.user2groups.put(userId, groupIds);
        }
        groupIds.add(groupId);
    }

    public void unregisterUserGroup(String userId, String groupId) {
        Set<String> groupIds;
        if (userId == null || groupId == null) {
            return;
        }
        Set<String> userIds = this.group2users.get(groupId);
        if (userIds != null) {
            userIds.remove(userId);
            if (userIds.isEmpty()) {
                this.group2users.remove(groupId);
            }
        }
        if ((groupIds = this.user2groups.get(userId)) != null) {
            groupIds.remove(groupId);
            if (groupIds.isEmpty()) {
                this.user2groups.remove(userId);
            }
        }
    }

    public Collection<AclEntry> getEntries() {
        return new HashSet<AclEntry>(this.entries.values());
    }

    public Collection<AclEntry> getPrincipalEntries(String principalId) {
        if (principalId == null) {
            return Collections.emptyList();
        }
        return new HashSet<AclEntry>(this.entries.getKey1Values((Object)principalId));
    }

    public Collection<AclEntry> getResourceEntries(String resourceId) {
        if (resourceId == null) {
            return Collections.emptyList();
        }
        return new HashSet<AclEntry>(this.entries.getKey2Values((Object)resourceId));
    }

    public AclEntry getEntry(String principalId, String resourceId) {
        if (principalId == null || resourceId == null) {
            return null;
        }
        return (AclEntry)this.entries.get((Object)principalId, (Object)resourceId);
    }

    public void addEntry(AclEntry entry) {
        if (entry == null || entry.getPrincipalId() == null || entry.getResourceId() == null) {
            return;
        }
        if (this.entries.get((Object)entry.getPrincipalId(), (Object)entry.getResourceId()) != null) {
            throw new IllegalArgumentException(String.format("entry with principal id %s and resource id %s already added", entry.getPrincipalId(), entry.getResourceId()));
        }
        this.entries.put((Object)entry.getPrincipalId(), (Object)entry.getResourceId(), (Object)entry);
    }

    public void removeEntry(AclEntry entry) {
        if (entry == null || entry.getPrincipalId() == null || entry.getResourceId() == null) {
            return;
        }
        this.entries.remove((Object)entry.getPrincipalId(), (Object)entry.getResourceId());
    }
}

