/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.kkt.common.model.api;

import com.gridnine.kkt.common.json.JSONObject;
import com.gridnine.kkt.common.model.JsonSerializable;
import com.gridnine.kkt.common.model.api.MidofficeCashier;
import java.util.Set;

public class ChangeCashAmountRequest
implements JsonSerializable {
    private Double amount;
    private String cashierLogin;
    private MidofficeCashier midofficeCashier;

    @Override
    public void fromJson(JSONObject object) throws Exception {
        if (object.has("amount") && !object.isNull("amount")) {
            this.amount = Double.parseDouble(object.getString("amount"));
        }
        if (object.has("cashier") && !object.isNull("cashier")) {
            this.cashierLogin = object.getString("cashier");
        }
        if (object.has("midofficeCashier")) {
            JSONObject cashierJSON = object.getJSONObject("midofficeCashier");
            MidofficeCashier cashier = new MidofficeCashier();
            cashier.setFullName(cashierJSON.getString("fullName"));
            cashier.setCashierINN(cashierJSON.getString("cashierINN"));
            this.midofficeCashier = cashier;
        }
    }

    @Override
    public void toJson(JSONObject builder, Set<String> fields) throws Exception {
        if (this.amount != null && (fields.isEmpty() || fields.contains("amount"))) {
            builder.put("amount", this.amount.toString());
        }
        if (this.cashierLogin != null && (fields.isEmpty() || fields.contains("cashier"))) {
            builder.put("cashier", this.cashierLogin);
        }
        if (this.midofficeCashier != null && (fields.isEmpty() || fields.contains("midofficeCashier"))) {
            JSONObject jsonCashier = new JSONObject();
            jsonCashier.put("fullName", this.midofficeCashier.getFullName());
            jsonCashier.put("cashierINN", this.midofficeCashier.getCashierINN());
            builder.put("midofficeCashier", jsonCashier);
        }
    }

    public Double getAmount() {
        return this.amount;
    }

    public String getCashierLogin() {
        return this.cashierLogin;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public void setCashierLogin(String cashierLogin) {
        this.cashierLogin = cashierLogin;
    }

    public MidofficeCashier getMidofficeCashier() {
        return this.midofficeCashier;
    }

    public void setMidofficeCashier(MidofficeCashier midofficeCashier) {
        this.midofficeCashier = midofficeCashier;
    }

    public String toString() {
        return "ChangeCashAmountRequest{amount=" + this.amount + ", cashierLogin='" + this.cashierLogin + '\'' + ", midofficeCashier=" + this.midofficeCashier + '}';
    }
}

