/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.kkt.common.model.api;

import com.gridnine.kkt.common.json.JSONArray;
import com.gridnine.kkt.common.json.JSONObject;
import com.gridnine.kkt.common.model.BaseEntity;
import com.gridnine.kkt.common.model.api.CalculationWay;
import com.gridnine.kkt.common.model.api.CorporateClient;
import com.gridnine.kkt.common.model.api.CorrectionData;
import com.gridnine.kkt.common.model.api.MidofficeCashier;
import com.gridnine.kkt.common.model.api.PaymentLine;
import com.gridnine.kkt.common.model.api.PaymentType;
import com.gridnine.kkt.common.model.api.ReceiptLine;
import com.gridnine.kkt.common.model.api.ReceiptPrintOptions;
import com.gridnine.kkt.common.model.api.ReceiptType;
import com.gridnine.kkt.common.model.api.Supplier;
import com.gridnine.kkt.common.model.api.VatRate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Receipt
extends BaseEntity {
    private final List<ReceiptLine> receiptLines = new ArrayList<ReceiptLine>();
    private final List<PaymentLine> paymentLines = new ArrayList<PaymentLine>();
    private final List<String> options = new ArrayList<String>();
    private CorrectionData correctionData;
    private ReceiptType receiptType;
    private String cashierName;
    private MidofficeCashier midofficeCashier;
    private CorporateClient client;
    private String clientAddress = "";

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Receipt receipt = (Receipt)o;
        return this.receiptLines.equals(receipt.receiptLines) && this.paymentLines.equals(receipt.paymentLines) && this.options.equals(receipt.options) && Objects.equals(this.correctionData, receipt.correctionData) && this.receiptType == receipt.receiptType && Objects.equals(this.cashierName, receipt.cashierName) && Objects.equals(this.midofficeCashier, receipt.midofficeCashier) && Objects.equals(this.client, receipt.client) && Objects.equals(this.clientAddress, receipt.clientAddress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.receiptLines, this.paymentLines, this.options, this.correctionData, this.receiptType, this.cashierName, this.midofficeCashier, this.client, this.clientAddress});
    }

    @Override
    public String toString() {
        return "Receipt{receiptLines=" + this.receiptLines + ", paymentLines=" + this.paymentLines + ", options=" + this.options + ", correctionData=" + this.correctionData + ", receiptType=" + (Object)((Object)this.receiptType) + ", cashierName='" + this.cashierName + '\'' + ", midofficeCashier=" + this.midofficeCashier + ", client=" + this.client + ", clientAddress='" + this.clientAddress + '\'' + '}';
    }

    public String getCashierName() {
        return this.cashierName;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    public MidofficeCashier getMidofficeCashier() {
        return this.midofficeCashier;
    }

    public void setMidofficeCashier(MidofficeCashier midofficeCashier) {
        this.midofficeCashier = midofficeCashier;
    }

    public CorrectionData getCorrectionData() {
        return this.correctionData;
    }

    public void setCorrectionData(CorrectionData correctionData) {
        this.correctionData = correctionData;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public List<ReceiptLine> getReceiptLines() {
        return this.receiptLines;
    }

    public List<PaymentLine> getPaymentLines() {
        return this.paymentLines;
    }

    public ReceiptType getReceiptType() {
        return this.receiptType;
    }

    public void setReceiptType(ReceiptType receiptType) {
        this.receiptType = receiptType;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public CorporateClient getClient() {
        return this.client;
    }

    public void setClient(CorporateClient client) {
        this.client = client;
    }

    @Override
    public void toJson(JSONObject builder, Set<String> fields) throws Exception {
        JSONObject jsonLine;
        if (this.receiptType != null && (fields.isEmpty() || fields.contains("receiptType"))) {
            builder.put("receiptType", this.receiptType.toString());
        }
        if (this.clientAddress != null && (fields.isEmpty() || fields.contains("clientAddress"))) {
            builder.put("clientAddress", this.clientAddress);
        }
        if (this.cashierName != null && (fields.isEmpty() || fields.contains("cashierName"))) {
            builder.put("cashierName", this.cashierName);
        }
        if (this.correctionData != null && (fields.isEmpty() || fields.contains("correctionData"))) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("correctionType", this.correctionData.getCorrectionType());
            jsonObject.put("correctionInfo", this.correctionData.getCorrectionBasis());
            jsonObject.put("correctionDate", this.correctionData.getCorrectionDate());
            jsonObject.put("correctionDocumentNumber", this.correctionData.getCorrectionDocumentNumber());
            builder.put("correctionData", jsonObject);
        }
        if (this.receiptLines.size() > 0 && (fields.isEmpty() || fields.contains("receiptLines"))) {
            JSONArray receiptLines = new JSONArray();
            for (ReceiptLine receiptLine : this.getReceiptLines()) {
                jsonLine = new JSONObject();
                jsonLine.put("total", receiptLine.getTotal());
                jsonLine.put("price", receiptLine.getPrice());
                jsonLine.put("productType", receiptLine.getPrintLine());
                if (receiptLine.getPrintDetails() != null) {
                    jsonLine.put("productDetails", receiptLine.getPrintDetails());
                }
                if (receiptLine.getPrintNumber() != null) {
                    jsonLine.put("productNumber", receiptLine.getPrintNumber());
                }
                jsonLine.put("quantity", receiptLine.getQuantity());
                jsonLine.put("vatRate", receiptLine.getVatRate().name());
                jsonLine.put("calculationWay", receiptLine.getCalculationWay().name());
                jsonLine.put("agentSale", String.valueOf(receiptLine.getAgentSale()));
                if (receiptLine.getSupplier() != null && (fields.isEmpty() || fields.contains("supplierInfo"))) {
                    JSONObject jsonObject = new JSONObject();
                    Supplier supplier = receiptLine.getSupplier();
                    jsonObject.put("name", supplier.getName());
                    jsonObject.put("phoneNumber", supplier.getPhoneNum());
                    jsonObject.put("INN", supplier.getINN());
                    jsonLine.put("supplierInfo", jsonObject);
                }
                receiptLines.put(jsonLine);
            }
            builder.put("receiptLines", receiptLines);
        }
        if (this.paymentLines.size() > 0 && (fields.isEmpty() || fields.contains("paymentLines"))) {
            JSONArray paymentLines = new JSONArray();
            for (PaymentLine paymentLine : this.getPaymentLines()) {
                jsonLine = new JSONObject();
                jsonLine.put("sum", paymentLine.getSum());
                jsonLine.put("paymentType", paymentLine.getPaymentType().name());
                paymentLines.put(jsonLine);
            }
            builder.put("paymentLines", paymentLines);
        }
        if (this.options.size() > 0 && (fields.isEmpty() || fields.contains("options"))) {
            JSONArray jsonOptions = new JSONArray();
            for (String string : this.getOptions()) {
                jsonOptions.put(string);
            }
            builder.put("options", jsonOptions);
        }
        if (this.midofficeCashier != null && (fields.isEmpty() || fields.contains("midofficeCashier"))) {
            JSONObject jsonCashier = new JSONObject();
            jsonCashier.put("fullName", this.midofficeCashier.getFullName());
            jsonCashier.put("cashierINN", this.midofficeCashier.getCashierINN());
            builder.put("midofficeCashier", jsonCashier);
        }
        if (this.client != null && (fields.isEmpty() || fields.contains("client"))) {
            JSONObject jsonClient = new JSONObject();
            jsonClient.put("name", this.client.getName());
            jsonClient.put("registrationId", this.client.getRegistrationId());
            builder.put("client", jsonClient);
        }
    }

    @Override
    public void fromJson(JSONObject object) throws Exception {
        Object newLine;
        JSONObject line;
        int i;
        if (object.has("receiptType")) {
            this.receiptType = ReceiptType.valueOf(object.getString("receiptType"));
        }
        if (object.has("correctionData")) {
            this.correctionData = new CorrectionData();
            JSONObject cd = object.getJSONObject("correctionData");
            if (cd.has("correctionType")) {
                this.correctionData.setCorrectionType(cd.getInt("correctionType"));
            }
            if (cd.has("correctionInfo")) {
                this.correctionData.setCorrectionBasis(cd.getString("correctionInfo"));
            }
            if (cd.has("correctionDate")) {
                this.correctionData.setCorrectionDate(cd.getString("correctionDate"));
            }
            if (cd.has("correctionDocumentNumber")) {
                this.correctionData.setCorrectionDocumentNumber(cd.getString("correctionDocumentNumber"));
            }
        }
        if (object.has("clientAddress")) {
            this.clientAddress = object.getString("clientAddress");
        }
        if (object.has("cashierName")) {
            this.cashierName = object.getString("cashierName");
        }
        if (object.has("receiptLines")) {
            JSONArray jsonReceiptLines = object.getJSONArray("receiptLines");
            this.receiptLines.clear();
            for (i = 0; i < jsonReceiptLines.length(); ++i) {
                line = jsonReceiptLines.getJSONObject(i);
                newLine = new ReceiptLine();
                if (line.has("price")) {
                    ((ReceiptLine)newLine).setPrice(new BigDecimal(line.getDouble("price")).setScale(2, 4));
                }
                if (line.has("quantity")) {
                    ((ReceiptLine)newLine).setQuantity(new BigDecimal(line.getDouble("quantity")).setScale(2, 4));
                }
                if (line.has("total")) {
                    ((ReceiptLine)newLine).setTotal(new BigDecimal(line.getDouble("total")).setScale(2, 4));
                }
                if (line.has("calculationWay")) {
                    ((ReceiptLine)newLine).setCalculationWay(CalculationWay.valueOf(line.getString("calculationWay")));
                }
                if (line.has("vatRate")) {
                    ((ReceiptLine)newLine).setVatRate(VatRate.valueOf(line.getString("vatRate")));
                }
                if (line.has("productType")) {
                    ((ReceiptLine)newLine).setPrintName(line.getString("productType"));
                }
                if (line.has("productDetails")) {
                    ((ReceiptLine)newLine).setPrintDetails(line.getString("productDetails"));
                }
                if (line.has("productNumber")) {
                    ((ReceiptLine)newLine).setPrintNumber(line.getString("productNumber"));
                }
                if (line.has("agentSale")) {
                    ((ReceiptLine)newLine).setAgentSale(Boolean.valueOf(line.getString("agentSale")));
                }
                if (line.has("supplierInfo")) {
                    JSONObject supLine = (JSONObject)line.get("supplierInfo");
                    Supplier sup = new Supplier();
                    sup.setName(supLine.getString("name"));
                    sup.setINN(supLine.getString("INN"));
                    if (supLine.has("phoneNumber")) {
                        sup.setPhoneNum(supLine.getString("phoneNumber"));
                    }
                    ((ReceiptLine)newLine).setSupplier(sup);
                }
                this.receiptLines.add((ReceiptLine)newLine);
            }
        }
        if (object.has("paymentLines")) {
            JSONArray jsonPaymentLines = object.getJSONArray("paymentLines");
            this.paymentLines.clear();
            for (i = 0; i < jsonPaymentLines.length(); ++i) {
                line = jsonPaymentLines.getJSONObject(i);
                newLine = new PaymentLine();
                ((PaymentLine)newLine).setSum(new BigDecimal(line.getDouble("sum")).setScale(2, 4));
                ((PaymentLine)newLine).setPaymentType(PaymentType.valueOf(line.getString("paymentType")));
                this.paymentLines.add((PaymentLine)newLine);
            }
        }
        if (object.has("options")) {
            JSONArray jsonOptions = object.getJSONArray("options");
            this.options.clear();
            for (i = 0; i < jsonOptions.length(); ++i) {
                this.options.add(jsonOptions.getString(i));
            }
        }
        if (object.has("midofficeCashier")) {
            JSONObject cashierJSON = object.getJSONObject("midofficeCashier");
            MidofficeCashier cashier = new MidofficeCashier();
            cashier.setFullName(cashierJSON.getString("fullName"));
            cashier.setCashierINN(cashierJSON.getString("cashierINN"));
            this.midofficeCashier = cashier;
        }
        if (object.has("client")) {
            JSONObject clientJSON = object.getJSONObject("client");
            CorporateClient client = new CorporateClient();
            client.setName(clientJSON.getString("name"));
            client.setRegistrationId(clientJSON.getString("registrationId"));
            this.client = client;
        }
    }

    public List<String> validate() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.receiptType == null) {
            result.add("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0442\u0438\u043f \u0447\u0435\u043a\u0430");
        }
        if (this.receiptLines.isEmpty()) {
            result.add("\u041d\u0435\u0442 \u0441\u0442\u0440\u043e\u043a \u0434\u043b\u044f \u043f\u0435\u0447\u0430\u0442\u0438");
        }
        if (this.paymentLines.isEmpty()) {
            result.add("\u041d\u0435\u0442 \u0441\u0442\u0440\u043e\u043a \u043e\u043f\u043b\u0430\u0442\u044b");
        }
        int i = 0;
        for (ReceiptLine receiptLine : this.receiptLines) {
            this.validateReceiptLine(receiptLine, result, i + 1);
            ++i;
        }
        i = 0;
        for (PaymentLine paymentLine : this.paymentLines) {
            this.validatePaymentLine(paymentLine, result, i + 1);
            ++i;
        }
        this.options.stream().filter(o -> Arrays.stream(ReceiptPrintOptions.values()).noneMatch(v -> o.equals(v.name()))).forEach(s -> result.add("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044f \u043e\u043f\u0446\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0438: " + s));
        return result;
    }

    private void validateReceiptLine(ReceiptLine line, List<String> messages, int id) {
        this.validateBigDecimal(line.getPrice(), messages, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0446\u0435\u043d\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 #" + id);
        this.validateBigDecimal(line.getQuantity(), messages, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 #" + id);
        this.validateBigDecimal(line.getTotal(), messages, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 #" + id);
        if (line.getVatRate() == null) {
            messages.add("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0442\u0430\u0432\u043a\u0430 \u041d\u0414\u0421 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 #" + id);
        }
        if (line.getPrintName() == null || line.getPrintName().isEmpty()) {
            messages.add("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u043e\u0432\u0430\u0440 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 #" + id);
        }
        if (line.getTotal() != null && line.getPrice() != null && line.getQuantity() != null && line.getPrice().multiply(line.getQuantity()).setScale(2, 4).compareTo(line.getTotal()) != 0) {
            messages.add("\u041d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441\u0443\u043c\u043c\u0430 \u0434\u043b\u044f \u0442\u043e\u0432\u0430\u0440\u0430 " + line.getPrintName());
        }
        if (line.getCalculationWay() == null) {
            messages.add("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0441\u043f\u043e\u0441\u043e\u0431 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 \u043e\u043f\u043b\u0430\u0442\u044b #" + id);
        }
    }

    private void validateBigDecimal(BigDecimal value, List<String> messages, String errorMessage) {
        if (value == null || value.compareTo(BigDecimal.ZERO) <= 0) {
            messages.add(errorMessage);
        }
    }

    private void validatePaymentLine(PaymentLine line, List<String> messages, int id) {
        this.validateBigDecimal(line.getSum(), messages, "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0443\u043c\u043c\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 \u043e\u043f\u043b\u0430\u0442\u044b #" + id);
        if (line.getPaymentType() == null) {
            messages.add("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u043e\u043f\u043b\u0430\u0442\u044b \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 \u043e\u043f\u043b\u0430\u0442\u044b #" + id);
        }
    }
}

