/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.sirena2000;

import com.gridnine.xtrip.common.gds.sirena2000.KeyInfo;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.midoffice.KeyPairEntry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.Base64;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class KeyPairHelper {
    public List<Message> displayKeyInfo(KeyInfo keyInfo, EntityContainer<SirenaGdsAccount> gdsAccount) {
        KeyPair keyPair;
        ArrayList<Message> msgs = new ArrayList<Message>();
        if (keyInfo.getCurrentClientKeyDigest() != null) {
            msgs.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0414\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043a\u043b\u044e\u0447\u0430: {0}", (Object[])new Object[]{Base64.encode((byte[])keyInfo.getCurrentClientKeyDigest())}));
            msgs.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043a\u043b\u044e\u0447\u0430: {0}", (Object[])new Object[]{new SimpleDateFormat("dd.MM.yyyy").format(keyInfo.getCurrentClientKeyExpired())}));
        }
        if (keyInfo.getUnconfirmedClientKeyDigest() != null) {
            msgs.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0414\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u043d\u0435\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d\u043d\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430: {0}", (Object[])new Object[]{Base64.encode((byte[])keyInfo.getUnconfirmedClientKeyDigest())}));
        }
        if (keyInfo.getFutureClientKeyDigest() != null) {
            msgs.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0414\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u0431\u0443\u0434\u0443\u0449\u0435\u0433\u043e \u043a\u043b\u044e\u0447\u0430: {0}", (Object[])new Object[]{Base64.encode((byte[])keyInfo.getFutureClientKeyDigest())}));
        }
        if ((keyPair = KeyPairHelper.getKeyPairMap().get(((SirenaGdsAccount)gdsAccount.getEntity()).getAccount())) == null) {
            msgs.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u041a\u043b\u044e\u0447 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043c\u0438\u0434\u043e\u0444\u0438\u0441\u0435", (Object[])new Object[0]));
        } else if (keyInfo.getCurrentClientKeyDigest() == null) {
            if (keyInfo.getUnconfirmedClientKeyDigest() != null) {
                if (!Arrays.equals(KeyPairHelper.digest(keyPair.getPublic().getEncoded()), keyInfo.getUnconfirmedClientKeyDigest())) {
                    msgs.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0430 \u0434\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u043d\u0435 \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430! \u041d\u0435\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0432 Sirena \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u043a\u043b\u044e\u0447\u0430 \u0432 \u043c\u0438\u0434\u043e\u0444\u0438\u0441\u0435!", (Object[])new Object[0]));
                } else {
                    msgs.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u043a\u043b\u044e\u0447", (Object[])new Object[0]));
                }
            } else {
                msgs.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u043d\u0435 \u043e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d", (Object[])new Object[0]));
            }
        } else if (!Arrays.equals(KeyPairHelper.digest(keyPair.getPublic().getEncoded()), keyInfo.getCurrentClientKeyDigest())) {
            msgs.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0430 \u0434\u0430\u0439\u0434\u0436\u0435\u0441\u0442 \u043d\u0435 \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430! \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u043b\u044e\u0447 \u0432 Sirena \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u043a\u043b\u044e\u0447\u0430 \u0432 \u043c\u0438\u0434\u043e\u0444\u0438\u0441\u0435!", (Object[])new Object[0]));
        } else if (keyInfo.getCurrentClientKeyExpired().before(this.now())) {
            msgs.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0441\u044f \u0441\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043a\u043b\u044e\u0447\u0430", (Object[])new Object[0]));
        }
        return msgs;
    }

    public Date now() {
        return new Date();
    }

    public static Map<String, KeyPair> getKeyPairMap() {
        AssetsStorage as = AssetsStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getOrders().put(KeyPairEntry.Property.alias.name(), SortOrder.ASC);
        List data = as.search(KeyPairEntry.class, query).getData();
        HashMap<String, KeyPair> result = new HashMap<String, KeyPair>();
        for (KeyPairEntry entry : data) {
            result.put(entry.getAlias(), entry.getKeyPair());
        }
        return result;
    }

    public static byte[] digest(byte[] data) {
        try {
            return MessageDigest.getInstance("SHA-1").digest(data);
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(KeyPairHelper.class).error("", (Throwable)ex);
            return new byte[0];
        }
    }
}

