/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.sirena2000;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaCustomPropertiesHelper;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SirenaHelper {
    private static final CodeTranslator CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.CRT.name(), CodeSystem.IATA.name()});
    public static final String PRODUCTION_PORT = "34321";
    public static final String TEST_PORT = "34322";
    public static final String TRAINING_PORT = "34323";
    private static final Map<CardVendor, String> CARD_VENDOR_MAP = new HashMap<CardVendor, String>();
    private static final Map<PassportType, String> CARD_TYPE_MAP;
    private static final Map<PassengerStatus, String> PASSENGER_STATUS_TO_IATA;
    private static final Map<PassengerStatus, String> PASSENGER_STATUS_TO_CRT;

    public static String getSurname(Reservation reservation) {
        if (!StringUtils.isBlank((String)reservation.getSireanLeadPass())) {
            return reservation.getSireanLeadPass();
        }
        Traveller traveller = ((Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0)).getTraveller();
        return SirenaHelper.buildSurname(traveller);
    }

    public static String fixNameForPNR(String str) {
        if (TextUtil.isBlank((String)str)) {
            return "";
        }
        StringBuilder result = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\u0401') {
                result.append('\u0415');
                continue;
            }
            if (ch == '\u0451') {
                result.append('\u0435');
                continue;
            }
            if (ch == '\u042a') {
                result.append('\u042c');
                continue;
            }
            if (ch == '\u044a') {
                result.append('\u044c');
                continue;
            }
            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') && (ch < '\u0410' || ch > '\u0451')) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public static String currency2native(String curr) {
        if ("RUB".equals(curr)) {
            return "\u0420\u0423\u0411";
        }
        if ("EUR".equals(curr)) {
            return "\u0415\u0412\u0420";
        }
        return curr;
    }

    public static String cardVendor2str(CardVendor vendor) {
        if (vendor == null) {
            return null;
        }
        if (CARD_VENDOR_MAP.containsKey(vendor)) {
            return CARD_VENDOR_MAP.get(vendor);
        }
        throw new IllegalArgumentException("unsupported card vendor " + vendor);
    }

    public static String paymentType2str(SirenaGdsAccount account, PaymentType paymentType, boolean isBsp) {
        if (paymentType == PaymentType.CREDIT_CARD_ONLINE_RAIFFEISEN || paymentType.name().equals("TERMINAL_PAYTRAVEL")) {
            return "\u041f\u041f";
        }
        if (!paymentType.name().startsWith("CREDIT_CARD_BTA") && (paymentType.name().startsWith("CREDIT_CARD") || paymentType.name().startsWith("GATELINE_CREDIT_CARD") || paymentType.name().startsWith("RUSSIANSTANDARD") || paymentType.name().startsWith("RAIFFEISEN") || paymentType.name().startsWith("MASTERBANKCARD") || paymentType.name().equals("EPAYKZT_PAYBOX") || paymentType.name().startsWith("TRANSCRED"))) {
            return TextUtil.isBlank((String)account.getFopCCreplacementCode()) ? "\u041f\u041a" : account.getFopCCreplacementCode();
        }
        if (paymentType.equals((Object)PaymentType.INVOICE)) {
            return "\u041f\u041f";
        }
        return isBsp ? "CA" : "cash";
    }

    public static String idCardType2str(PassportType idCardType) {
        return CARD_TYPE_MAP.get(idCardType);
    }

    public static String buildFullPhoneNumber(Communication phone) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)phone.getCountryCode())) {
            sb.append('+');
            sb.append(ProfileHelper.normalizeCommunicationPart((String)phone.getCountryCode()));
        }
        if (!TextUtil.isBlank((String)phone.getCityCode())) {
            sb.append(ProfileHelper.normalizeCommunicationPart((String)phone.getCityCode()));
        }
        if (!TextUtil.isBlank((String)phone.getSense())) {
            sb.append(ProfileHelper.normalizeCommunicationPart((String)phone.getSense()));
        }
        return sb.toString();
    }

    public static String native2CommunicationType(Communication comm) {
        switch (comm.getType()) {
            case WORK_PHONE: {
                return "work";
            }
            case HOME_PHONE: {
                return "home";
            }
            case FAX: {
                return "fax";
            }
            case MOBILE: {
                return "mobile";
            }
            case HOTEL: {
                return "hotel";
            }
            case AGENCY: {
                return "agency";
            }
            case EMAIL: {
                return "email";
            }
        }
        return "";
    }

    public static String fixDocNumberForPNR(String str) {
        if (TextUtil.isBlank((String)str)) {
            return "";
        }
        StringBuilder result = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\u0401') {
                result.append('\u0415');
                continue;
            }
            if (ch == '\u0451') {
                result.append('\u0435');
                continue;
            }
            if (ch == '\u042a') {
                result.append('\u042c');
                continue;
            }
            if (ch == '\u044a') {
                result.append('\u044c');
                continue;
            }
            if (!(ch >= '\u0410' && ch <= '\u042f' || ch >= '\u0430' && ch <= '\u044f' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') && (ch < '0' || ch > '9')) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public static String native2currency(String code) {
        if ("\u0420\u0423\u0411".equalsIgnoreCase(code)) {
            return "RUB";
        }
        if ("\u0415\u0412\u0420".equalsIgnoreCase(code)) {
            return "EUR";
        }
        return code;
    }

    public static String formatPrice(BigDecimal price) {
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(symbols);
        return df.format(price.doubleValue());
    }

    public static String serviceClassToString(ClassOfService serviceClass) {
        if (serviceClass == null) {
            return null;
        }
        switch (serviceClass) {
            case ECONOMY: {
                return "\u042d";
            }
            case BUSINESS: {
                return "\u0411";
            }
            case FIRST: {
                return "\u041f";
            }
        }
        throw Xeption.forDeveloper((String)"unexpected service class {0}", (Object[])new Object[]{serviceClass});
    }

    public static FlightSegment findMatchingSegment(Flight flight, Segment seg) {
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            for (FlightSegment fSeg : st.getSegments()) {
                if (!MiscUtil.equals((Object)fSeg.getAirline(), (Object)seg.getAirline()) || !MiscUtil.equals((Object)fSeg.getFlightNumber(), (Object)seg.getFlightNo())) continue;
                return fSeg;
            }
        }
        return null;
    }

    public static Product findProductByTraveller(Reservation reservation, Traveller t) {
        for (BaseProduct bp : reservation.getProducts()) {
            Product p = (Product)bp;
            if (!t.equals((Object)p.getTraveller())) continue;
            return p;
        }
        return null;
    }

    public static String convertPassengerStatusToIata(PassengerStatus passengerStatus) {
        return PASSENGER_STATUS_TO_IATA.get(passengerStatus);
    }

    public static String convertPassengerStatusToCrt(PassengerStatus passengerStatus) {
        return PASSENGER_STATUS_TO_CRT.get(passengerStatus);
    }

    public static ClassOfService parseClassOfService(String cls) {
        if (StringUtils.isBlank((String)cls)) {
            return null;
        }
        switch (cls.charAt(0)) {
            case '\u042d': {
                return ClassOfService.ECONOMY;
            }
            case '\u0411': {
                return ClassOfService.BUSINESS;
            }
            case '\u041f': {
                return ClassOfService.FIRST;
            }
        }
        return null;
    }

    public static String getUniqueTravellerName(Traveller traveller) {
        StringBuilder sb = new StringBuilder();
        sb.append(SirenaHelper.fixNameForPNR(traveller.getPassport().getLastName()));
        sb.append('/');
        sb.append(SirenaHelper.fixNameForPNR(traveller.getPassport().getFirstName()));
        if (!StringUtils.isBlank((String)traveller.getPassport().getMiddleName())) {
            sb.append(' ');
            sb.append(SirenaHelper.fixNameForPNR(traveller.getPassport().getMiddleName()));
        }
        return sb.toString().toUpperCase();
    }

    public static String buildName(Traveller traveller, int sliceIdx) {
        StringBuilder sb = new StringBuilder();
        sb.append(SirenaHelper.fixNameForPNR(traveller.getPassport().getFirstName()));
        if (sliceIdx > 0) {
            String nameLastChar = sb.substring(sb.length() - 1, sb.length());
            for (int j = 0; j < sliceIdx; ++j) {
                sb.append(nameLastChar);
            }
        }
        if (!StringUtils.isBlank((String)traveller.getPassport().getMiddleName())) {
            sb.append(' ');
            sb.append(SirenaHelper.fixNameForPNR(traveller.getPassport().getMiddleName()));
        }
        return sb.toString();
    }

    public static String buildSurname(Traveller traveller) {
        String result = SirenaHelper.fixNameForPNR(traveller.getPassport().getLastName());
        if (result.length() > 1) {
            return result;
        }
        return result + result;
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return CODE_TRANSLATOR.resolveNativeCode(cls, code);
    }

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> ref) {
        return CODE_TRANSLATOR.getNativeCode(ref);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, LocationType preferredType) {
        return CODE_TRANSLATOR.resolveNativeCode(cls, code);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, boolean createIfMissing) {
        return CODE_TRANSLATOR.resolveNativeCode(cls, code, createIfMissing);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, boolean createIfMissing, boolean reportMissing) {
        return CODE_TRANSLATOR.resolveNativeCode(cls, code, createIfMissing, reportMissing);
    }

    public static boolean isMultiTicket(Flight flight) {
        return flight.getSegmentTariffs().stream().map(SirenaCustomPropertiesHelper::getTicket).collect(Collectors.toSet()).size() > 1;
    }

    public static boolean isBsp(Reservation reservation) {
        boolean hasBsp = false;
        boolean hasNonBsp = false;
        for (Product product : AirProductHelper.getAirProductsList((Reservation)reservation)) {
            boolean bsp = "BSP".equals(((Organization)EntityStorage.get().resolve(product.getBlankOwnerRef()).getEntity()).getCode());
            if (bsp) {
                if (hasNonBsp) {
                    throw Xeption.forDeveloper((String)"bsp / non-bsp mix", (Object[])new Object[0]);
                }
                hasBsp = true;
                continue;
            }
            if (hasBsp) {
                throw Xeption.forDeveloper((String)"bsp / non-bsp mix", (Object[])new Object[0]);
            }
            hasNonBsp = true;
        }
        return hasBsp;
    }

    public static String getRecordLocator(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocatorOptional((Reservation)reservation, (RecordLocatorType)RecordLocatorType.SIRENA_LATIN).orElseGet(() -> ReservationGdsNameInfoHelper.getOnlineRecordLocatorOptional((Reservation)reservation, (RecordLocatorType)RecordLocatorType.SIRENA_CYRILLIC).orElse(null));
    }

    static {
        CARD_VENDOR_MAP.put(CardVendor.VISA, "VI");
        CARD_VENDOR_MAP.put(CardVendor.MASTERCARD, "CA");
        CARD_VENDOR_MAP.put(CardVendor.JCB, "JC");
        CARD_VENDOR_MAP.put(CardVendor.DINERS_CLUB, "DC");
        CARD_VENDOR_MAP.put(CardVendor.AMEX, "AX");
        CARD_TYPE_MAP = new HashMap<PassportType, String>();
        CARD_TYPE_MAP.put(PassportType.INTERNAL, "\u041f\u0421");
        CARD_TYPE_MAP.put(PassportType.FOREIGN, "\u041f\u0421\u041f");
        CARD_TYPE_MAP.put(PassportType.DIPLOMATIC, "\u0414\u041f");
        CARD_TYPE_MAP.put(PassportType.BIRTHDAY_NOTIFICATION, "\u0421\u0420");
        CARD_TYPE_MAP.put(PassportType.CERTIFICATEOFRELEASE, "\u0421\u041f\u041e");
        CARD_TYPE_MAP.put(PassportType.SEAMANSID, "\u041f\u041c");
        CARD_TYPE_MAP.put(PassportType.MILITARYID, "\u0412\u0411");
        CARD_TYPE_MAP.put(PassportType.PASSPORT, "\u041d\u041f");
        CARD_TYPE_MAP.put(PassportType.PASSPORTLOSSCERTIFICATE, "\u0421\u041f\u0423");
        CARD_TYPE_MAP.put(PassportType.INTERIMCERTIFICATE, "\u0412\u0423\u041b");
        CARD_TYPE_MAP.put(PassportType.MILITARYCERTIFICATE, "\u0423\u0414\u041b");
        CARD_TYPE_MAP.put(PassportType.BACKTOUSSRCERTIFICATE, "\u0421\u0412\u0412");
        CARD_TYPE_MAP.put(PassportType.SERVICE_PASSPORT, "\u0421\u041f");
        CARD_TYPE_MAP.put(PassportType.RESIDENCEPERMIT, "\u0412\u0416");
        CARD_TYPE_MAP.put(PassportType.FOREIGN_NATIONAL_PASSPORT, "\u0417\u0410");
        CARD_TYPE_MAP.put(PassportType.IDENTITYCARD, "\u041d\u041f");
        PASSENGER_STATUS_TO_IATA = new HashMap<PassengerStatus, String>();
        PASSENGER_STATUS_TO_IATA.put(PassengerStatus.VS_MO, "MO");
        PASSENGER_STATUS_TO_IATA.put(PassengerStatus.VS_OVD, "MWD");
        PASSENGER_STATUS_TO_IATA.put(PassengerStatus.VS_VV, "MWD");
        PASSENGER_STATUS_TO_IATA.put(PassengerStatus.VS_OVD_KSK, "MWD");
        PASSENGER_STATUS_TO_CRT = new HashMap<PassengerStatus, String>();
        PASSENGER_STATUS_TO_CRT.put(PassengerStatus.VS_MO, "\u041c\u041e");
        PASSENGER_STATUS_TO_CRT.put(PassengerStatus.VS_OVD, "\u041c\u0412\u0414");
        PASSENGER_STATUS_TO_CRT.put(PassengerStatus.VS_VV, "\u041c\u0412\u0414");
        PASSENGER_STATUS_TO_CRT.put(PassengerStatus.VS_OVD_KSK, "\u041c\u0412\u0414");
    }
}

