/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.sirena2000.meta;

import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdMinistry;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdMinistryReference;
import com.gridnine.xtrip.common.meta.PropertiesRenamer;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SirenaMtdMinistryPropertiesRenamer
implements PropertiesRenamer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void renameProperties(Element elm) throws Exception {
        try {
            String data = XHelper.readString((Element)elm, (String)"ministry");
            PassengerStatus passengerStatus = this.getPassengerStatus(data);
            if (passengerStatus != null) {
                XHelper.writeObject((Element)elm, (String)"passengerStatus", (Object)passengerStatus);
            }
        }
        catch (Throwable t) {
            this.log.error("failed parsing ministry", t);
        }
    }

    private PassengerStatus getPassengerStatus(String ministryCode) {
        SirenaMtdMinistry smm = (SirenaMtdMinistry)DictionaryCache.get().resolveReference((DictionaryReference)new SirenaMtdMinistryReference(ministryCode));
        if (smm == null) {
            return null;
        }
        String crtCode = DictHelper.getCodeVariant((BaseDictionary)smm, (CodeSystem)CodeSystem.CRT);
        if ("\u041c\u041e".equals(crtCode)) {
            return PassengerStatus.VS_MO;
        }
        if ("\u041c\u0412\u0414".equals(crtCode)) {
            return PassengerStatus.VS_MVD;
        }
        return null;
    }
}

