/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStyledText;

public abstract class JRXlsAbstractExporter
extends JRAbstractExporter {
    protected static final String XLS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xls.";
    public static final String PROPERTY_CELL_FORMULA = "net.sf.jasperreports.export.xls.formula";
    public static final String PROPERTY_CELL_PATTERN = "net.sf.jasperreports.export.xls.pattern";
    public static final String PROPERTY_WRAP_TEXT = "net.sf.jasperreports.export.xls.wrap.text";
    public static final String PROPERTY_FIT_WIDTH = "net.sf.jasperreports.export.xls.fit.width";
    public static final String PROPERTY_FIT_HEIGHT = "net.sf.jasperreports.export.xls.fit.height";
    public static final String PROPERTY_CELL_LOCKED = "net.sf.jasperreports.export.xls.cell.locked";
    public static final String PROPERTY_CELL_HIDDEN = "net.sf.jasperreports.export.xls.cell.hidden";
    public static final String PROPERTY_SHEET_HEADER_LEFT = "net.sf.jasperreports.export.xls.sheet.header.left";
    public static final String PROPERTY_SHEET_HEADER_CENTER = "net.sf.jasperreports.export.xls.sheet.header.center";
    public static final String PROPERTY_SHEET_HEADER_RIGHT = "net.sf.jasperreports.export.xls.sheet.header.right";
    public static final String PROPERTY_SHEET_FOOTER_LEFT = "net.sf.jasperreports.export.xls.sheet.footer.left";
    public static final String PROPERTY_SHEET_FOOTER_CENTER = "net.sf.jasperreports.export.xls.sheet.footer.center";
    public static final String PROPERTY_SHEET_FOOTER_RIGHT = "net.sf.jasperreports.export.xls.sheet.footer.right";
    public static final String PROPERTY_SHEET_DIRECTION = "net.sf.jasperreports.export.xls.sheet.direction";
    public static final String PROPERTY_FREEZE_ROW = "net.sf.jasperreports.export.xls.freeze.row";
    public static final String PROPERTY_FREEZE_COLUMN = "net.sf.jasperreports.export.xls.freeze.column";
    public static final String PROPERTY_FREEZE_ROW_EDGE = "net.sf.jasperreports.export.xls.freeze.row.edge";
    public static final String PROPERTY_FREEZE_COLUMN_EDGE = "net.sf.jasperreports.export.xls.freeze.column.edge";
    public static final String PROPERTY_AUTO_FIT_ROW = "net.sf.jasperreports.export.xls.auto.fit.row";
    public static final String PROPERTY_AUTO_FIT_COLUMN = "net.sf.jasperreports.export.xls.auto.fit.column";
    public static final String PROPERTY_AUTO_FILTER = "net.sf.jasperreports.export.xls.auto.filter";
    public static final String PROPERTY_COLUMN_WIDTH = "net.sf.jasperreports.export.xls.column.width";
    public static final String PROPERTY_COLUMN_WIDTH_RATIO = "net.sf.jasperreports.export.xls.column.width.ratio";
    public static final String PROPERTY_ROW_OUTLINE_LEVEL_PREFIX = "net.sf.jasperreports.export.xls.row.outline.level.";
    public static final String PROPERTY_USE_TIMEZONE = "net.sf.jasperreports.export.xls.use.timezone";
    public static final String PROPERTY_WORKBOOK_TEMPLATE = "net.sf.jasperreports.export.xls.workbook.template";
    public static final String PROPERTY_WORKBOOK_TEMPLATE_KEEP_SHEETS = "net.sf.jasperreports.export.xls.workbook.template.keep.sheets";
    public static final String PROPERTY_IGNORE_ANCHORS = "net.sf.jasperreports.export.xls.ignore.anchors";
    public static final String PROPERTY_PAGE_SCALE = "net.sf.jasperreports.export.xls.page.scale";
    public static final String PROPERTY_FIRST_PAGE_NUMBER = "net.sf.jasperreports.export.xls.first.page.number";
    public static final String PROPERTY_SHOW_GRIDLINES = "net.sf.jasperreports.export.xls.show.gridlines";
    protected List<Object> loadedFonts = new ArrayList<Object>();
    protected boolean isOnePagePerSheet;
    protected boolean isRemoveEmptySpaceBetweenRows;
    protected boolean isRemoveEmptySpaceBetweenColumns;
    protected boolean isWhitePageBackground;
    protected boolean isDetectCellType;
    protected boolean isFontSizeFixEnabled;
    protected boolean isImageBorderFixEnabled;
    protected boolean isIgnoreGraphics;
    protected boolean createCustomPalette;
    protected boolean isCollapseRowSpan;
    protected boolean isIgnoreCellBorder;
    protected boolean isIgnoreCellBackground;
    protected boolean wrapText;
    protected boolean cellLocked;
    protected boolean cellHidden;
    protected int maxRowsPerSheet;
    protected String[] sheetNames;
    protected String sheetHeaderLeft;
    protected String sheetHeaderCenter;
    protected String sheetHeaderRight;
    protected String sheetFooterLeft;
    protected String sheetFooterCenter;
    protected String sheetFooterRight;
    protected RunDirectionEnum sheetDirection;
    protected Map<String, String> formatPatternsMap;
    protected JRExportProgressMonitor progressMonitor;
    protected int reportIndex;
    protected int pageIndex;
    protected JRFont defaultFont;
    protected int sheetIndex;
    protected int sheetNamesIndex;
    protected Map<String, Integer> sheetNamesMap;
    protected boolean isIgnorePageMargins;
    protected int gridRowFreezeIndex;
    protected int gridColumnFreezeIndex;
    protected int maxRowFreezeIndex;
    protected int maxColumnFreezeIndex;
    protected boolean isFreezeRowEdge;
    protected boolean isFreezeColumnEdge;
    protected String autoFilterStart;
    protected String autoFilterEnd;
    protected Float columnWidthRatio;
    protected Integer documentPageScale;
    protected Integer sheetPageScale;
    protected Integer documentFirstPageNumber;
    protected Integer sheetFirstPageNumber;
    protected boolean firstPageNotSet;
    protected Boolean keepTemplateSheets;
    protected String workbookTemplate;
    protected boolean ignoreAnchors;
    protected Boolean documentShowGridlines;
    protected Boolean sheetShowGridlines;
    protected String invalidCharReplacement;

    protected JRFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRXlsAbstractExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXlsAbstractExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block19: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(XLS_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.setParameters();
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    this.exportReportToStream(os);
                    break block19;
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                    os.flush();
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setParameters() {
        this.isOnePagePerSheet = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, "net.sf.jasperreports.export.xls.one.page.per.sheet", false);
        this.isRemoveEmptySpaceBetweenRows = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, "net.sf.jasperreports.export.xls.remove.empty.space.between.rows", false);
        this.isRemoveEmptySpaceBetweenColumns = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, "net.sf.jasperreports.export.xls.remove.empty.space.between.columns", false);
        this.isWhitePageBackground = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", false);
        this.setBackground();
        this.isDetectCellType = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, "net.sf.jasperreports.export.xls.detect.cell.type", false);
        this.isFontSizeFixEnabled = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, "net.sf.jasperreports.export.xls.font.size.fix.enabled", false);
        this.isImageBorderFixEnabled = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IMAGE_BORDER_FIX_ENABLED, "net.sf.jasperreports.export.xls.image.border.fix.enabled", false);
        this.isIgnoreGraphics = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, "net.sf.jasperreports.export.xls.ignore.graphics", false);
        this.createCustomPalette = this.getBooleanParameter(JRXlsAbstractExporterParameter.CREATE_CUSTOM_PALETTE, "net.sf.jasperreports.export.xls.create.custom.palette", false);
        this.isCollapseRowSpan = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, "net.sf.jasperreports.export.xls.collapse.row.span", false);
        this.isIgnoreCellBorder = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, "net.sf.jasperreports.export.xls.ignore.cell.border", false);
        this.isIgnoreCellBackground = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BACKGROUND, "net.sf.jasperreports.export.xls.ignore.cell.background", false);
        this.wrapText = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_WRAP_TEXT, true);
        this.cellLocked = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_CELL_LOCKED, true);
        this.cellHidden = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_CELL_HIDDEN, false);
        this.setFontMap();
        this.setHyperlinkProducerFactory();
        this.maxRowsPerSheet = this.getIntegerParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, "net.sf.jasperreports.export.xls.max.rows.per.sheet", 0);
        this.isIgnorePageMargins = this.getBooleanParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, "net.sf.jasperreports.export.ignore.page.margins", false);
        this.sheetHeaderLeft = this.getPropertiesUtil().getProperty(this.jasperPrint, PROPERTY_SHEET_HEADER_LEFT);
        this.sheetHeaderCenter = this.getPropertiesUtil().getProperty(this.jasperPrint, PROPERTY_SHEET_HEADER_CENTER);
        this.sheetHeaderRight = this.getPropertiesUtil().getProperty(this.jasperPrint, PROPERTY_SHEET_HEADER_RIGHT);
        this.sheetFooterLeft = this.getPropertiesUtil().getProperty(this.jasperPrint, PROPERTY_SHEET_FOOTER_LEFT);
        this.sheetFooterCenter = this.getPropertiesUtil().getProperty(this.jasperPrint, PROPERTY_SHEET_FOOTER_CENTER);
        this.sheetFooterRight = this.getPropertiesUtil().getProperty(this.jasperPrint, PROPERTY_SHEET_FOOTER_RIGHT);
        String sheetDirectionProp = this.getPropertiesUtil().getProperty(this.jasperPrint, PROPERTY_SHEET_DIRECTION);
        this.sheetDirection = sheetDirectionProp == null ? RunDirectionEnum.LTR : RunDirectionEnum.getByName(sheetDirectionProp);
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
        this.workbookTemplate = this.workbookTemplate == null ? this.getPropertiesUtil().getProperty(this.jasperPrint, PROPERTY_WORKBOOK_TEMPLATE) : this.workbookTemplate;
        this.keepTemplateSheets = this.keepTemplateSheets == null ? this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_WORKBOOK_TEMPLATE_KEEP_SHEETS, false) : this.keepTemplateSheets.booleanValue();
    }

    protected void setExporterHints() {
        this.setSheetNames();
        this.gridRowFreezeIndex = Math.max(0, this.getPropertiesUtil().getIntegerProperty(this.jasperPrint, PROPERTY_FREEZE_ROW, 0) - 1);
        this.gridColumnFreezeIndex = Math.max(0, this.getColumnIndex(this.getPropertiesUtil().getProperty(this.jasperPrint, PROPERTY_FREEZE_COLUMN)));
        this.columnWidthRatio = Float.valueOf(this.getPropertiesUtil().getFloatProperty(this.jasperPrint, PROPERTY_COLUMN_WIDTH_RATIO, 0.0f));
        this.documentPageScale = this.getPropertiesUtil().getIntegerProperty(this.jasperPrint, PROPERTY_PAGE_SCALE, 0);
        this.documentFirstPageNumber = this.getPropertiesUtil().getIntegerProperty(this.jasperPrint, PROPERTY_FIRST_PAGE_NUMBER, 0);
        this.ignoreAnchors = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_IGNORE_ANCHORS, false);
        this.invalidCharReplacement = this.jasperPrint.hasProperties() && this.jasperPrint.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") ? this.jasperPrint.getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") : this.getPropertiesUtil().getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars", this.jasperPrint);
        this.documentShowGridlines = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_SHOW_GRIDLINES, true);
    }

    protected abstract void setBackground();

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.openWorkbook(os);
        this.sheetNamesMap = new HashMap<String, Integer>();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            List<JRPrintPage> pages;
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            this.setExporterHints();
            if (this.getParameter(JRXlsAbstractExporterParameter.SHEET_NAMES) == null || this.getParameterResolver() instanceof JRAbstractExporter.ParameterOverriddenResolver && this.sheetNames != null && this.sheetNames.length > 0) {
                this.sheetNamesIndex = 0;
            }
            if ((pages = this.jasperPrint.getPages()) != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                if (this.isOnePagePerSheet) {
                    this.pageIndex = this.startPageIndex;
                    while (this.pageIndex <= this.endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        CutsInfo xCuts = JRGridLayout.calculateXCuts(this.getNature(), pages, this.pageIndex, this.pageIndex, this.jasperPrint.getPageWidth(), this.globalOffsetX);
                        this.sheetFirstPageNumber = (Integer)xCuts.getPropertiesMap().get(PROPERTY_FIRST_PAGE_NUMBER);
                        this.sheetShowGridlines = (Boolean)xCuts.getPropertiesMap().get(PROPERTY_SHOW_GRIDLINES);
                        this.setScale(xCuts, false);
                        this.createSheet(this.getSheetName(xCuts, null));
                        ++this.sheetIndex;
                        ++this.sheetNamesIndex;
                        this.resetAutoFilters();
                        this.setFreezePane(this.gridRowFreezeIndex, this.gridColumnFreezeIndex);
                        this.exportPage(page, null, 0);
                        ++this.pageIndex;
                    }
                } else {
                    CutsInfo xCuts = JRGridLayout.calculateXCuts(this.getNature(), pages, this.startPageIndex, this.endPageIndex, this.jasperPrint.getPageWidth(), this.globalOffsetX);
                    this.sheetFirstPageNumber = (Integer)xCuts.getPropertiesMap().get(PROPERTY_FIRST_PAGE_NUMBER);
                    this.sheetShowGridlines = (Boolean)xCuts.getPropertiesMap().get(PROPERTY_SHOW_GRIDLINES);
                    this.setScale(xCuts, false);
                    this.createSheet(this.getSheetName(xCuts, this.jasperPrint.getName()));
                    ++this.sheetIndex;
                    ++this.sheetNamesIndex;
                    this.resetAutoFilters();
                    this.setFreezePane(this.gridRowFreezeIndex, this.gridColumnFreezeIndex);
                    if (this.filter instanceof ResetableExporterFilter) {
                        ((ResetableExporterFilter)this.filter).reset();
                    }
                    int startRow = 0;
                    this.pageIndex = this.startPageIndex;
                    while (this.pageIndex <= this.endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        startRow = this.exportPage(page, xCuts, startRow);
                        ++this.pageIndex;
                    }
                    this.updateColumns(xCuts);
                }
            }
            ++this.reportIndex;
        }
        this.closeWorkbook(os);
    }

    protected int exportPage(JRPrintPage page, CutsInfo xCuts, int startRow) throws JRException {
        boolean createXCuts;
        JRGridLayout layout = new JRGridLayout(this.getNature(), page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, xCuts);
        JRExporterGridCell[][] grid = layout.getGrid();
        boolean bl = createXCuts = xCuts == null;
        if (createXCuts) {
            xCuts = layout.getXCuts();
            this.setColumnWidths(xCuts);
        }
        if (startRow == 0) {
            this.setColumnWidths(xCuts);
        }
        this.setScale(xCuts, true);
        CutsInfo yCuts = layout.getYCuts();
        XlsRowLevelInfo levelInfo = new XlsRowLevelInfo();
        int skippedRows = 0;
        int rowIndex = startRow;
        for (int y = 0; y < grid.length; ++y) {
            rowIndex = y - skippedRows + startRow;
            if (this.maxRowsPerSheet > 0 && rowIndex >= this.maxRowsPerSheet || yCuts.isBreak(y)) {
                this.updateColumns(xCuts);
                this.setRowLevels(levelInfo, null);
                this.sheetFirstPageNumber = null;
                this.sheetShowGridlines = null;
                this.createSheet(this.getSheetName(xCuts, null));
                this.setScale(xCuts, true);
                this.setColumnWidths(xCuts);
                startRow = 0;
                rowIndex = 0;
                skippedRows = y;
                ++this.sheetIndex;
                ++this.sheetNamesIndex;
                this.resetAutoFilters();
                this.setFreezePane(this.gridRowFreezeIndex, this.gridColumnFreezeIndex);
            }
            if (yCuts.isCutNotEmpty(y) || (!this.isRemoveEmptySpaceBetweenRows || yCuts.isCutSpanned(y)) && !this.isCollapseRowSpan) {
                JRExporterGridCell[] gridRow = grid[y];
                int emptyCellColSpan = 0;
                Map<String, Object> cutProperties = yCuts.getCut(y).getPropertiesMap();
                this.mergeAndSetRowLevels(levelInfo, (SortedMap)cutProperties.get(PROPERTY_ROW_OUTLINE_LEVEL_PREFIX), rowIndex);
                this.setRowHeight(rowIndex, this.isCollapseRowSpan ? layout.getMaxRowHeight(y) : JRGridLayout.getRowHeight(gridRow), yCuts.getCut(y), levelInfo);
                int emptyCols = 0;
                for (int colIndex = 0; colIndex < gridRow.length; ++colIndex) {
                    emptyCols += this.isRemoveEmptySpaceBetweenColumns && !xCuts.isCutNotEmpty(colIndex) && !xCuts.isCutSpanned(colIndex) ? 1 : 0;
                    JRExporterGridCell gridCell = gridRow[colIndex];
                    this.setCell(gridCell, colIndex, rowIndex);
                    if (gridCell.getType() == 2) {
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                        }
                        this.addOccupiedCell((OccupiedGridCell)gridCell, colIndex, rowIndex);
                        continue;
                    }
                    if (gridCell.getWrapper() != null) {
                        String autofilter;
                        int columnFreezeIndex;
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                        }
                        JRPrintElement element = gridCell.getWrapper().getElement();
                        String rowFreeze = this.getPropertiesUtil().getProperty(element, PROPERTY_FREEZE_ROW_EDGE);
                        int rowFreezeIndex = rowFreeze == null ? 0 : (EdgeEnum.BOTTOM.getName().equals(rowFreeze) ? rowIndex + gridCell.getRowSpan() : rowIndex);
                        String columnFreeze = this.getPropertiesUtil().getProperty(element, PROPERTY_FREEZE_COLUMN_EDGE);
                        int n = columnFreeze == null ? 0 : (columnFreezeIndex = EdgeEnum.RIGHT.getName().equals(columnFreeze) ? colIndex + gridCell.getColSpan() : colIndex);
                        if (rowFreezeIndex > 0 || columnFreezeIndex > 0) {
                            this.setFreezePane(rowFreezeIndex, columnFreezeIndex, rowFreezeIndex > 0, columnFreezeIndex > 0);
                        }
                        if ("Start".equals(autofilter = this.getPropertiesUtil().getProperty(element, PROPERTY_AUTO_FILTER))) {
                            this.autoFilterStart = this.getColumnName(colIndex) + (rowIndex + 1);
                        } else if ("End".equals(autofilter)) {
                            this.autoFilterEnd = this.getColumnName(colIndex) + (rowIndex + 1);
                        }
                        if (element instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintRectangle) {
                            this.exportRectangle((JRPrintRectangle)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintEllipse) {
                            this.exportRectangle((JRPrintEllipse)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, gridCell, colIndex, rowIndex, emptyCols, y, layout);
                            continue;
                        }
                        if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintFrame) {
                            this.exportFrame((JRPrintFrame)element, gridCell, colIndex, y);
                            continue;
                        }
                        if (!(element instanceof JRGenericPrintElement)) continue;
                        this.exportGenericElement((JRGenericPrintElement)element, gridCell, colIndex, rowIndex, emptyCols, y, layout);
                        continue;
                    }
                    ++emptyCellColSpan;
                    this.addBlankCell(gridCell, colIndex, rowIndex);
                }
                ++rowIndex;
                continue;
            }
            ++skippedRows;
        }
        if (this.autoFilterStart != null) {
            this.setAutoFilter(this.autoFilterStart + ":" + (this.autoFilterEnd != null ? this.autoFilterEnd : this.autoFilterStart));
        } else if (this.autoFilterEnd != null) {
            this.setAutoFilter(this.autoFilterEnd + ":" + this.autoFilterEnd);
        }
        if (createXCuts) {
            this.updateColumns(xCuts);
        }
        this.setRowLevels(levelInfo, null);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
        return rowIndex;
    }

    protected void mergeAndSetRowLevels(XlsRowLevelInfo levelInfo, SortedMap<String, Boolean> rowLevelMap, int rowIndex) {
        SortedMap<String, Integer> crtLevelMap = levelInfo.getLevelMap();
        if (rowLevelMap != null) {
            for (String level : rowLevelMap.keySet()) {
                Iterator<String> it;
                Boolean isEndMarker = (Boolean)rowLevelMap.get(level);
                if (crtLevelMap.containsKey(level)) {
                    if (!isEndMarker.booleanValue()) continue;
                    this.setRowLevels(levelInfo, level);
                    it = crtLevelMap.keySet().iterator();
                    while (it.hasNext()) {
                        if (level.compareTo(it.next()) > 0) continue;
                        it.remove();
                    }
                    continue;
                }
                if (crtLevelMap.size() > 0 && level.compareTo(crtLevelMap.firstKey()) < 0) {
                    this.setRowLevels(levelInfo, level);
                    it = crtLevelMap.keySet().iterator();
                    while (it.hasNext()) {
                        if (level.compareTo(it.next()) >= 0) continue;
                        it.remove();
                    }
                }
                crtLevelMap.put(level, rowIndex);
            }
        }
        levelInfo.setEndIndex(rowIndex);
    }

    protected void setColumnWidths(CutsInfo xCuts) {
        Map<String, Object> xCutsProperties = xCuts.getPropertiesMap();
        Float ratio = (Float)xCutsProperties.get(PROPERTY_COLUMN_WIDTH_RATIO);
        float sheetRatio = ratio != null && ratio.floatValue() > 0.0f ? ratio.floatValue() : (this.columnWidthRatio.floatValue() > 0.0f ? this.columnWidthRatio.floatValue() : 1.0f);
        for (int col = 0; col < xCuts.size() - 1; ++col) {
            if (this.isRemoveEmptySpaceBetweenColumns && !xCuts.isCutNotEmpty(col) && !xCuts.isCutSpanned(col)) continue;
            Integer width = (Integer)xCutsProperties.get(PROPERTY_COLUMN_WIDTH);
            width = width == null ? (int)((float)(xCuts.getCutOffset(col + 1) - xCuts.getCutOffset(col)) * sheetRatio) : width;
            Map<String, Object> cutProperties = xCuts.getCut(col).getPropertiesMap();
            boolean isAutoFit = cutProperties.containsKey(PROPERTY_AUTO_FIT_COLUMN) && (Boolean)cutProperties.get(PROPERTY_AUTO_FIT_COLUMN) != false;
            this.setColumnWidth(col, width, isAutoFit);
        }
    }

    protected void setScale(CutsInfo xCuts, boolean isToApply) {
        Map<String, Object> xCutsProperties = xCuts.getPropertiesMap();
        Integer scale = (Integer)xCutsProperties.get(PROPERTY_PAGE_SCALE);
        Integer n = this.sheetPageScale = this.isValidScale(scale) ? scale : this.documentPageScale;
        if (isToApply) {
            this.setScale(this.sheetPageScale);
        }
    }

    protected void updateColumns(CutsInfo xCuts) {
        for (int col = xCuts.size() - 1; col >= 0; --col) {
            Map<String, Object> cutProperties;
            boolean isAutoFit;
            Cut xCut = xCuts.getCut(col);
            if (this.isRemoveEmptySpaceBetweenColumns && !xCut.isCutNotEmpty() && !xCut.isCutSpanned()) {
                this.removeColumn(col);
            }
            boolean bl = isAutoFit = (cutProperties = xCuts.getCut(col).getPropertiesMap()).containsKey(PROPERTY_AUTO_FIT_COLUMN) && (Boolean)cutProperties.get(PROPERTY_AUTO_FIT_COLUMN) != false;
            if (!isAutoFit) continue;
            this.updateColumn(col, isAutoFit);
        }
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledTextAttributeSelector selector = textElement.getModeValue() == ModeEnum.OPAQUE ? this.allSelector : this.noBackcolorSelector;
        return textElement.getFullStyledText(selector);
    }

    protected static TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        HorizontalAlignEnum horizontalAlignment;
        VerticalAlignEnum verticalAlignment;
        RotationEnum rotation = textElement.getRotationValue();
        block0 : switch (textElement.getRotationValue()) {
            case LEFT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalAlignEnum.LEFT;
                break;
            }
            case RIGHT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalAlignEnum.RIGHT;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignmentValue();
                verticalAlignment = textElement.getVerticalAlignmentValue();
            }
        }
        return new TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    protected int getImageBorderCorrection(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            if (lineWidth >= 2.0f) {
                return 2;
            }
            return 1;
        }
        return this.isImageBorderFixEnabled ? 1 : 0;
    }

    private String getSheetName(CutsInfo xCuts, String sheetName) {
        String name;
        String string = name = xCuts == null ? null : (String)xCuts.getPropertiesMap().get("net.sf.jasperreports.export.xls.sheet.name");
        if (name != null) {
            if (this.sheetNames != null && this.sheetNamesIndex < this.sheetNames.length) {
                this.sheetNames[this.sheetNamesIndex] = name;
            }
            return this.getSheetName(name);
        }
        return this.getSheetName(sheetName);
    }

    private String getSheetName(String sheetName) {
        String validSheetName;
        if (this.sheetNames != null && this.sheetNamesIndex < this.sheetNames.length) {
            sheetName = this.sheetNames[this.sheetNamesIndex];
        }
        if (sheetName == null) {
            return "Page " + (this.sheetIndex + 1);
        }
        int crtIndex = 1;
        String txtIndex = "";
        String string = validSheetName = sheetName.length() < 32 ? sheetName : sheetName.substring(0, 31);
        if (this.sheetNamesMap.containsKey(validSheetName)) {
            crtIndex = this.sheetNamesMap.get(validSheetName) + 1;
            txtIndex = String.valueOf(crtIndex);
        }
        this.sheetNamesMap.put(validSheetName, crtIndex);
        String name = sheetName;
        if (txtIndex.length() > 0) {
            name = name + " " + txtIndex;
        }
        if (name.length() > 31) {
            name = (sheetName + " ").substring(0, 31 - txtIndex.length()) + txtIndex;
        }
        return name;
    }

    protected final int calculateWidthForDinAN(int n) {
        return (int)(Math.pow(2.0, -0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinAN(int n) {
        return (int)(Math.pow(2.0, 0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinBN(int n) {
        return (int)(Math.pow(2.0, -((double)n / 2.0)) * 1000.0);
    }

    protected final int calculateHeightForDinBN(int n) {
        return (int)(Math.pow(2.0, 0.5 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinCN(int n) {
        return (int)(Math.pow(2.0, -0.125 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinCN(int n) {
        return (int)(Math.pow(2.0, 0.375 - (double)n / 2.0) * 1000.0);
    }

    protected boolean isWrapText(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_WRAP_TEXT)) {
            return this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_WRAP_TEXT, this.wrapText);
        }
        return this.wrapText;
    }

    protected boolean isCellLocked(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_CELL_LOCKED)) {
            return this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_CELL_LOCKED, this.cellLocked);
        }
        return this.cellLocked;
    }

    protected String getFormula(JRPrintText text) {
        String formula = text.getPropertiesMap().getProperty(PROPERTY_CELL_FORMULA);
        if (formula != null && (formula = formula.trim()).startsWith("=")) {
            formula = formula.substring(1);
        }
        return formula;
    }

    protected void setSheetNames() {
        String[] sheetNamesArray = this.getStringArrayParameter(JRXlsAbstractExporterParameter.SHEET_NAMES, "net.sf.jasperreports.export.xls.sheet.names.");
        if (sheetNamesArray != null) {
            ArrayList<String> sheetNamesList = new ArrayList<String>();
            for (int i = 0; i < sheetNamesArray.length; ++i) {
                if (sheetNamesArray[i] == null) {
                    sheetNamesList.add(null);
                    continue;
                }
                String[] currentSheetNamesArray = sheetNamesArray[i].split("/");
                for (int j = 0; j < currentSheetNamesArray.length; ++j) {
                    sheetNamesList.add(currentSheetNamesArray[j]);
                }
            }
            this.sheetNames = sheetNamesList.toArray(new String[sheetNamesList.size()]);
        }
    }

    protected boolean isCellHidden(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_CELL_HIDDEN)) {
            return this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_CELL_HIDDEN, this.cellHidden);
        }
        return this.cellHidden;
    }

    protected String getConvertedPattern(JRPrintText text, String pattern) {
        String convertedPattern = text.getPropertiesMap().getProperty(PROPERTY_CELL_PATTERN);
        if (convertedPattern == null) {
            if (this.formatPatternsMap != null && this.formatPatternsMap.containsKey(pattern)) {
                return this.formatPatternsMap.get(pattern);
            }
            return pattern;
        }
        return convertedPattern;
    }

    protected int getColumnIndex(String columnName) {
        String upperColumnName;
        int index = -1;
        if (columnName != null && (upperColumnName = columnName.toUpperCase()).matches("[A-Z]*")) {
            for (int i = 0; i < upperColumnName.length(); ++i) {
                index += (upperColumnName.charAt(i) - 64) * (int)Math.pow(26.0, upperColumnName.length() - i - 1);
            }
        }
        return index;
    }

    protected String getColumnName(int columnIndex) {
        int i = columnIndex / 26 + 64;
        int j = columnIndex % 26 + 65;
        return (i > 64 ? String.valueOf((char)i) : "") + (char)j;
    }

    protected void setFreezePane(int rowIndex, int colIndex) {
        if (this.gridRowFreezeIndex > 0 || this.gridColumnFreezeIndex > 0) {
            this.setFreezePane(rowIndex, colIndex, false, false);
        }
    }

    protected void resetAutoFilters() {
        this.autoFilterStart = null;
        this.autoFilterEnd = null;
    }

    protected Date translateDateValue(JRPrintText text, Date value) {
        String prop = this.getPropertiesUtil().getProperty(PROPERTY_USE_TIMEZONE, text, this.jasperPrint);
        if (JRPropertiesUtil.asBoolean(prop)) {
            TimeZone tz = this.getTextTimeZone(text);
            value = JRDataUtils.translateToTimezone(value, tz);
        }
        return value;
    }

    protected boolean isValidScale(Integer scale) {
        return scale != null && scale > 9 && scale < 401;
    }

    public boolean isWorkbookTemplateKeepSheets() {
        return this.keepTemplateSheets;
    }

    public void setWorkbookTemplateKeepSheets(boolean keepTemplateSheets) {
        this.keepTemplateSheets = keepTemplateSheets;
    }

    public String getWorkbookTemplate() {
        return this.workbookTemplate;
    }

    public void setWorkbookTemplate(String workbookTemplate) {
        this.workbookTemplate = workbookTemplate;
    }

    public boolean isIgnoreAnchors() {
        return this.ignoreAnchors;
    }

    public void setIgnoreAnchors(boolean ignoreAnchors) {
        this.ignoreAnchors = ignoreAnchors;
    }

    protected abstract ExporterNature getNature();

    protected abstract void openWorkbook(OutputStream var1) throws JRException;

    protected abstract void createSheet(String var1);

    protected abstract void closeWorkbook(OutputStream var1) throws JRException;

    protected abstract void setColumnWidth(int var1, int var2, boolean var3);

    protected abstract void removeColumn(int var1);

    protected abstract void updateColumn(int var1, boolean var2);

    protected abstract void setRowHeight(int var1, int var2, Cut var3, XlsRowLevelInfo var4) throws JRException;

    protected abstract void setCell(JRExporterGridCell var1, int var2, int var3);

    protected abstract void addBlankCell(JRExporterGridCell var1, int var2, int var3) throws JRException;

    protected abstract void addOccupiedCell(OccupiedGridCell var1, int var2, int var3) throws JRException;

    protected abstract void exportText(JRPrintText var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportImage(JRPrintImage var1, JRExporterGridCell var2, int var3, int var4, int var5, int var6, JRGridLayout var7) throws JRException;

    protected abstract void exportRectangle(JRPrintGraphicElement var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportLine(JRPrintLine var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportGenericElement(JRGenericPrintElement var1, JRExporterGridCell var2, int var3, int var4, int var5, int var6, JRGridLayout var7) throws JRException;

    protected abstract void setFreezePane(int var1, int var2, boolean var3, boolean var4);

    protected abstract void setSheetName(String var1);

    protected abstract void setAutoFilter(String var1);

    protected abstract void setRowLevels(XlsRowLevelInfo var1, String var2);

    protected abstract void setScale(Integer var1);

    protected static class TextAlignHolder {
        public final HorizontalAlignEnum horizontalAlignment;
        public final VerticalAlignEnum verticalAlignment;
        public final RotationEnum rotation;

        public TextAlignHolder(HorizontalAlignEnum horizontalAlignment, VerticalAlignEnum verticalAlignment, RotationEnum rotation) {
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
        }
    }
}

