/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.model.finance.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bg.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BillingItemServiceData;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class AirProductFinanceHelper {
    private static final String ZERO_VAT_RATE_REASON_1 = "\u0447\u043b.21, \u0430\u043b.(2) \u0417\u0414\u0414\u0421";
    private static final String ZERO_VAT_RATE_REASON_2 = "\u0447\u043b.36, \u0430\u043b.(1) \u0417\u0414\u0414\u0421";
    private static final String ZERO_VAT_RATE_REASON_3 = "\u0447\u043b.24 \u0432\u044a\u0432 \u0432\u0440.\u0441 \u0447\u043b. 21, \u0430\u043b.(4), \u0442.2";

    public static boolean includeInFinanceDocuments(Product product) {
        if (product.getStatus() == ProductStatus.EXCHANGE || ProductStatusHandler.getAllNonIssuedVoidStatuses().contains(product.getStatus())) {
            return false;
        }
        if (product.getProductCategory() == ProductCategory.KRS) {
            return false;
        }
        if (product.getMcoCategory() != null) {
            switch (product.getMcoCategory()) {
                case ADDITIONAL_TAX: 
                case INFORMATION: 
                case RETURN_FARE_DIFFERENCE: {
                    return false;
                }
            }
        }
        return true;
    }

    public static Collection<BillingItem> getBillingItems(List<Product> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        HashMap tickets = new HashMap();
        HashMap mcos = new HashMap();
        HashMap fees = new HashMap();
        HashMap discounts = new HashMap();
        LinkedList<BillingItem> billingItems = new LinkedList<BillingItem>();
        for (Product product : products) {
            String description = AirProductFinanceHelper.getDescription(product);
            if (product.getProductCategory() == ProductCategory.AIR) {
                FinanceDocumentsHelper.updateMap(tickets, (String)description, (Object)product);
            } else if (product.getProductCategory() == ProductCategory.MCO) {
                FinanceDocumentsHelper.updateMap(mcos, (String)description, (Object)product);
            }
            LinkedList commissions = new LinkedList();
            commissions.addAll(com.gridnine.xtrip.common.model.helpers.AirProductHelper.getUnmodifiableCommissions((Product)product, null));
            for (Commission commission : commissions) {
                CommissionData commissionData;
                EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commission.getCommissionProperties());
                if (commissionPropertiesContainer == null) continue;
                if (commissionPropertiesContainer.getEntity() instanceof FeeProperties) {
                    FeeProperties feeProperties = (FeeProperties)commissionPropertiesContainer.getEntity();
                    if (commission.getContractType() != ContractType.CLIENT && !feeProperties.isChargeToClientForAllContractTypes()) continue;
                }
                if (FeeProperties.class.equals((Object)commissionPropertiesContainer.getEntityType()) || PaymentFeeProperties.class.equals((Object)commissionPropertiesContainer.getEntityType())) {
                    commissionData = new CommissionData(commission, product);
                    FinanceDocumentsHelper.updateMap(fees, (String)AirProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)commissionPropertiesContainer, commissionData, noVat), (Object)commissionData);
                    continue;
                }
                if (!DiscountProperties.class.equals((Object)commissionPropertiesContainer.getEntityType())) continue;
                commissionData = new CommissionData(commission, product);
                FinanceDocumentsHelper.updateMap(discounts, (String)AirProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)commissionPropertiesContainer, commissionData, noVat), (Object)commissionData);
            }
            Product previousProduct = product.getPreviousProduct();
            if (previousProduct == null || previousProduct.getStatus() != ProductStatus.EXCHANGE) continue;
            for (Commission commission : com.gridnine.xtrip.common.model.helpers.AirProductHelper.getUnmodifiableCommissions((Product)product, null)) {
                EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commission.getCommissionProperties());
                if (commissionPropertiesContainer == null || !FeeProperties.class.equals((Object)commissionPropertiesContainer.getEntityType()) || ((FeeProperties)commissionPropertiesContainer.getEntity()).getOperation() != Operation.EXCHANGE) continue;
                CommissionData commissionData = new CommissionData(commission, previousProduct);
                FinanceDocumentsHelper.updateMap(fees, (String)AirProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)commissionPropertiesContainer, commissionData, noVat), (Object)commissionData);
            }
        }
        AirProductFinanceHelper.updateProductItems(billingItems, tickets.values(), noVat);
        AirProductFinanceHelper.updateProductItems(billingItems, mcos.values(), noVat);
        AirProductFinanceHelper.updateCommissionItems(billingItems, fees.values(), false, noVat);
        AirProductFinanceHelper.updateCommissionItems(billingItems, discounts.values(), true, noVat);
        return billingItems;
    }

    private static String getDescription(Product product) throws Exception {
        String result = product.getProductCategory().toString() + "_" + product.getStatus() + "_" + product.getSystemNumber();
        VatAmount money = AirProductFinanceHelper.calculateProductPrice(product);
        return FinanceDocumentsHelper.getDescription((String)result, (VatAmount)money);
    }

    private static VatRateData calculateProductVatRate(Product product) throws Exception {
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            boolean retail = ProfileHelper.isRetailProfile((EntityContainer)clientContainer);
            boolean domestic = ProfileHelper.isDomesticOrganization((Organization)((Organization)clientContainer.getEntity()), (Date)product.getIssueDate());
            TransportationType transportationType = AirProductHelper.getTransportationType(product);
            if (transportationType == TransportationType.DOMESTIC) {
                if (retail || domestic) {
                    return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_2);
                }
                return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_1);
            }
            if (transportationType == TransportationType.COMBINED) {
                if (retail || domestic) {
                    return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_2);
                }
                return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_1);
            }
            if (transportationType == TransportationType.INTERNATIONAL) {
                if (retail || domestic) {
                    return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_2);
                }
                return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_1);
            }
        }
        return null;
    }

    private static VatRateData calculateCommissionVatRate(CommissionData commissionData) throws Exception {
        Product product = commissionData.product;
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            boolean retail = ProfileHelper.isRetailProfile((EntityContainer)clientContainer);
            boolean domestic = ProfileHelper.isDomesticOrganization((Organization)((Organization)clientContainer.getEntity()), (Date)product.getIssueDate());
            TransportationType transportationType = AirProductHelper.getTransportationType(product);
            if (transportationType == TransportationType.DOMESTIC) {
                if (retail || domestic) {
                    return new VatRateData(BigDecimal.valueOf(20L), null);
                }
                return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_1);
            }
            if (transportationType == TransportationType.COMBINED) {
                if (retail || domestic) {
                    return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_2);
                }
                return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_1);
            }
            if (transportationType == TransportationType.INTERNATIONAL) {
                if (retail) {
                    return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_3);
                }
                if (domestic) {
                    return new VatRateData(BigDecimal.valueOf(20L), null);
                }
                return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_1);
            }
        }
        return null;
    }

    private static VatRateData calculatePenaltyVatRate(Product product) throws Exception {
        return null;
    }

    private static VatAmount calculateProductPrice(Product product) throws Exception {
        BigDecimal value = BigDecimal.ZERO;
        if (product.getStatus() == ProductStatus.BOOKING) {
            return BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        }
        if (product.getStatus() != ProductStatus.VOID_BOOKING) {
            for (ProductFop fop : com.gridnine.xtrip.common.model.helpers.AirProductHelper.getClientContractRelation((Product)product).getFops()) {
                if (fop.getType() == PaymentType.TICKET || fop.getType() == PaymentType.PTA || !com.gridnine.xtrip.common.model.helpers.AirProductHelper.isServiceFop((ProductFop)fop) || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                value = value.add(fop.getAmount().getValue());
            }
            VatAmount productPrice = new VatAmount();
            productPrice.setTotalVat(value, 0.0);
            return productPrice;
        }
        VatAmount productPrice = new VatAmount();
        productPrice.setTotalVat(BigDecimal.ZERO, 0.0);
        return productPrice;
    }

    private static String getCommonPart(Product prod) {
        switch (prod.getProductCategory()) {
            case AIR: {
                if (prod.getStatus() == ProductStatus.SELL || prod.getStatus() == ProductStatus.BOOKING) {
                    return String.format("\u0410\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442 %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s($group_info)%s", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442) " : "", com.gridnine.xtrip.common.model.helpers.AirProductHelper.getRouteLine((Product)prod, null, (boolean)false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getDepartureDate(prod), AirProductFinanceHelper.getExhangeInfo(prod));
                }
                if (prod.getStatus() == ProductStatus.REFUND) {
                    return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u0430 %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s($group_info)", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442) " : "", com.gridnine.xtrip.common.model.helpers.AirProductHelper.getRouteLine((Product)prod, null, (boolean)false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getDepartureDate(prod));
                }
                if (prod.getStatus() == ProductStatus.VOID) {
                    return String.format("\u0410\u043d\u043d\u0443\u043b\u044f\u0446\u0438\u044f \u0430\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u0430 %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s($group_info)", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442) " : "", com.gridnine.xtrip.common.model.helpers.AirProductHelper.getRouteLine((Product)prod, null, (boolean)false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getDepartureDate(prod));
                }
                return "";
            }
            case MCO: {
                String result = null;
                switch (prod.getMcoCategory()) {
                    case EXCESS_LUGGAGE: {
                        result = "\u041c\u0421\u041e \u043d\u0430 \u0434\u043e\u043f\u043b\u0430\u0442\u0443 \u0437\u0430 \u0431\u0430\u0433\u0430\u0436";
                        break;
                    }
                    case GROUP_PENALTY: {
                        result = "\u041c\u0421\u041e \u043d\u0430 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u0431\u0438\u043b\u0435\u0442\u044b";
                        break;
                    }
                    case GROUP_PREPAYMENT: {
                        result = "\u041c\u0421\u041e \u043d\u0430 \u043f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0443 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u0431\u0438\u043b\u0435\u0442\u044b";
                        break;
                    }
                    case PENALTY: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s", AirProductFinanceHelper.getRelatedTicketNumber(prod));
                        break;
                    }
                    case PTA: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 PTA %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s,($group_info)", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u041c\u0421\u041e) " : "", com.gridnine.xtrip.common.model.helpers.AirProductHelper.getRouteLine((Product)prod, null, (boolean)false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getDepartureDate(prod));
                        break;
                    }
                    case RETURN_TICKET: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s", AirProductFinanceHelper.getRelatedTicketNumber(prod));
                        break;
                    }
                    case SEAT_RESERVATION: {
                        result = "\u041c\u0421\u041e \u0437\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435";
                        break;
                    }
                    default: {
                        return "";
                    }
                }
                if (prod.getStatus() == ProductStatus.SELL || prod.getStatus() == ProductStatus.BOOKING) {
                    return result;
                }
                if (prod.getStatus() == ProductStatus.REFUND) {
                    return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 " + result;
                }
                if (prod.getStatus() == ProductStatus.VOID) {
                    return "\u0410\u043d\u043d\u0443\u043b\u044f\u0446\u0438\u044f " + result;
                }
                return "";
            }
        }
        return "";
    }

    private static String getRelatedTicketNumber(Product prod) {
        Iterator iterator = prod.getRelatedProducts().iterator();
        if (iterator.hasNext()) {
            Product bp = (Product)iterator.next();
            return AirProductFinanceHelper.getTicketNumber(bp);
        }
        return "?";
    }

    private static String getExhangeInfo(Product prod) {
        if (prod.getStatus() != ProductStatus.SELL || prod.getPreviousProduct() == null || prod.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) {
            return "";
        }
        Product firstSell = prod.getPreviousProduct().getPreviousProduct();
        Payment exchangePayment = null;
        block0: for (Payment payment : firstSell.getReservation().getBookingFile().getPayments()) {
            for (BillingItem bi : payment.getBillingItems()) {
                for (String uid : bi.getProductUids()) {
                    if (!firstSell.getUid().equals(uid)) continue;
                    exchangePayment = payment;
                    break block0;
                }
            }
        }
        return String.format("(\u0421 \u0443\u0447\u0435\u0442\u043e\u043c \u043f\u0440\u0438\u043d\u044f\u0442\u043e\u0433\u043e \u0432 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s%s)", AirProductFinanceHelper.getTicketNumber(firstSell), exchangePayment != null ? String.format(", \u0441\u0447\u0435\u0442 \u2116 %s", TextUtil.buildFullNumber(exchangePayment)) : "");
    }

    private static String getTicketNumber(Product prod) {
        return String.format("%s-%s", prod.getCarrierNumber(), prod.getSystemNumber());
    }

    private static String getDepartureDate(Product prod) {
        if (prod.getSegmentTariffs().isEmpty()) {
            return "?";
        }
        SegmentTariff st = (SegmentTariff)prod.getSegmentTariffs().get(0);
        if (st.getSegments().isEmpty()) {
            return "?";
        }
        Date startDate = ((Segment)st.getSegments().get(0)).getStartDate();
        if (startDate == null) {
            return "?";
        }
        return ((LocaleManager)Environment.getPublished(LocaleManager.class)).getCurrentLocaleData().getDateFormat().format(startDate);
    }

    private static String getCarierCode(Product prod) {
        Airline airline = (Airline)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(prod.getCarrier());
        if (airline == null) {
            return "?";
        }
        if (airline.getCodeVariants().isEmpty()) {
            return airline.getCode();
        }
        String res = (String)airline.getCodeVariants().get(CodeSystem.IATA.name());
        if (!TextUtil.isBlank((String)res)) {
            return res;
        }
        return (String)airline.getCodeVariants().values().iterator().next();
    }

    private static String getClassOfService(Product prod) {
        String firstLetter = null;
        block0: for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (TextUtil.isBlank((String)seg.getClassOfSvcCode())) continue;
                firstLetter = seg.getClassOfSvcCode().substring(0, 1).toLowerCase();
                break block0;
            }
        }
        if ("c".equals(firstLetter) || "d".equals(firstLetter) || "j".equals(firstLetter) || "\u0431".equals(firstLetter) || "\u0434".equals(firstLetter) || "\u044b".equals(firstLetter)) {
            return "\u0411\u0438\u0437\u043d\u0435\u0441";
        }
        if ("f".equals(firstLetter) || "p".equals(firstLetter) || "\u0430".equals(firstLetter) || "\u043f".equals(firstLetter)) {
            return "\u041f\u0435\u0440\u0432\u044b\u0439";
        }
        return "\u042d\u043a\u043e\u043d\u043e\u043c";
    }

    private static void updateBillingItemServiceData(List<Product> products, BillingItem billingItem) {
        for (Product product : products) {
            BaseCommissionProperties baseCommissionProperties;
            EntityContainer commissionPropertiesContainer;
            BillingItemServiceData serviceData = new BillingItemServiceData();
            serviceData.setProductType(ProductType.AIR_TICKET);
            String nameString = null;
            nameString = billingItem.getServiceType() == ServiceType.TICKET ? "\u0411\u0438\u043b\u0435\u0442" : (billingItem.getServiceType() == ServiceType.FEE ? ((commissionPropertiesContainer = EntityStorage.get().resolve(billingItem.getCommissionType())) != null ? ((baseCommissionProperties = (BaseCommissionProperties)commissionPropertiesContainer.getEntity()) instanceof FeeProperties ? ((FeeProperties)baseCommissionProperties).getFinanceName() : (baseCommissionProperties instanceof PaymentFeeProperties ? ((PaymentFeeProperties)baseCommissionProperties).getFinanceName() : "?")) : "?") : "?");
            String carrierString = product.getCarrier() != null ? product.getCarrier().toString() : "?";
            String systemNumberString = product.getSystemNumber() != null ? product.getSystemNumber() : "?";
            serviceData.setNameProtocol(String.format("%s - %s", carrierString, systemNumberString));
            String travellerString = product.getTraveller() != null && !TextUtil.isBlank((String)product.getTraveller().getName()) ? product.getTraveller().getName().trim() : "?";
            serviceData.setNameInvoice(String.format("%s %s - %s - %s", nameString, carrierString, travellerString, systemNumberString));
            serviceData.getTravellers().add(travellerString);
            for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
                for (Segment segment : segmentTariff.getSegments()) {
                    DictionaryReference departureLocation = segment.getDepartureLocation();
                    DictionaryReference arriveLocation = segment.getArriveLocation();
                    GeoLocation departureCityLocation = DictHelper.findLocation((DictionaryReference)departureLocation, (LocationType)LocationType.CITY);
                    GeoLocation arriveCityLocation = DictHelper.findLocation((DictionaryReference)arriveLocation, (LocationType)LocationType.CITY);
                    GeoLocation departureAirportLocation = DictHelper.findLocation((DictionaryReference)departureLocation, (LocationType)LocationType.AIRPORT);
                    GeoLocation arriveAirportLocation = DictHelper.findLocation((DictionaryReference)arriveLocation, (LocationType)LocationType.AIRPORT);
                    String departureLocationString = null;
                    String arriveLocationString = null;
                    if (departureCityLocation != null || departureAirportLocation != null) {
                        String departureCityLocationString = departureCityLocation != null ? departureCityLocation.toString(Locale.ENGLISH) : null;
                        String departureAirportLocationString = departureAirportLocation != null ? DictHelper.getCodeVariant((BaseDictionary)departureAirportLocation, (CodeSystem)CodeSystem.IATA) : null;
                        departureLocationString = TextUtil.join((String)" ", Arrays.asList(departureCityLocationString, departureAirportLocationString), (boolean)false);
                    } else {
                        departureLocationString = "?";
                    }
                    if (arriveCityLocation != null || arriveAirportLocation != null) {
                        String arriveCityLocationString = arriveCityLocation != null ? arriveCityLocation.toString(Locale.ENGLISH) : null;
                        String arriveAirportLocationString = arriveAirportLocation != null ? DictHelper.getCodeVariant((BaseDictionary)arriveAirportLocation, (CodeSystem)CodeSystem.IATA) : null;
                        arriveLocationString = TextUtil.join((String)" ", Arrays.asList(arriveCityLocationString, arriveAirportLocationString), (boolean)false);
                    } else {
                        arriveLocationString = "?";
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
                    String departureDateString = segment.getStartDate() != null ? dateFormat.format(segment.getStartDate()) : "?";
                    serviceData.getRoutes().add(String.format("%s-%s (%s)", departureLocationString, arriveLocationString, departureDateString));
                }
            }
            billingItem.getServiceData().add(serviceData);
        }
    }

    private static void updateProductItems(List<BillingItem> billingItems, Collection<List<Product>> values, boolean noVat) throws Exception {
        CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)"EUR", (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null);
        for (List<Product> products : values) {
            if (products.isEmpty()) continue;
            BillingItem billingItem = new BillingItem();
            billingItem.setServiceType(ServiceType.TICKET);
            billingItem.setName(AirProductFinanceHelper.getCommonPart(products.get(0)).replace("$group_info", AirProductFinanceHelper.getGroupInfo(products)));
            AirProductFinanceHelper.updateBillingItemServiceData(products, billingItem);
            BigDecimal totalBaseAmount = BigDecimal.ZERO;
            BigDecimal totalBaseNetAmount = BigDecimal.ZERO;
            BigDecimal totalBaseDiscount = BigDecimal.ZERO;
            BigDecimal totalEquivalentAmount = BigDecimal.ZERO;
            BigDecimal totalEquivalentNetAmount = BigDecimal.ZERO;
            BigDecimal totalEquivalentDiscount = BigDecimal.ZERO;
            BigDecimal vatRate = null;
            String zeroRateReason = null;
            for (Product product : products) {
                BigDecimal equivalentDiscount;
                BigDecimal equivalentAmount = AirProductFinanceHelper.calculateProductPrice(product).getTotal();
                if (equivalentAmount != null) {
                    VatRateData vatRateData = AirProductFinanceHelper.calculateProductVatRate(product);
                    if (currencyRate != null) {
                        BigDecimal euroAmount = equivalentAmount.divide(BigDecimal.valueOf(currencyRate.getRate()), 2, 4);
                        VatAmount baseAmount = new VatAmount();
                        baseAmount.setTotalVat(euroAmount, vatRateData != null ? vatRateData.rate.doubleValue() : 0.0);
                        totalBaseAmount = totalBaseAmount.add(baseAmount.getTotal());
                        totalBaseNetAmount = totalBaseNetAmount.add(baseAmount.getValue());
                    }
                    VatAmount amount = new VatAmount();
                    amount.setTotalVat(equivalentAmount, vatRateData != null ? vatRateData.rate.doubleValue() : 0.0);
                    if (vatRate == null) {
                        BigDecimal bigDecimal = vatRate = vatRateData != null ? vatRateData.rate : null;
                    }
                    if (zeroRateReason == null) {
                        zeroRateReason = vatRateData != null ? vatRateData.zeroRateReason : null;
                    }
                    totalEquivalentAmount = totalEquivalentAmount.add(amount.getTotal());
                    totalEquivalentNetAmount = totalEquivalentNetAmount.add(amount.getVatAmount());
                }
                if ((equivalentDiscount = com.gridnine.xtrip.common.model.helpers.AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)com.gridnine.xtrip.common.model.helpers.AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.discountPropertyTypes, null, null))) != null) {
                    totalEquivalentDiscount = equivalentDiscount;
                    if (currencyRate != null) {
                        totalBaseDiscount = equivalentDiscount.divide(BigDecimal.valueOf(currencyRate.getRate()), 2, 4);
                    }
                }
                billingItem.getProductUids().add(product.getUid());
            }
            ProductStatus status = products.get(0).getStatus();
            if (status == ProductStatus.REFUND) {
                totalBaseAmount = totalBaseAmount.negate();
                totalBaseNetAmount = totalBaseNetAmount.negate();
                totalBaseDiscount = totalBaseDiscount.negate();
                totalEquivalentAmount = totalEquivalentAmount.negate();
                totalEquivalentNetAmount = totalEquivalentNetAmount.negate();
                totalEquivalentDiscount = totalEquivalentDiscount.negate();
            }
            Money baseAmount = new Money();
            baseAmount.setValue(totalBaseAmount);
            baseAmount.setCurrency("EUR");
            billingItem.setBaseAmount(baseAmount);
            Money baseNetAmount = new Money();
            baseNetAmount.setValue(totalBaseNetAmount);
            baseNetAmount.setCurrency("EUR");
            billingItem.setBaseNetAmount(baseNetAmount);
            VatAmount equivalentAmount = new VatAmount();
            equivalentAmount.setTotalVatAmount(totalEquivalentAmount, totalEquivalentNetAmount);
            billingItem.setAmount(equivalentAmount);
            billingItem.setVatRate(vatRate);
            billingItem.setZeroVatRateReason(zeroRateReason);
            Money discount = new Money();
            discount.setValue(totalBaseDiscount);
            discount.setCurrency("EUR");
            billingItem.setBaseDiscount(discount);
            billingItem.setDiscount(totalEquivalentDiscount);
            billingItems.add(billingItem);
        }
    }

    private static String getGroupInfo(List<Product> lst) {
        StringBuilder sb = new StringBuilder();
        for (Product product : lst) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(product.getTraveller() != null ? product.getTraveller().getName() : "?");
            if (product.getStatus() == ProductStatus.BOOKING) continue;
            sb.append(": \u2116").append(AirProductFinanceHelper.getTicketNumber(product));
        }
        return sb.toString();
    }

    private static String getDescription(EntityContainer<? extends BaseCommissionProperties> ctr, CommissionData data, boolean noVat) {
        VatAmount amount = new VatAmount();
        BigDecimal equivalentAmount = data.commission.getEquivalentAmount();
        amount.setTotalVat(equivalentAmount != null ? equivalentAmount : BigDecimal.ZERO, noVat ? 0.0 : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.DEFAULT_VAT, (double)0.0));
        return FinanceDocumentsHelper.getDescription((String)(data.product.getSystemNumber() + "_" + data.product.getStatus() + "_" + ctr.getUid()), (VatAmount)amount);
    }

    private static void updateCommissionItems(List<BillingItem> billingItems, Collection<List<CommissionData>> values, boolean discount, boolean noVat) throws Exception {
        CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)"EUR", (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null);
        for (List<CommissionData> commissions : values) {
            BigDecimal equivalentAmount;
            if (commissions.isEmpty()) continue;
            BillingItem billingItem = new BillingItem();
            for (CommissionData commission : commissions) {
                billingItem.getProductUids().add(commission.product.getUid());
            }
            billingItem.setServiceType(discount ? ServiceType.DISCOUNT : ServiceType.FEE);
            billingItem.setCommissionType(commissions.get((int)0).commission.getCommissionProperties());
            EntityContainer commissionPropertiesContainer = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(commissions.get((int)0).commission.getCommissionProperties());
            BigDecimal coefficient = BigDecimal.ONE;
            if (commissionPropertiesContainer.getEntityType().getName().equals(FeeProperties.class.getName())) {
                FeeProperties feeProperties = (FeeProperties)commissionPropertiesContainer.getEntity();
                billingItem.setName(feeProperties.getFinanceName());
                if (commissions.get((int)0).product.getStatus() == ProductStatus.EXCHANGE && feeProperties.getOperation() == Operation.EXCHANGE) {
                    coefficient = coefficient.negate();
                }
            } else if (commissionPropertiesContainer.getEntityType().equals(PaymentFeeProperties.class)) {
                PaymentFeeProperties paymentFeeProperties = (PaymentFeeProperties)commissionPropertiesContainer.getEntity();
                billingItem.setName(paymentFeeProperties.getFinanceName());
            } else {
                billingItem.setName(((DiscountProperties)commissionPropertiesContainer.getEntity()).getFinanceName());
            }
            if (commissions.get((int)0).product.getStatus() == ProductStatus.REFUND) {
                coefficient = coefficient.negate();
            }
            BigDecimal totalBaseAmount = BigDecimal.ZERO;
            BigDecimal totalBaseNetAmount = BigDecimal.ZERO;
            BigDecimal totalEquivalentAmount = BigDecimal.ZERO;
            BigDecimal totalEquivalentNetAmount = BigDecimal.ZERO;
            BigDecimal rate = null;
            String zeroRateReason = null;
            LinkedList<Product> products = new LinkedList<Product>();
            for (CommissionData commission : commissions) {
                equivalentAmount = commission.commission.getEquivalentAmount();
                VatRateData vatRateData = AirProductFinanceHelper.calculateCommissionVatRate(commission);
                if (currencyRate != null) {
                    BigDecimal euroAmount = equivalentAmount.divide(BigDecimal.valueOf(currencyRate.getRate()), 2, 4);
                    VatAmount baseAmount = new VatAmount();
                    baseAmount.setTotalVat(euroAmount, vatRateData != null ? vatRateData.rate.doubleValue() : 0.0);
                    totalBaseAmount = totalBaseAmount.add(baseAmount.getTotal());
                    totalBaseNetAmount = totalBaseNetAmount.add(baseAmount.getValue());
                }
                VatAmount amount = new VatAmount();
                amount.setTotalVat(equivalentAmount, vatRateData != null ? vatRateData.rate.doubleValue() : 0.0);
                if (rate == null) {
                    BigDecimal bigDecimal = rate = vatRateData != null ? vatRateData.rate : null;
                }
                if (zeroRateReason == null) {
                    zeroRateReason = vatRateData != null ? vatRateData.zeroRateReason : null;
                }
                totalEquivalentAmount = totalEquivalentAmount.add(amount.getTotal());
                totalEquivalentNetAmount = totalEquivalentNetAmount.add(amount.getVatAmount());
                if (commission.product == null || products.contains(commission.product)) continue;
                products.add(commission.product);
            }
            AirProductFinanceHelper.updateBillingItemServiceData(products, billingItem);
            if (!TextUtil.isBlank((String)billingItem.getName())) {
                billingItem.setName(billingItem.getName().replace("${air_tickets_info}", AirProductFinanceHelper.getGroupInfo(products)));
            }
            Money baseAmount = new Money();
            baseAmount.setValue(coefficient.multiply(totalBaseAmount));
            baseAmount.setCurrency("EUR");
            billingItem.setBaseAmount(baseAmount);
            Money baseNetAmount = new Money();
            baseNetAmount.setValue(coefficient.multiply(totalBaseNetAmount));
            baseNetAmount.setCurrency("EUR");
            billingItem.setBaseNetAmount(baseNetAmount);
            equivalentAmount = new VatAmount();
            equivalentAmount.setTotalVatAmount(coefficient.multiply(totalEquivalentAmount), noVat ? BigDecimal.ZERO : coefficient.multiply(totalEquivalentNetAmount));
            billingItem.setAmount((VatAmount)equivalentAmount);
            billingItem.setVatRate(rate);
            billingItem.setZeroVatRateReason(zeroRateReason);
            billingItems.add(billingItem);
        }
    }

    private static final class VatRateData {
        public BigDecimal rate;
        public String zeroRateReason;

        public VatRateData(BigDecimal rate, String zeroRateReason) {
            this.rate = rate;
            this.zeroRateReason = zeroRateReason;
        }
    }

    private static final class CommissionData {
        public Product product;
        public Commission commission;

        public CommissionData(Commission aCommission, Product aProduct) {
            this.commission = aCommission;
            this.product = aProduct;
        }
    }
}

