/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.model.finance.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BillingItemServiceData;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class InsuranceTouristicFinanceHelper {
    private static final String ZERO_VAT_RATE_REASON_1 = "\u0447\u043b.21, \u0430\u043b.(2) \u0417\u0414\u0414\u0421";
    private static final String ZERO_VAT_RATE_REASON_2 = "\u0447\u043b.36, \u0430\u043b.(1) \u0417\u0414\u0414\u0421";
    private static final String GROUP_PLACE_HOLDER = "$group_string";

    public static Collection<BillingItem> getBillingItems(List<InsuranceTouristic> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        HashMap tickets = new HashMap();
        LinkedList<BillingItem> billingItems = new LinkedList<BillingItem>();
        for (InsuranceTouristic product : products) {
            String key = InsuranceTouristicFinanceHelper.getDescription(product);
            FinanceDocumentsHelper.updateMap(tickets, (String)key, (Object)product);
        }
        InsuranceTouristicFinanceHelper.updateProductItems(billingItems, tickets.values(), noVat);
        return billingItems;
    }

    private static String getDescription(InsuranceTouristic product) {
        VatAmount price = InsuranceTouristicFinanceHelper.calculateProductPrice(product);
        return String.format("%s_%s_%s", InsuranceTouristicFinanceHelper.getTitle(product), Double.toString(price.getTotal().doubleValue()), Double.toString(price.getVatAmount().doubleValue()));
    }

    private static String getTitle(InsuranceTouristic product) {
        Traveller traveller = BookingHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)product.getPolicyHolderUid());
        if (product.getStatus() == ProductStatus.REFUND) {
            return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0422\u0443\u0440\u0438\u0441\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0441\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0438 %s (\u0441\u0442\u0440\u0430\u0445\u043e\u0432\u0430\u0442\u0435\u043b\u044c: %s, \u0441\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u0435\u0431\u044b\u0432\u0430\u043d\u0438\u044f: %s)", product.getSystemNumber(), traveller != null ? traveller.getName() : "", product.getCountryName());
        }
        return String.format("\u0422\u0443\u0440\u0438\u0441\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0430 %s (\u0441\u0442\u0440\u0430\u0445\u043e\u0432\u0430\u0442\u0435\u043b\u044c: %s, \u0441\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u0435\u0431\u044b\u0432\u0430\u043d\u0438\u044f: %s)", product.getSystemNumber(), traveller != null ? traveller.getName() : "", product.getCountryName());
    }

    private static String getGroupString(List<InsuranceTouristic> products) {
        StringBuilder stringBuilder = new StringBuilder();
        for (InsuranceTouristic product : products) {
            String systemNumber = product.getSystemNumber();
            for (String travellerUid : product.getTravellersUids()) {
                String travellerName;
                Traveller traveller = BookingHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)travellerUid);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                if (!TextUtil.isBlank((String)(travellerName = traveller.getName()))) {
                    stringBuilder.append(travellerName);
                } else {
                    stringBuilder.append("?");
                }
                if (!TextUtil.isBlank((String)systemNumber)) {
                    stringBuilder.append(String.format(": \u2116%s", systemNumber));
                    continue;
                }
                stringBuilder.append(": ?");
            }
            Traveller traveller = BookingHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)product.getPolicyHolderUid());
            String travellerName = traveller.getName();
            if (!TextUtil.isBlank((String)travellerName)) {
                stringBuilder.append(travellerName);
            } else {
                stringBuilder.append("?");
            }
            if (!TextUtil.isBlank((String)systemNumber)) {
                stringBuilder.append(String.format(": \u2116%s", systemNumber));
                continue;
            }
            stringBuilder.append(": ?");
        }
        return stringBuilder.toString();
    }

    private static VatRateData calculateProductVatRate(InsuranceTouristic product) throws Exception {
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            boolean retail = ProfileHelper.isRetailProfile((EntityContainer)clientContainer);
            boolean domestic = ProfileHelper.isDomesticOrganization((Organization)((Organization)clientContainer.getEntity()), (Date)product.getIssueDate());
            if (retail || domestic) {
                return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_2);
            }
            return new VatRateData(BigDecimal.ZERO, ZERO_VAT_RATE_REASON_1);
        }
        return null;
    }

    private static VatAmount calculateProductPrice(InsuranceTouristic product) {
        BigDecimal value = BigDecimal.ZERO;
        if (product.getStatus() == ProductStatus.BOOKING) {
            return BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        }
        if (product.getStatus() != ProductStatus.VOID && product.getStatus() != ProductStatus.VOID_BOOKING) {
            List clientFops = InsuranceTouristicHelper.getClientFops((InsuranceTouristic)product);
            if (!clientFops.isEmpty()) {
                for (GeneralProductFop fop : clientFops) {
                    if (fop.getType() == PaymentType.PTA || fop.getEquivalentAmount() == null || !GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) continue;
                    value = value.add(fop.getEquivalentAmount());
                }
            } else {
                for (GeneralProductFop fop : InsuranceTouristicHelper.getVendorFops((InsuranceTouristic)product)) {
                    if (fop.getType() == PaymentType.PTA || fop.getEquivalentAmount() == null) continue;
                    value = value.add(fop.getEquivalentAmount());
                }
            }
            VatAmount result = new VatAmount();
            result.setTotalVat(value, 0.0);
            return result;
        }
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    private static void updateProductItems(List<BillingItem> billingItems, Collection<List<InsuranceTouristic>> values, boolean noVat) throws Exception {
        CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)"EUR", (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null);
        for (List<InsuranceTouristic> products : values) {
            if (products.isEmpty()) continue;
            BillingItem billingItem = new BillingItem();
            billingItem.setServiceType(ServiceType.TICKET);
            billingItem.setName(InsuranceTouristicFinanceHelper.getTitle(products.get(0)).replace(GROUP_PLACE_HOLDER, InsuranceTouristicFinanceHelper.getGroupString(products)));
            InsuranceTouristicFinanceHelper.updateBillingItemServiceData(products, billingItem);
            BigDecimal totalBaseAmount = BigDecimal.ZERO;
            BigDecimal totalBaseNetAmount = BigDecimal.ZERO;
            BigDecimal totalBaseDiscount = BigDecimal.ZERO;
            BigDecimal totalEquivalentAmount = BigDecimal.ZERO;
            BigDecimal totalEquivalentNetAmount = BigDecimal.ZERO;
            BigDecimal totalEquivalentDiscount = BigDecimal.ZERO;
            BigDecimal vatRate = null;
            String zeroRateReason = null;
            for (InsuranceTouristic product : products) {
                BigDecimal equivalentDiscount;
                BigDecimal equivalentAmount = InsuranceTouristicFinanceHelper.calculateProductPrice(product).getTotal();
                if (equivalentAmount != null) {
                    VatRateData vatRateData = InsuranceTouristicFinanceHelper.calculateProductVatRate(product);
                    if (currencyRate != null) {
                        BigDecimal euroAmount = equivalentAmount.divide(BigDecimal.valueOf(currencyRate.getRate()), 2, 4);
                        VatAmount baseAmount = new VatAmount();
                        baseAmount.setTotalVat(euroAmount, vatRateData != null ? vatRateData.rate.doubleValue() : 0.0);
                        totalBaseAmount = totalBaseAmount.add(baseAmount.getTotal());
                        totalBaseNetAmount = totalBaseNetAmount.add(baseAmount.getValue());
                    }
                    VatAmount amount = new VatAmount();
                    amount.setTotalVat(equivalentAmount, vatRateData != null ? vatRateData.rate.doubleValue() : 0.0);
                    if (vatRate == null) {
                        BigDecimal bigDecimal = vatRate = vatRateData != null ? vatRateData.rate : null;
                    }
                    if (zeroRateReason == null) {
                        zeroRateReason = vatRateData != null ? vatRateData.zeroRateReason : null;
                    }
                    totalEquivalentAmount = totalEquivalentAmount.add(amount.getTotal());
                    totalEquivalentNetAmount = totalEquivalentNetAmount.add(amount.getVatAmount());
                }
                if ((equivalentDiscount = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.discountPropertyTypes, null, null))) != null) {
                    totalEquivalentDiscount = equivalentDiscount;
                    if (currencyRate != null) {
                        totalBaseDiscount = equivalentDiscount.divide(BigDecimal.valueOf(currencyRate.getRate()), 2, 4);
                    }
                }
                billingItem.getProductUids().add(product.getUid());
            }
            ProductStatus status = products.get(0).getStatus();
            if (status == ProductStatus.REFUND) {
                totalBaseAmount = totalBaseAmount.negate();
                totalBaseNetAmount = totalBaseNetAmount.negate();
                totalBaseDiscount = totalBaseDiscount.negate();
                totalEquivalentAmount = totalEquivalentAmount.negate();
                totalEquivalentNetAmount = totalEquivalentNetAmount.negate();
                totalEquivalentDiscount = totalEquivalentDiscount.negate();
            }
            Money baseAmount = new Money();
            baseAmount.setValue(totalBaseAmount);
            baseAmount.setCurrency("EUR");
            billingItem.setBaseAmount(baseAmount);
            Money baseNetAmount = new Money();
            baseNetAmount.setValue(totalBaseNetAmount);
            baseNetAmount.setCurrency("EUR");
            billingItem.setBaseNetAmount(baseNetAmount);
            VatAmount equivalentAmount = new VatAmount();
            equivalentAmount.setTotalVatAmount(totalEquivalentAmount, totalEquivalentNetAmount);
            billingItem.setAmount(equivalentAmount);
            billingItem.setVatRate(vatRate);
            billingItem.setZeroVatRateReason(zeroRateReason);
            Money discount = new Money();
            discount.setValue(totalBaseDiscount);
            discount.setCurrency("EUR");
            billingItem.setBaseDiscount(discount);
            billingItem.setDiscount(totalEquivalentDiscount);
            billingItems.add(billingItem);
        }
    }

    private static void updateBillingItemServiceData(List<InsuranceTouristic> products, BillingItem billingItem) {
        for (InsuranceTouristic product : products) {
            BillingItemServiceData serviceData = new BillingItemServiceData();
            serviceData.setProductType(ProductType.INSURANCE_TOURISTIC);
            String carrierString = product.getBlankOwner() != null ? product.getBlankOwner().toString() : "?";
            String systemNumberString = product.getSystemNumber() != null ? product.getSystemNumber() : "?";
            serviceData.setNameProtocol(String.format("%s - %s", carrierString, systemNumberString));
            for (String travellerUid : product.getTravellersUids()) {
                Traveller traveller = BookingHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)travellerUid);
                if (traveller == null) continue;
                serviceData.getTravellers().add(!TextUtil.isBlank((String)traveller.getName()) ? traveller.getName().trim() : "?");
            }
            String locationString = product.getCountryName() != null ? product.getCountryName() : "?";
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            String dateString = product.getStartDate() != null ? dateFormat.format(product.getStartDate()) : "?";
            serviceData.getRoutes().add(String.format("%s (%s)", locationString, dateString));
            billingItem.getServiceData().add(serviceData);
        }
    }

    private static final class VatRateData {
        public BigDecimal rate;
        public String zeroRateReason;

        public VatRateData(BigDecimal rate, String zeroRateReason) {
            this.rate = rate;
            this.zeroRateReason = zeroRateReason;
        }
    }
}

