/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.model.finance.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BillingItemServiceData;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class RailwayProductFinanceHelper {
    private static final String GROUP_PLACE_HOLDER = "$group_string";

    public static Collection<BillingItem> getBillingItems(List<RailwayProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        HashMap tickets = new HashMap();
        HashMap fees = new HashMap();
        HashMap discounts = new HashMap();
        LinkedList<BillingItem> billingItems = new LinkedList<BillingItem>();
        for (RailwayProduct product : products) {
            String description = RailwayProductFinanceHelper.getDescription(product);
            FinanceDocumentsHelper.updateMap(tickets, (String)description, (Object)product);
            LinkedList commissions = new LinkedList();
            commissions.addAll(GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, null), null, null, (Set)GeneralProductHelper.standardCommissionCategories));
            for (GeneralProductCommission commission : commissions) {
                CommissionData cData;
                EntityContainer commissionContainer = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(commission.getCommissionProperties());
                if (commissionContainer == null) continue;
                if (FeeProperties.class.equals((Object)commissionContainer.getEntityType()) || PaymentFeeProperties.class.equals((Object)commissionContainer.getEntityType())) {
                    cData = new CommissionData(commission, product);
                    FinanceDocumentsHelper.updateMap(fees, (String)RailwayProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)commissionContainer, cData, noVat), (Object)cData);
                    continue;
                }
                if (!DiscountProperties.class.getName().equals(commissionContainer.getEntityType().getName())) continue;
                cData = new CommissionData(commission, product);
                FinanceDocumentsHelper.updateMap(discounts, (String)RailwayProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)commissionContainer, cData, noVat), (Object)cData);
            }
        }
        RailwayProductFinanceHelper.updateProductItems(billingItems, tickets.values(), noVat);
        RailwayProductFinanceHelper.updateCommissionItems(billingItems, fees.values(), false, noVat);
        RailwayProductFinanceHelper.updateCommissionItems(billingItems, discounts.values(), true, noVat);
        return billingItems;
    }

    private static String getDescription(RailwayProduct product) {
        String title = RailwayProductFinanceHelper.getTitle(product);
        VatAmount money = RailwayProductFinanceHelper.calculateProductPrice(product);
        return RailwayProductFinanceHelper.getDescription(title, money);
    }

    private static String getDescription(EntityContainer<? extends BaseCommissionProperties> container, CommissionData data, boolean noVat) {
        VatAmount amount = new VatAmount();
        BigDecimal equivalentAmount = data.commission.getEquivalentAmount();
        amount.setTotalVat(equivalentAmount != null ? equivalentAmount : BigDecimal.ZERO, noVat ? 0.0 : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.DEFAULT_VAT, (double)0.0));
        return RailwayProductFinanceHelper.getDescription(data.product.getSystemNumber() + "_" + data.product.getStatus() + "_" + container.getUid(), amount);
    }

    private static String getDescription(String title, VatAmount money) {
        DecimalFormat priceFormat = ((LocaleManager)Environment.getPublished(LocaleManager.class)).getCurrentLocaleData().getPriceFormat();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(title);
        stringBuilder.append("_");
        stringBuilder.append(money.getTotal() != null ? priceFormat.format(money.getTotal().doubleValue()) : "?");
        stringBuilder.append("_");
        stringBuilder.append(money.getVatAmount() != null ? priceFormat.format(money.getVatAmount().doubleValue()) : "?");
        return stringBuilder.toString();
    }

    private static String getTitle(RailwayProduct product) {
        StringBuilder stringBuilder = new StringBuilder();
        if (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.REFUND) {
            String routeString;
            if (product.getStatus() == ProductStatus.SELL) {
                stringBuilder.append("\u0416/\u0414 \u0431\u0438\u043b\u0435\u0442");
            } else if (product.getStatus() == ProductStatus.REFUND) {
                stringBuilder.append("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0416/\u0414 \u0431\u0438\u043b\u0435\u0442\u0430");
            }
            if (product.isEticket()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append("(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442)");
            }
            if (TextUtil.isBlank((String)(routeString = RailwayProductHelper.getRouteString((RailwayProduct)product)))) {
                routeString = "?";
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s", routeString));
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            Date departureDate = RailwayProductHelper.getFirstDepartureDate((RailwayProduct)product);
            Date arriveDate = RailwayProductHelper.getLastArrivalDate((RailwayProduct)product);
            String departureDateString = departureDate != null ? LocaleManager.get().getCurrentLocaleData().getDateFormat().format(departureDate) : "?";
            String arriveDateString = arriveDate != null ? LocaleManager.get().getCurrentLocaleData().getDateFormat().format(arriveDate) : "?";
            stringBuilder.append(departureDateString);
            stringBuilder.append(" - ");
            stringBuilder.append(arriveDateString);
            stringBuilder.append(" ");
            stringBuilder.append(String.format("(%s)", GROUP_PLACE_HOLDER));
        }
        return stringBuilder.toString();
    }

    private static String getGroupString(List<RailwayProduct> products) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RailwayProduct product : products) {
            String systemNumber = product.getSystemNumber();
            for (Traveller traveller : product.getPassengers()) {
                String travellerName;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                if (!TextUtil.isBlank((String)(travellerName = traveller.getName()))) {
                    stringBuilder.append(travellerName);
                } else {
                    stringBuilder.append("?");
                }
                if (!TextUtil.isBlank((String)systemNumber)) {
                    stringBuilder.append(String.format(": \u2116%s", systemNumber));
                    continue;
                }
                stringBuilder.append(": ?");
            }
        }
        return stringBuilder.toString();
    }

    private static VatAmount calculateProductPrice(RailwayProduct product) {
        BigDecimal value = BigDecimal.ZERO;
        if (product.getStatus() == ProductStatus.BOOKING) {
            return BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        }
        if (product.getStatus() != ProductStatus.VOID && product.getStatus() != ProductStatus.VOID_BOOKING) {
            List clientFops = RailwayProductHelper.getClientFops((RailwayProduct)product);
            if (!clientFops.isEmpty()) {
                for (RailwayProductFop fop : clientFops) {
                    if (fop.getType() == PaymentType.PTA || fop.getAmount() == null || fop.getAmount().getValue() == null || !RailwayProductHelper.isServiceFop((RailwayProductFop)fop)) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            } else {
                for (RailwayProductFop fop : RailwayProductHelper.getVendorFops((RailwayProduct)product)) {
                    if (fop.getType() == PaymentType.PTA || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            }
            VatAmount result = new VatAmount();
            if (product.getTotalEquivalentVAT() == null) {
                boolean hasVat = RailwayProductFinanceHelper.isHasVat(product);
                result.setTotalVat(value, hasVat ? DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.DEFAULT_VAT, (double)0.0) : 0.0);
            } else {
                result.setTotalVatAmount(value, product.getTotalEquivalentVAT());
            }
            return result;
        }
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    public static boolean isHasVat(RailwayProduct product) {
        if (product == null) {
            return false;
        }
        RailwayProduct prod = product;
        if (product.getStatus() == ProductStatus.REFUND && (prod = product.getPreviousProduct()) == null) {
            prod = product;
        }
        return RailwayProductHelper.getTransportationType((RailwayProduct)prod) == TransportationType.DOMESTIC;
    }

    private static void updateProductItems(List<BillingItem> billingItems, Collection<List<RailwayProduct>> lists, boolean noVat) {
        CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)"EUR", (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null);
        for (List<RailwayProduct> products : lists) {
            if (products.isEmpty()) continue;
            BillingItem billingItem = new BillingItem();
            RailwayProductFinanceHelper.updateBillingItemServiceData(products, billingItem);
            for (RailwayProduct product : products) {
                billingItem.getProductUids().add(product.getUid());
            }
            billingItem.setServiceType(ServiceType.TICKET);
            billingItem.setName(RailwayProductFinanceHelper.getTitle(products.get(0)).replace(GROUP_PLACE_HOLDER, RailwayProductFinanceHelper.getGroupString(products)));
            BigDecimal totalBaseAmount = BigDecimal.ZERO;
            BigDecimal totalBaseNetAmount = BigDecimal.ZERO;
            BigDecimal totalEquivalentAmount = BigDecimal.ZERO;
            BigDecimal totalEquivalentNetAmount = BigDecimal.ZERO;
            for (RailwayProduct product : products) {
                VatAmount price = RailwayProductFinanceHelper.calculateProductPrice(product);
                totalEquivalentAmount = totalEquivalentAmount.add(price.getTotal());
                totalEquivalentNetAmount = totalEquivalentNetAmount.add(price.getValue());
            }
            Money baseAmount = new Money();
            if (totalEquivalentAmount != null && currencyRate != null) {
                baseAmount.setValue(totalEquivalentAmount.divide(BigDecimal.valueOf(currencyRate.getRate()), 2, 4));
                baseAmount.setCurrency("EUR");
            }
            billingItem.setBaseAmount(baseAmount);
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(totalEquivalentAmount, totalEquivalentNetAmount);
            billingItem.setAmount(amount);
            billingItems.add(billingItem);
        }
    }

    private static void updateCommissionItems(List<BillingItem> billingItems, Collection<List<CommissionData>> lists, boolean discount, boolean noVat) throws Exception {
        CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)"EUR", (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null);
        for (List<CommissionData> commissions : lists) {
            if (commissions.isEmpty()) continue;
            BillingItem billingItem = new BillingItem();
            for (CommissionData commissionData : commissions) {
                billingItem.getProductUids().add(commissionData.product.getUid());
            }
            billingItem.setServiceType(discount ? ServiceType.DISCOUNT : ServiceType.FEE);
            billingItem.setCommissionType(commissions.get((int)0).commission.getCommissionProperties());
            EntityContainer container = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(commissions.get((int)0).commission.getCommissionProperties());
            BigDecimal coefficient = BigDecimal.ONE;
            if (container.getEntityType().getName().equals(FeeProperties.class.getName())) {
                FeeProperties feeProperties = (FeeProperties)container.getEntity();
                billingItem.setName(feeProperties.getFinanceName());
            } else if (container.getEntityType().equals(PaymentFeeProperties.class)) {
                PaymentFeeProperties prop = (PaymentFeeProperties)container.getEntity();
                billingItem.setName(prop.getFinanceName());
            } else {
                DiscountProperties discountProperties = (DiscountProperties)container.getEntity();
                billingItem.setName(discountProperties.getFinanceName());
            }
            if (commissions.get((int)0).product.getStatus() == ProductStatus.REFUND) {
                coefficient = coefficient.negate();
            }
            BigDecimal total = BigDecimal.ZERO;
            LinkedList<RailwayProduct> products = new LinkedList<RailwayProduct>();
            for (CommissionData commissionData : commissions) {
                BigDecimal equivalentAmount = commissionData.commission.getEquivalentAmount();
                if (equivalentAmount != null) {
                    BigDecimal bigDecimal = total = discount ? total.subtract(equivalentAmount) : total.add(equivalentAmount);
                }
                if (commissionData.product == null || products.contains(commissionData.product)) continue;
                products.add(commissionData.product);
            }
            RailwayProductFinanceHelper.updateBillingItemServiceData(products, billingItem);
            if (!TextUtil.isBlank((String)billingItem.getName())) {
                billingItem.setName(billingItem.getName().replace("${air_tickets_info}", RailwayProductFinanceHelper.getGroupString(products)));
            }
            Money baseAmount = new Money();
            if (total != null && currencyRate != null) {
                baseAmount.setValue(coefficient.multiply(total).divide(BigDecimal.valueOf(currencyRate.getRate()), 2, 4));
                baseAmount.setCurrency("EUR");
            }
            billingItem.setBaseAmount(baseAmount);
            VatAmount amount = new VatAmount();
            amount.setTotalVat(coefficient.multiply(total), noVat ? 0.0 : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.DEFAULT_VAT, (double)0.0));
            billingItem.setAmount(amount);
            billingItems.add(billingItem);
        }
    }

    private static void updateBillingItemServiceData(List<RailwayProduct> products, BillingItem billingItem) {
        for (RailwayProduct product : products) {
            BillingItemServiceData serviceData = new BillingItemServiceData();
            serviceData.setProductType(ProductType.RAILWAY_PRODUCT);
            String carrierString = product.getBlankOwnerRef() != null ? product.getBlankOwnerRef().toString() : "?";
            String systemNumberString = product.getSystemNumber() != null ? product.getSystemNumber() : "?";
            serviceData.setNameProtocol(String.format("%s - %s", carrierString, systemNumberString));
            for (Traveller traveller : product.getPassengers()) {
                serviceData.getTravellers().add(!TextUtil.isBlank((String)traveller.getName()) ? traveller.getName().trim() : "?");
            }
            for (RailwaySegment segment : product.getSegments()) {
                String departureLocationString = segment.getDepartureStation() != null ? segment.getDepartureStation().toString() : "?";
                String arriveLocationString = segment.getArriveStation() != null ? segment.getArriveStation().toString() : "?";
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
                String departureDateString = segment.getDepartureDate() != null ? dateFormat.format(segment.getDepartureDate()) : "?";
                serviceData.getRoutes().add(String.format("%s-%s (%s)", departureLocationString, arriveLocationString, departureDateString));
            }
            billingItem.getServiceData().add(serviceData);
        }
    }

    private static final class CommissionData {
        public RailwayProduct product;
        public GeneralProductCommission commission;

        public CommissionData(GeneralProductCommission commission, RailwayProduct product) {
            this.commission = commission;
            this.product = product;
        }
    }
}

