/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.api;

import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.event.EventType;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchEvent;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.common.fx.assets.AsyncTaskAssignment;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportTaskInfo;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportsService;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import org.slf4j.LoggerFactory;

public final class ReportTasksMonitor {
    private static final Consumer<ReportLaunchEvent> LAUNCH_HANDLER = evt -> {
        Notifications.get().showFlashNotification(Messages.Forming_report_started + evt.getHandler().getName(), null);
        ReportTasksMonitor.loadTasks(true);
    };
    private static List<ReportTaskInfo> allTasks;
    private static Set<String> finishedTaskIds;
    private static boolean initialized;

    static void init() {
        if (initialized) {
            return;
        }
        EventBus.get().subscribe(ReportLaunchEvent.TYPE, LAUNCH_HANDLER);
        Notifications.get().getScheduler().scheduleWithFixedDelay(() -> ReportTasksMonitor.loadTasks(false), 2L, 15L, TimeUnit.SECONDS);
        initialized = true;
    }

    public static void force() {
        if (!Platform.isFxApplicationThread()) {
            ReportTasksMonitor.loadTasks(true);
            return;
        }
        Notifications.get().submitTask(() -> ReportTasksMonitor.loadTasks(true), Messages.Loading_tasks_to_form_reports);
    }

    private static synchronized void loadTasks(boolean force) {
        try {
            if (!ReportTasksMonitor.loadAllTasks() && !force) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            List<ReportTaskInfo> finishedTasks = ReportTasksMonitor.handleFinishedTasks(allTasks);
            for (ReportTaskInfo info : finishedTasks) {
                String details;
                if (!ServiceInvocationContext.get().getUser().equals(info.getOwner())) continue;
                if (info.getDocument() != null) {
                    if (info.getState() == AsyncTaskAssignment.TaskState.INTERRUPTED) {
                        Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Report_forming_interrupted, (Object[])new Object[0])});
                    } else if (info.getError() != null) {
                        ErrorHandler.handle((Throwable)info.getError());
                    } else if (info.getLog().stream().anyMatch(msg -> msg.getType() == MessageType.ERROR)) {
                        details = info.getLog().stream().filter(msg -> msg.getType() == MessageType.ERROR).map(msg -> LocaleManager.get().getL10nResourceManager().getMessage(msg.getMessage())).collect(Collectors.joining(",\n"));
                        Notifications.get().showMessages(new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.Error_reforming_report, (String)details, (Object[])new Object[0])});
                    } else {
                        Notifications.get().showFlashNotification(Messages.Report_formed + info.getDocument(), null);
                    }
                    RootEntityEditingService.navigateTo((EntityReference)info.getDocument());
                    continue;
                }
                if (info.getState() == AsyncTaskAssignment.TaskState.INTERRUPTED) {
                    Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Report_forming_interrupted, (Object[])new Object[0])});
                    continue;
                }
                if (info.getError() != null) {
                    ErrorHandler.handle((Throwable)info.getError());
                    continue;
                }
                details = info.getLog().stream().filter(msg -> msg.getType() == MessageType.ERROR).map(msg -> LocaleManager.get().getL10nResourceManager().getMessage(msg.getMessage())).collect(Collectors.joining(",\n"));
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.Error_forming_report, (String)details, (Object[])new Object[0])});
            }
            if (!force && !EventBus.get().hasSubscribers(TasksListEvent.TYPE)) {
                return;
            }
            TasksListEvent event = new TasksListEvent(new ArrayList<ReportTaskInfo>(allTasks), finishedTasks);
            EventBus.get().publishAsync((Event)event);
        }
        catch (Exception e) {
            if (force) {
                ErrorHandler.handle((Throwable)e);
            }
            LoggerFactory.getLogger(ReportTasksMonitor.class).error("failed loading tasks", (Throwable)e);
        }
    }

    private static boolean loadAllTasks() throws Exception {
        boolean result;
        List truncatedInfos = ((ReportsService)RpcServiceManager.get().getService(ReportsService.class)).getAllTasks(ServiceInvocationContext.get());
        ArrayList<ReportTaskInfo> allTasksNew = new ArrayList<ReportTaskInfo>(truncatedInfos.size());
        ArrayList<String> toLoad = new ArrayList<String>(truncatedInfos.size());
        for (ReportTaskInfo.Truncated truncatedInfo : truncatedInfos) {
            if (allTasks == null) {
                toLoad.add(truncatedInfo.getTaskId());
                continue;
            }
            boolean known = false;
            for (ReportTaskInfo info : allTasks) {
                if (!info.getTaskId().equals(truncatedInfo.getTaskId())) continue;
                known = true;
                if (!info.getState().isFinished()) {
                    toLoad.add(info.getTaskId());
                    break;
                }
                allTasksNew.add(info);
                break;
            }
            if (known) continue;
            toLoad.add(truncatedInfo.getTaskId());
        }
        if (!toLoad.isEmpty()) {
            allTasksNew.addAll(((ReportsService)RpcServiceManager.get().getService(ReportsService.class)).getTasks(ServiceInvocationContext.get(), toLoad));
            result = true;
        } else {
            result = (allTasks == null ? -1 : allTasks.size()) != allTasksNew.size();
        }
        allTasks = allTasksNew;
        return result;
    }

    private static List<ReportTaskInfo> handleFinishedTasks(List<ReportTaskInfo> tasks) {
        HashSet<String> allFinishedTasks = new HashSet<String>();
        ArrayList<ReportTaskInfo> result = new ArrayList<ReportTaskInfo>();
        for (ReportTaskInfo taskInfo : tasks) {
            if (!taskInfo.getState().isFinished()) continue;
            allFinishedTasks.add(taskInfo.getTaskId());
            if (finishedTaskIds == null || finishedTaskIds.contains(taskInfo.getTaskId())) continue;
            result.add(taskInfo);
        }
        finishedTaskIds = allFinishedTasks;
        return result;
    }

    private ReportTasksMonitor() {
    }

    static {
        initialized = false;
        ReportTasksMonitor.init();
    }

    public static class TasksListEvent
    implements Event<TasksListEvent> {
        public static final EventType<TasksListEvent> TYPE;
        private final List<ReportTaskInfo> allAvailableTasks;
        private final List<ReportTaskInfo> ownTasks;
        private final List<ReportTaskInfo> finishedTasks;

        TasksListEvent(List<ReportTaskInfo> all, List<ReportTaskInfo> finished) {
            this.allAvailableTasks = all;
            this.finishedTasks = finished;
            String owner = ServiceInvocationContext.get().getUser();
            this.ownTasks = all.stream().filter(info -> owner.equals(info.getOwner())).collect(Collectors.toList());
        }

        public EventType<TasksListEvent> getType() {
            return TYPE;
        }

        public List<ReportTaskInfo> getAllTasks() {
            return this.allAvailableTasks;
        }

        public List<ReportTaskInfo> getOwnTasks() {
            return this.ownTasks;
        }

        public List<ReportTaskInfo> getFinishedTasks() {
            return this.finishedTasks;
        }

        static {
            ReportTasksMonitor.init();
            TYPE = new EventType("REPORT_TASKS_LIST");
        }
    }
}

