/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.api;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportHandlersSupplier;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.api.TemplateReportLaunchHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcDictHelper;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class ReportsHelper {
    public static void enumerateAvailableHandlers(Consumer<ReportLaunchHandler> callback, boolean includeDisabled) throws Exception {
        String value;
        HashSet<String> disabledUids = new HashSet<String>();
        if (!includeDisabled && !TextUtil.isBlank((String)(value = RpcDictHelper.findPreferenceValue((PreferenceKey)PreferenceKey.BLANKTYPE_CHOICE_SETTINGS)))) {
            for (String id : TextUtil.split((String)value, (String)"\\|", (boolean)true, (boolean)true)) {
                if (!id.endsWith("!")) continue;
                disabledUids.add(id.substring(0, id.length() - 1));
            }
        }
        for (ReportHandlersSupplier supplier : ClientRegistry.get().allOf(ReportHandlersSupplier.TYPE).values()) {
            ArrayList<ReportLaunchHandler> handlers = new ArrayList<ReportLaunchHandler>(supplier.getLauncherHandlers());
            if (!includeDisabled) {
                ReportsHelper.filterByAcl(handlers);
            }
            for (ReportLaunchHandler handler : handlers) {
                if (handler instanceof TemplateReportLaunchHandler) {
                    TemplateReportLaunchHandler templateHandler = (TemplateReportLaunchHandler)handler;
                    if (!includeDisabled && templateHandler.isDisabled()) continue;
                    callback.accept(handler);
                    continue;
                }
                if (!includeDisabled && disabledUids.contains(handler.getUid())) continue;
                callback.accept(handler);
            }
        }
    }

    private static void filterByAcl(List<ReportLaunchHandler> handlers) throws Exception {
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (ReportLaunchHandler handler : handlers) {
            AclQuery query = handler.getACLQuery();
            if (query == null) continue;
            map.put(handler.getUid(), query);
        }
        Set grantedIds = FxAclUtil.applyACL(map);
        Iterator<ReportLaunchHandler> it = handlers.iterator();
        while (it.hasNext()) {
            String uid = it.next().getUid();
            if (grantedIds.contains(uid) || !map.containsKey(uid)) continue;
            it.remove();
        }
    }

    public static ReportDocumentHandler<?, ?> getDocumentHandler(Class<?> documentType) {
        for (ReportHandlersSupplier supplier : ClientRegistry.get().allOf(ReportHandlersSupplier.TYPE).values()) {
            for (ReportDocumentHandler<?, ?> handler : supplier.getDocumentHandlers()) {
                if (!handler.getEntityType().isAssignableFrom(documentType)) continue;
                return handler;
            }
        }
        return null;
    }

    private ReportsHelper() {
    }
}

