/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.AgentTemplateReportCommitReportDialog;
import com.gridnine.xtrip.client.fx.reports.model.AgentTemplateReportCommitReportDialogTable;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.worklog.Workplace;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportsService;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BasicPaymentDocumentIndex;
import com.gridnine.xtrip.common.model.finance.DebitSlip;
import com.gridnine.xtrip.common.model.finance.DebitSlipIndex;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.model.system.WorklogIndex;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDocument;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class AgentTemplateReportCommitDataAction
implements RootEntityAction {
    private final String id = "agent-template-report-register-action";

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        if (context.getData() == null || context.getData().getContainer() == null) {
            return StandardActionIcons.REGISTER;
        }
        AgentTemplateReportDocument doc = (AgentTemplateReportDocument)context.getData().getContainer().getEntity();
        return doc.isCommited() ? StandardActionIcons.UNREGISTER : StandardActionIcons.REGISTER;
    }

    public String getName(RootEntityPane<?, ?> context) {
        if (context.getData() == null || context.getData().getContainer() == null) {
            return Messages.Agent_report_commit_data_name;
        }
        AgentTemplateReportDocument doc = (AgentTemplateReportDocument)context.getData().getContainer().getEntity();
        return doc.isCommited() ? Messages.Agent_report_uncommit_data_name : Messages.Agent_report_commit_data_name;
    }

    public String getDescription(RootEntityPane<?, ?> context) {
        if (context.getData() == null || context.getData().getContainer() == null) {
            return Messages.Agent_report_commit_data_description;
        }
        AgentTemplateReportDocument doc = (AgentTemplateReportDocument)context.getData().getContainer().getEntity();
        return doc.isCommited() ? Messages.Agent_report_uncommit_data_description : Messages.Agent_report_commit_data_description;
    }

    public double getWeight() {
        return 32.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && AgentTemplateReportDocument.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() == EditingMode.EDIT;
    }

    public String getId() {
        return "agent-template-report-register-action";
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> {
            EntityContainer reportDocumentContainer = context.getData().getContainer();
            if (!((AgentTemplateReportDocument)reportDocumentContainer.getEntity()).isCommited()) {
                this.commitAgentReport(context, (EntityContainer<AgentTemplateReportDocument>)reportDocumentContainer);
            } else {
                this.uncommitAgentReport((EntityContainer<AgentTemplateReportDocument>)reportDocumentContainer, context);
            }
        });
    }

    private void commitAgentReport(RootEntityPane<?, ?> context, EntityContainer<AgentTemplateReportDocument> reportDocumentContainer) {
        AgentTemplateReportDocument reportDocument = (AgentTemplateReportDocument)reportDocumentContainer.getEntity();
        Date periodEnd = reportDocument.getParameters().getPeriodEnd();
        EntityReference agency = reportDocument.getParameters().getSubagency();
        EntityReference cashRegister = reportDocument.getParameters().getCashRegister();
        EntityReference agent = reportDocument.getParameters().getAgent();
        String reportDataValidationErrors = AgentTemplateReportCommitDataAction.validateReportContainerData(reportDocument);
        if (!TextUtil.isBlank((String)reportDataValidationErrors)) {
            Dialog.info((String)reportDataValidationErrors);
            return;
        }
        Notifications.get().submitTask(() -> {
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            ReportsService reportsService = (ReportsService)RpcServiceManager.get().getService(ReportsService.class);
            boolean agentSettingsEnabled = reportsService.isAgentSettingsEnabled(ServiceInvocationContext.get(), agency);
            if (AgentTemplateReportCommitDataAction.checkWhetherTransactionsAlreadyExist(entityService, reportDocumentContainer.getUid())) {
                Dialog.info((String)Messages.Report_data_already_exists);
                return;
            }
            BigDecimal agentAmount = reportsService.getAgentAmountToCommitAgentReport(ServiceInvocationContext.get(), reportDocument);
            FxUtil.submitToFxThread(() -> {
                Dialog dialog = new Dialog();
                AgentTemplateReportCommitReportDialog dialogData = new AgentTemplateReportCommitReportDialog(false);
                ((AgentTemplateReportCommitReportDialogTable)dialogData.getContent()).getCashCalculatedValueNode().setValue((Number)agentAmount);
                ((AgentTemplateReportCommitReportDialogTable)dialogData.getContent()).getCashFactualValueNode().setValue((Number)agentAmount);
                dialog.setTitle(Messages.Register_report_data).setAutoClose(false).setBody((Node)dialogData).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Register, () -> {
                    BigDecimal agentDeliverAmount;
                    BigDecimal agentTotalAmount = (BigDecimal)((AgentTemplateReportCommitReportDialogTable)dialogData.getContent()).getCashCalculatedValueNode().getValue();
                    if (!this.isDialogDataValid(agentTotalAmount, agentDeliverAmount = (BigDecimal)((AgentTemplateReportCommitReportDialogTable)dialogData.getContent()).getCashFactualValueNode().getValue(), dialogData)) {
                        return;
                    }
                    Notifications.get().submitTask(() -> {
                        Worklog worklog;
                        reportsService.processAgentTemplateReport(ServiceInvocationContext.get(), reportDocumentContainer, agentDeliverAmount, agentTotalAmount);
                        String successMessage = Messages.getReport_N_registered(reportDocument.getFile().getTitle());
                        Notifications.get().showFlashNotification(successMessage, successMessage);
                        if (!agentSettingsEnabled) {
                            EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(reportDocumentContainer.toReference(), EntityModification.ModificationType.CHANGE)));
                            return;
                        }
                        EntityContainer worklogContainer = reportsService.getWorklogContainer(ServiceInvocationContext.get(), cashRegister, periodEnd);
                        if (worklogContainer != null && MiscUtil.equals((Object)(worklog = (Worklog)worklogContainer.getEntity()).getEmployee(), (Object)agent)) {
                            FxUtil.submitToFxThread(() -> Dialog.confirm((Node)context.getEditor(), (String)Messages.Create_PKO_cashier, () -> Notifications.get().submitTask(() -> {
                                Locale locale = LocaleManager.get().getCurrentLocaleData().getLocale() != null ? LocaleManager.get().getCurrentLocaleData().getLocale() : LocaleManager.get().getCurrentLocale();
                                DebitSlip debitSlip = reportsService.createDebitSlip(ServiceInvocationContext.get(), worklog, periodEnd, locale);
                                FxUtil.submitToFxThread(() -> RootEntityActivityHandler.editNew((DataTransferPackage)new DataTransferPackage(EntityContainer.create((BaseEntity)debitSlip))));
                            }, Messages.Creating_PKO)));
                        }
                        EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(reportDocumentContainer.toReference(), EntityModification.ModificationType.CHANGE)));
                    }, Messages.Report_registering);
                    dialog.close();
                }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show(context.getEditor());
            });
        }, Messages.Verifying_report_data);
    }

    private static String validateReportContainerData(AgentTemplateReportDocument reportDocument) {
        StringBuilder sb = new StringBuilder();
        Date periodBegin = reportDocument.getParameters().getPeriodBegin();
        Date periodEnd = reportDocument.getParameters().getPeriodEnd();
        EntityReference agency = reportDocument.getParameters().getSubagency();
        EntityReference salesPoint = reportDocument.getParameters().getSalesPoint();
        EntityReference cash = reportDocument.getParameters().getCash();
        EntityReference cashRegister = reportDocument.getParameters().getCashRegister();
        EntityReference cashRegisterWorkplace = reportDocument.getParameters().getCashRegisterWorkplace();
        EntityReference agent = reportDocument.getParameters().getAgent();
        if (periodBegin == null) {
            sb.append(Messages.No_report_start_data).append("\n\r");
        }
        if (periodEnd == null) {
            sb.append(Messages.No_report_end_data).append("\n\r");
        }
        if (agency == null) {
            sb.append(Messages.No_report_subagency).append("\n\r");
        }
        if (salesPoint == null) {
            sb.append(Messages.No_report_sales_point).append("\n\r");
        }
        if (cash == null) {
            sb.append(Messages.No_report_cashier).append("\n\r");
        }
        if (cashRegister == null) {
            sb.append(Messages.No_report_cash_machine).append("\n\r");
        }
        if (cashRegisterWorkplace == null) {
            sb.append(Messages.No_report_work_place).append("\n\r");
        }
        if (agent == null) {
            sb.append(Messages.No_report_agent).append("\n\r");
        }
        return sb.toString();
    }

    private static boolean checkWhetherTransactionsAlreadyExist(EntityService entityService, String reportDocumentContainerUid) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.documentUid.name(), (Object)reportDocumentContainerUid));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
        List indexes = entityService.search(ServiceInvocationContext.get(), TransactionSplitIndex.class, query);
        return indexes.size() > 0;
    }

    private boolean isDialogDataValid(BigDecimal agentTotalAmount, BigDecimal agentDeliverAmount, AgentTemplateReportCommitReportDialog dialogData) {
        if (agentTotalAmount != null && agentDeliverAmount == null) {
            dialogData.getChildren().removeAll((Collection)dialogData.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
            dialogData.getChildren().add(0, (Object)MessagePane.error((String)Messages.No_report_cashier_amount));
            return false;
        }
        return true;
    }

    private void uncommitAgentReport(EntityContainer<AgentTemplateReportDocument> reportDocumentContainer, RootEntityPane<?, ?> context) {
        AgentTemplateReportDocument reportDocument = (AgentTemplateReportDocument)reportDocumentContainer.getEntity();
        EntityReference agency = reportDocument.getParameters().getSubagency();
        Dialog.confirm((String)Messages.getUnregister_report(reportDocument.getFile().getTitle()), () -> Notifications.get().submitTask(() -> {
            Worklog worklog;
            EntityContainer<Worklog> worklogContainer;
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            ReportsService reportsService = (ReportsService)RpcServiceManager.get().getService(ReportsService.class);
            boolean agentSettingsEnabled = reportsService.isAgentSettingsEnabled(ServiceInvocationContext.get(), agency);
            reportsService.uncommitAgentTransactions(ServiceInvocationContext.get(), reportDocument, reportDocumentContainer);
            if (agentSettingsEnabled && Workplace.get().isWorklogOpen() && (worklogContainer = this.getCashierWorklog(entityService, (EntityReference<CashRegister>)reportDocument.getParameters().getCashRegister(), reportDocument.getParameters().getPeriodEnd())) != null && MiscUtil.equals((Object)(worklog = (Worklog)worklogContainer.getEntity()).getEmployee(), (Object)reportDocument.getParameters().getAgent())) {
                FxUtil.submitToFxThread(() -> Dialog.confirm((String)Messages.Delete_PKO, () -> Notifications.get().submitTask(() -> {
                    List<EntityReference<BasePaymentDocument>> debitSlips = this.getDebitSlips(entityService, worklog);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (EntityReference<BasePaymentDocument> debitSlip : debitSlips) {
                        entityService.delete(ServiceInvocationContext.get(), debitSlip);
                        stringBuilder.append(Messages.getPKO_deleted(debitSlip.toString()) + "\n\r");
                    }
                    FxUtil.submitToFxThread(() -> Dialog.info((String)(TextUtil.isBlank((String)stringBuilder.toString()) ? Messages.PKO_not_found : stringBuilder.toString())));
                }, Messages.PKO_deleting)));
            }
            EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(reportDocumentContainer.toReference(), EntityModification.ModificationType.CHANGE)));
        }, Messages.Report_unregistering));
    }

    private EntityContainer<Worklog> getCashierWorklog(EntityService entityService, EntityReference<CashRegister> cashRegister, Date date) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cashRegister.name(), cashRegister));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)WorklogIndex.Property.types.name(), (Object)PersonType.CASHIER_CLERK));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)WorklogIndex.Property.startDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.startDate.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)WorklogIndex.Property.endDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null)}));
        List worklogIndexes = entityService.search(ServiceInvocationContext.get(), WorklogIndex.class, query);
        return worklogIndexes.size() > 0 ? entityService.load(ServiceInvocationContext.get(), ((WorklogIndex)worklogIndexes.get(0)).getSource()) : null;
    }

    private List<EntityReference<BasePaymentDocument>> getDebitSlips(EntityService entityService, Worklog cashierWorklog) throws Exception {
        EntityReference agency = null;
        EntityContainer salesPointContainer = entityService.load(ServiceInvocationContext.get(), cashierWorklog.getSalesPoint());
        if (salesPointContainer != null) {
            SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
            agency = salesPoint.getAgency();
        }
        SearchQuery query = new SearchQuery();
        if (agency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DebitSlipIndex.Property.organization.name(), (Object)agency));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DebitSlipIndex.Property.payer.name(), (Object)agency));
        }
        if (cashierWorklog.getStartDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)DebitSlipIndex.Property.date.name(), (Object)cashierWorklog.getStartDate()));
        }
        if (cashierWorklog.getEndDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)DebitSlipIndex.Property.date.name(), (Object)cashierWorklog.getEndDate()));
        }
        List indexes = entityService.search(ServiceInvocationContext.get(), BasicPaymentDocumentIndex.class, query);
        ArrayList<EntityReference<BasePaymentDocument>> debitSlips = new ArrayList<EntityReference<BasePaymentDocument>>();
        for (BasicPaymentDocumentIndex index : indexes) {
            EntityReference debitSlip = index.getSource();
            if (debitSlips.contains(debitSlip)) continue;
            debitSlips.add((EntityReference<BasePaymentDocument>)debitSlip);
        }
        return debitSlips;
    }
}

