/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.BaseReportDocumentEntityHandler;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.ReportDocumentHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.TemplateReportParametersHelper;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.AirTicketsTemplateReportDocumentPane;
import com.gridnine.xtrip.client.fx.reports.model.AirTicketsTemplateReportDocumentPaneController;
import com.gridnine.xtrip.client.fx.reports.model.AirTicketsTemplateReportDocumentPaneVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.uidata.AirTicketsTemplateReportDocumentUIData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;

public class AirTicketsTemplateReportDocumentHandler
extends BaseReportDocumentEntityHandler<AirTicketsTemplateReportDocument, AirTicketsTemplateReportDocumentUIData, AirTicketsTemplateReportDocumentPaneVM, AirTicketsTemplateReportDocumentPane> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<AirTicketsTemplateReportDocument, AirTicketsTemplateReportDocumentUIData>, AirTicketsTemplateReportDocumentPaneVM>> toVM, List<BiConsumer<AirTicketsTemplateReportDocumentPaneVM, DataTransferPackage<AirTicketsTemplateReportDocument, AirTicketsTemplateReportDocumentUIData>>> fromVM) {
        super.configureController(toVM, fromVM);
        toVM.add((dtp, vm) -> {
            AirTicketsTemplateReportDocument model = (AirTicketsTemplateReportDocument)dtp.getContainer().getEntity();
            ReportDocumentHelper.reportFileToVm(model.getFile(), vm.getFile());
            AirTicketsTemplateReportDescription description = ((AirTicketsTemplateReportDocumentUIData)dtp.getSupplement()).getDescription();
            if (description != null) {
                vm.getParameters().getMain().setDescription(description);
                if (vm.getParameters().getMain().getRequestedParameters() == null) {
                    vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                    TemplateReportParametersHelper.createRequestedParameters(description.getRequestedParameters(), vm.getParameters().getMain().getRequestedParameters(), Boolean.TRUE);
                }
                ReportLaunchHelper.toVMAirTicketsTemplateReportParameters(model.getParameters(), vm.getParameters());
            } else {
                vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                Notifications.get().showMessages(new Message[]{MessageHelper.createWarningMessage((String)Messages.Report_template_not_found, (Object[])new Object[0])});
            }
            ReportDocumentHelper.toVMMessages(model.getMessages(), vm.getMessages());
        });
        fromVM.add((vm, dtp) -> {
            AirTicketsTemplateReportDocument model = (AirTicketsTemplateReportDocument)dtp.getContainer().getEntity();
            ReportLaunchHelper.toModelAirTicketsTemplateReportParameters(vm.getParameters(), model.getParameters());
            ReportFile file = model.getFile();
            if (file == null) {
                file = new ReportFile();
                model.setFile(file);
            }
            ReportDocumentHelper.reportFileFromVm(file, vm.getFile());
        });
    }

    public Class<AirTicketsTemplateReportDocument> getEntityClass() {
        return AirTicketsTemplateReportDocument.class;
    }

    public Class<AirTicketsTemplateReportDocumentUIData> getSupplementClass() {
        return AirTicketsTemplateReportDocumentUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return TemplateReportDocumentIndex.class;
    }

    protected AirTicketsTemplateReportDocumentPaneVM createVM() {
        return new AirTicketsTemplateReportDocumentPaneVM();
    }

    @Override
    protected Class<? extends ViewController<AirTicketsTemplateReportDocumentPane, AirTicketsTemplateReportDocumentPaneVM>> getSpaceControllerClass() {
        return AirTicketsTemplateReportDocumentPaneController.class;
    }
}

