/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.BaseReportDocumentEntityHandler;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.ReportDocumentHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.TemplateReportParametersHelper;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.IndexBasedTemplateReportDocumentPane;
import com.gridnine.xtrip.client.fx.reports.model.IndexBasedTemplateReportDocumentPaneController;
import com.gridnine.xtrip.client.fx.reports.model.IndexBasedTemplateReportDocumentPaneVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.uidata.IndexBasedTemplateReportDocumentUIData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;

public class IndexBasedTemplateReportDocumentHandler
extends BaseReportDocumentEntityHandler<IndexBasedTemplateReportDocument, IndexBasedTemplateReportDocumentUIData, IndexBasedTemplateReportDocumentPaneVM, IndexBasedTemplateReportDocumentPane> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<IndexBasedTemplateReportDocument, IndexBasedTemplateReportDocumentUIData>, IndexBasedTemplateReportDocumentPaneVM>> toVM, List<BiConsumer<IndexBasedTemplateReportDocumentPaneVM, DataTransferPackage<IndexBasedTemplateReportDocument, IndexBasedTemplateReportDocumentUIData>>> fromVM) {
        super.configureController(toVM, fromVM);
        toVM.add((dtp, vm) -> {
            IndexBasedTemplateReportDocument model = (IndexBasedTemplateReportDocument)dtp.getContainer().getEntity();
            ReportDocumentHelper.reportFileToVm(model.getFile(), vm.getFile());
            IndexBasedTemplateReportDescription description = ((IndexBasedTemplateReportDocumentUIData)dtp.getSupplement()).getDescription();
            if (description != null) {
                vm.getParameters().getMain().setDescription(description);
                if (vm.getParameters().getMain().getRequestedParameters() == null) {
                    vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                    TemplateReportParametersHelper.createRequestedParameters(description.getRequestedParameters(), vm.getParameters().getMain().getRequestedParameters(), Boolean.TRUE);
                }
                ReportLaunchHelper.toVMIndexBasedTemplateReportParameters(model.getParameters(), vm.getParameters());
            } else {
                vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                Notifications.get().showMessages(new Message[]{MessageHelper.createWarningMessage((String)Messages.Report_template_not_found, (Object[])new Object[0])});
            }
            ReportDocumentHelper.toVMMessages(model.getMessages(), vm.getMessages());
        });
        fromVM.add((vm, dtp) -> {
            IndexBasedTemplateReportDocument model = (IndexBasedTemplateReportDocument)dtp.getContainer().getEntity();
            ReportLaunchHelper.toModelIndexBasedTemplateReportParameters(vm.getParameters(), model.getParameters());
            ReportFile file = model.getFile();
            if (file == null) {
                file = new ReportFile();
                model.setFile(file);
            }
            ReportDocumentHelper.reportFileFromVm(file, vm.getFile());
        });
    }

    public Class<IndexBasedTemplateReportDocument> getEntityClass() {
        return IndexBasedTemplateReportDocument.class;
    }

    public Class<IndexBasedTemplateReportDocumentUIData> getSupplementClass() {
        return IndexBasedTemplateReportDocumentUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return TemplateReportDocumentIndex.class;
    }

    protected IndexBasedTemplateReportDocumentPaneVM createVM() {
        return new IndexBasedTemplateReportDocumentPaneVM();
    }

    @Override
    protected Class<? extends ViewController<IndexBasedTemplateReportDocumentPane, IndexBasedTemplateReportDocumentPaneVM>> getSpaceControllerClass() {
        return IndexBasedTemplateReportDocumentPaneController.class;
    }
}

