/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.IndexBasedTemplateReportTileSpaceVM;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.TemplateReportHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageTemplate;
import com.gridnine.xtrip.common.reports.model.TemplateReportRequestedParameter;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

class IndexBasedTemplateReportHelper {
    IndexBasedTemplateReportHelper() {
    }

    static void fromVMPages(IndexBasedTemplateReportTileSpaceVM vm, IndexBasedTemplateReportDescription model, List<TemplateReportPageTemplate> templates) {
        VMHelper.transfer((Collection)vm.getPagesFull(), (Collection)model.getPages(), el -> new IndexBasedTemplateReportPageDescription(), (paramVM, param) -> {
            param.setName(paramVM.getName());
            if (paramVM.getTemplate() != null) {
                String templateUid = (String)paramVM.getTemplate().getLast();
                Optional<TemplateReportPageTemplate> template = templates.stream().filter(el -> el.getUid().equals(templateUid)).findFirst();
                if (template.isPresent()) {
                    param.setTemplate(template.get());
                } else {
                    param.setTemplate(null);
                }
            }
            String script = paramVM.getScript();
            param.setSortOrderScript(script);
            if (script != null) {
                param.getSortOrders().clear();
            } else {
                TemplateReportHelper.fromVMSortOrder(paramVM.getSortOrder(), param.getSortOrders());
            }
            TemplateReportHelper.fromVMPagesCriterion(paramVM.getCriterion(), (List<SearchCriterion>)param.getPageCriterions(), model.getIndexClassName(), (List<TemplateReportRequestedParameter>)model.getRequestedParameters());
            TemplateReportHelper.fromVMCustomParameters(paramVM.getParameters(), param.getCustomParameters());
        });
    }

    static void fromVMScriptOrSortOrder(IndexBasedTemplateReportTileSpaceVM vm, IndexBasedTemplateReportDescription model) {
        String script = vm.getMainFull().getAdditional().getScript();
        if (script != null) {
            model.setQueryScript(vm.getMainFull().getAdditional().getScript());
            model.getSortOrders().clear();
            model.getGlobalCriterions().clear();
        } else {
            model.setQueryScript(null);
            TemplateReportHelper.fromVMSortOrder(vm.getMainFull().getAdditional().getSortOrder(), model.getSortOrders());
            try {
                TemplateReportHelper.fromVMAdditionalCriterion(vm.getMainFull().getAdditional().getGlobalCriterion(), model.getGlobalCriterions(), Class.forName(model.getIndexClassName()), model.getRequestedParameters());
            }
            catch (ClassNotFoundException e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
    }
}

