/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.reports.api.ReportTasksMonitor;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.ReportFilePaneVM;
import com.gridnine.xtrip.client.fx.reports.model.ReportMessagesTableItemVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportTaskInfo;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javafx.scene.Node;

final class ReportDocumentHelper {
    static void initiateMonitoring(Node view) {
        if (view.getProperties().containsKey((Object)"tasksListHandler")) {
            return;
        }
        Consumer<ReportTasksMonitor.TasksListEvent> tasksListHandler = evt -> ReportDocumentHelper.handleTasksList(evt.getAllTasks(), evt.getFinishedTasks(), view);
        view.getProperties().put((Object)"tasksListHandler", tasksListHandler);
        EventBus.get().subscribe(ReportTasksMonitor.TasksListEvent.TYPE, tasksListHandler);
        ReportTasksMonitor.force();
    }

    private static void handleTasksList(List<ReportTaskInfo> allTasks, List<ReportTaskInfo> newFinishedTasks, Node view) {
        ValueHolder ref = new ValueHolder();
        try {
            FxUtil.waitForFxThread(() -> {
                RootEntityPane entityPane = RootEntityPane.lookup((Node)view);
                if (entityPane == null) {
                    return;
                }
                DataTransferPackage data = entityPane.getData();
                if (data != null && data.getContainer() != null) {
                    ref.set((Object)data.getContainer().toReference());
                }
            });
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return;
        }
        if (ref.get() == null) {
            return;
        }
        boolean running = allTasks.stream().anyMatch(taskInfo -> !taskInfo.getState().isFinished() && ((EntityReference)ref.get()).equals((Object)taskInfo.getDocument()));
        boolean finished = running ? false : newFinishedTasks.stream().anyMatch(taskInfo -> ((EntityReference)ref.get()).equals((Object)taskInfo.getDocument()));
        FxUtil.submitToFxThread(() -> {
            RootEntityPane entityPane = RootEntityPane.lookup((Node)view);
            if (entityPane == null) {
                return;
            }
            if (finished) {
                Notifications.get().submitTask(() -> entityPane.reloadData(), entityPane.getMutex());
            } else if (running) {
                entityPane.titleProperty().set((Object)("[" + Messages.Performing + "] - " + ((EntityReference)ref.get()).getCaption()));
            }
        });
    }

    static void reportFilesToVm(List<ReportFile> models, List<ReportFilePaneVM> vms) {
        VMHelper.transfer(models, vms, file -> new ReportFilePaneVM(), (file, fileVM) -> ReportDocumentHelper.reportFileToVm(file, fileVM));
    }

    static void reportFileToVm(ReportFile model, ReportFilePaneVM vm) {
        if (model == null) {
            vm.setUid(null);
            vm.setTitle(null);
            vm.setFileName(null);
            vm.setFileData(null);
            return;
        }
        vm.setUid(model.getUid());
        vm.setTitle(model.getTitle());
        vm.setFileName(model.getName());
        RichData rd = vm.getFileData();
        if (rd == null) {
            rd = new RichData();
            vm.setFileData(rd);
        }
        rd.setContent(model.getContent());
        rd.setContentType(model.getContentType());
    }

    static void reportFilesFromVm(List<ReportFile> models, List<ReportFilePaneVM> vms) {
        VMHelper.transfer(vms, models, fileVM -> new ReportFile(), (fileVM, file) -> ReportDocumentHelper.reportFileFromVm(file, fileVM));
    }

    static void reportFileFromVm(ReportFile model, ReportFilePaneVM vm) {
        if (!TextUtil.isBlank((String)vm.getUid())) {
            model.setUid(vm.getUid());
        }
        model.setTitle(vm.getTitle());
        model.setName(vm.getFileName());
        RichData rd = vm.getFileData();
        model.setContent(rd == null ? null : rd.getContent());
        model.setContentType(rd == null ? null : rd.getContentType());
    }

    static void toVMMessages(Set<Message> messages, List<ReportMessagesTableItemVM> messagesVM) {
        messages.forEach(message -> {
            ReportMessagesTableItemVM msgVM = new ReportMessagesTableItemVM();
            msgVM.setType(message.getType());
            if (message.getMessage() != null) {
                msgVM.setMessage(message.getMessage().toString());
            }
            msgVM.setDetails(message.getDetails());
            messagesVM.add(msgVM);
        });
    }

    private ReportDocumentHelper() {
    }
}

