/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.BaseReportDocumentEntityHandler;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.ReportDocumentHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.model.ReportDocumentPane;
import com.gridnine.xtrip.client.fx.reports.model.ReportDocumentPaneController;
import com.gridnine.xtrip.client.fx.reports.model.ReportDocumentPaneVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.SalesReportDocumentIndex;
import java.util.List;
import java.util.function.BiConsumer;

public class SalesReportDocumentHandler
extends BaseReportDocumentEntityHandler<ReportDocument, Void, ReportDocumentPaneVM, ReportDocumentPane> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<ReportDocument, Void>, ReportDocumentPaneVM>> toVM, List<BiConsumer<ReportDocumentPaneVM, DataTransferPackage<ReportDocument, Void>>> fromVM) {
        super.configureController(toVM, fromVM);
        toVM.add((dtp, vm) -> {
            ReportDocument model = (ReportDocument)dtp.getContainer().getEntity();
            ReportDocumentHelper.reportFilesToVm(model.getFiles(), vm.getFiles());
            ReportLaunchHelper.toVMReportParameters(model.getParameters(), vm.getParameters());
            ReportDocumentHelper.toVMMessages(model.getMessages(), vm.getMessages());
        });
        fromVM.add((vm, dtp) -> {
            ReportDocument model = (ReportDocument)dtp.getContainer().getEntity();
            ReportLaunchHelper.toModelReportParameters(vm.getParameters(), model.getParameters());
            ReportDocumentHelper.reportFilesFromVm(model.getFiles(), vm.getFiles());
        });
    }

    public Class<ReportDocument> getEntityClass() {
        return ReportDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return SalesReportDocumentIndex.class;
    }

    protected ReportDocumentPaneVM createVM() {
        return new ReportDocumentPaneVM();
    }

    @Override
    protected Class<? extends ViewController<ReportDocumentPane, ReportDocumentPaneVM>> getSpaceControllerClass() {
        return ReportDocumentPaneController.class;
    }
}

