/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.BaseReportDocumentEntityHandler;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.ReportDocumentHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.TemplateReportParametersHelper;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.StockBlankTemplateReportDocumentPane;
import com.gridnine.xtrip.client.fx.reports.model.StockBlankTemplateReportDocumentPaneController;
import com.gridnine.xtrip.client.fx.reports.model.StockBlankTemplateReportDocumentPaneVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.StockBlankReportDescription;
import com.gridnine.xtrip.common.reports.model.StockBlankReportDocument;
import com.gridnine.xtrip.common.reports.model.StockBlankReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.uidata.StockBlankTemplateReportDocumentUIData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;

public class StockBlankReportDocumentHandler
extends BaseReportDocumentEntityHandler<StockBlankReportDocument, StockBlankTemplateReportDocumentUIData, StockBlankTemplateReportDocumentPaneVM, StockBlankTemplateReportDocumentPane> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<StockBlankReportDocument, StockBlankTemplateReportDocumentUIData>, StockBlankTemplateReportDocumentPaneVM>> toVM, List<BiConsumer<StockBlankTemplateReportDocumentPaneVM, DataTransferPackage<StockBlankReportDocument, StockBlankTemplateReportDocumentUIData>>> fromVM) {
        super.configureController(toVM, fromVM);
        toVM.add((dtp, vm) -> {
            StockBlankReportDocument model = (StockBlankReportDocument)dtp.getContainer().getEntity();
            ReportDocumentHelper.reportFileToVm(model.getFile(), vm.getFile());
            StockBlankReportDescription description = ((StockBlankTemplateReportDocumentUIData)dtp.getSupplement()).getDescription();
            if (description != null) {
                vm.getParameters().getMain().setDescription(description);
                if (vm.getParameters().getMain().getRequestedParameters() == null) {
                    vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                    TemplateReportParametersHelper.createRequestedParameters(description.getRequestedParameters(), vm.getParameters().getMain().getRequestedParameters(), Boolean.TRUE);
                }
                ReportLaunchHelper.toVMStockBlankTemplateReportParameters(model.getParameters(), vm.getParameters());
            } else {
                vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                Notifications.get().showMessages(new Message[]{MessageHelper.createWarningMessage((String)Messages.Report_template_not_found, (Object[])new Object[0])});
            }
            ReportDocumentHelper.toVMMessages(model.getMessages(), vm.getMessages());
        });
        fromVM.add((vm, dtp) -> {
            StockBlankReportDocument model = (StockBlankReportDocument)dtp.getContainer().getEntity();
            ReportLaunchHelper.toModelStockBlankTemplateReportParameters(vm.getParameters(), model.getParameters());
            ReportFile file = model.getFile();
            if (file == null) {
                file = new ReportFile();
                model.setFile(file);
            }
            ReportDocumentHelper.reportFileFromVm(file, vm.getFile());
        });
    }

    public Class<StockBlankReportDocument> getEntityClass() {
        return StockBlankReportDocument.class;
    }

    public Class<StockBlankTemplateReportDocumentUIData> getSupplementClass() {
        return StockBlankTemplateReportDocumentUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return StockBlankReportDocumentIndex.class;
    }

    protected StockBlankTemplateReportDocumentPaneVM createVM() {
        return new StockBlankTemplateReportDocumentPaneVM();
    }

    @Override
    protected Class<? extends ViewController<StockBlankTemplateReportDocumentPane, StockBlankTemplateReportDocumentPaneVM>> getSpaceControllerClass() {
        return StockBlankTemplateReportDocumentPaneController.class;
    }
}

