/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportControlStatusesContainerVM;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportOverviewPanelContainerVM;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportPagesContainerCustomParametersVM;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportPagesContainerVM;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportRequestedParametersContainerVM;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportRequestedParametersTableVM;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportSortOrderTableVM;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportSortOrderVM;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportTemplatesContainerVM;
import com.gridnine.xtrip.client.fx.model.custom.restrictions.RestrictionsData;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageCustomParameterValue;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageTemplate;
import com.gridnine.xtrip.common.reports.model.TemplateReportRequestedParameter;
import com.gridnine.xtrip.common.reports.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.system.model.SortOrderData;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class TemplateReportHelper {
    static void toVMOverview(BaseSingleFileTemplateReportDescription model, TemplateReportOverviewPanelContainerVM vm, int pages) {
        vm.setName(model.getTitle());
        vm.setPages(pages);
        vm.setTemplates(model.getTemplates().size());
    }

    static void toVMMainControls(BaseSingleFileTemplateReportDescription model, TemplateReportControlStatusesContainerVM vm) {
        vm.setAllowEmptyValue(model.isAllowEmpty());
        vm.setDisabledValue(model.isDisabled());
        vm.setDublicateValue(model.isDuplicateDisallowed());
        vm.setPeriodIntersectionValue(model.isPeriodIntersectionDisallowed());
    }

    static void toVMMainRequestParameters(BaseSingleFileTemplateReportDescription model, TemplateReportRequestedParametersContainerVM vm) {
        VMHelper.transfer((Collection)model.getRequestedParameters(), (Collection)vm.getContent(), el -> new TemplateReportRequestedParametersTableVM(), (param, paramVM) -> {
            paramVM.setBusinessType(param.getBusinessType());
            paramVM.setControlType(param.getControlType());
            paramVM.setKey(param.getKey());
            paramVM.setName(param.getName());
            paramVM.setSubType(param.getSubtype());
            paramVM.setType(param.getType());
        });
    }

    static void toVMTemplates(List<TemplateReportPageTemplate> model, List<TemplateReportTemplatesContainerVM> vms) {
        VMHelper.transfer(model, vms, el -> new TemplateReportTemplatesContainerVM(), (param, paramVM) -> {
            paramVM.setName(param.getName());
            if (param.getContent() != null) {
                RichData rd = new RichData();
                rd.setContentType(param.getContent().getContentType());
                rd.setContent(param.getContent().getData());
                paramVM.setScript(rd);
            } else {
                paramVM.setScript(null);
            }
        });
    }

    static <T extends BaseTemplateReportPageDescription> void toVMPages(List<T> modelPageDescrs, List<TemplateReportPagesContainerVM> vmPages, Class indexClass, List<TemplateReportRequestedParameter> requestedParameters) {
        VMHelper.transfer(modelPageDescrs, vmPages, el -> new TemplateReportPagesContainerVM(), (param, paramVM) -> {
            paramVM.setIndexClass(indexClass.getName());
            paramVM.setName(param.getName());
            if (param.getTemplate() != null) {
                paramVM.setTemplate(new Pair((Object)param.getTemplate().getName(), (Object)param.getTemplate().getUid()));
            }
            paramVM.setScript(param.getSortOrderScript());
            paramVM.setSelect(TextUtil.isBlank((String)param.getSortOrderScript()));
            TemplateReportHelper.toVMSortOrder(param.getSortOrders(), paramVM.getSortOrder());
            TemplateReportHelper.toVMPagesCriterion(param.getPageCriterions(), paramVM.getCriterion(), indexClass, requestedParameters);
            TemplateReportHelper.toVMCustomParameters(param.getCustomParameters(), paramVM.getParameters());
        });
    }

    static <T extends BaseTemplateReportPageDescription> void fromVMPages(List<TemplateReportPagesContainerVM> vm, List<T> modelPageDescrs, Supplier<T> sup, List<TemplateReportPageTemplate> templates, Class someclass, List<TemplateReportRequestedParameter> requestedParameters) {
        VMHelper.transfer(vm, modelPageDescrs, el -> (BaseTemplateReportPageDescription)sup.get(), (paramVM, param) -> {
            param.setName(paramVM.getName());
            if (paramVM.getTemplate() != null) {
                String templateUid = (String)paramVM.getTemplate().getLast();
                Optional<TemplateReportPageTemplate> template = templates.stream().filter(el -> el.getUid().equals(templateUid)).findFirst();
                if (template.isPresent()) {
                    param.setTemplate(template.get());
                } else {
                    param.setTemplate(null);
                }
            }
            String script = paramVM.getScript();
            param.setSortOrderScript(script);
            if (script != null) {
                param.getSortOrders().clear();
            } else {
                TemplateReportHelper.fromVMSortOrder(paramVM.getSortOrder(), param.getSortOrders());
            }
            TemplateReportHelper.fromVMPagesCriterion(paramVM.getCriterion(), (List<SearchCriterion>)param.getPageCriterions(), someclass, requestedParameters);
            TemplateReportHelper.fromVMCustomParameters(paramVM.getParameters(), param.getCustomParameters());
        });
    }

    static void toVMSortOrder(List<SortOrderData> model, TemplateReportSortOrderVM vm) {
        VMHelper.transfer(model, (Collection)vm.getContent(), el -> new TemplateReportSortOrderTableVM(), (param, paramVM) -> {
            paramVM.setField(param.getPropertyName());
            paramVM.setOrder(param.getOrder());
        });
    }

    static void fromVMSortOrder(TemplateReportSortOrderVM vm, List<SortOrderData> model) {
        VMHelper.transfer((Collection)vm.getContent(), model, el -> new SortOrderData(), (paramVM, param) -> {
            param.setPropertyName(paramVM.getField());
            param.setOrder(paramVM.getOrder());
        });
    }

    public static void fromVMTemplates(List<TemplateReportTemplatesContainerVM> vm, List<TemplateReportPageTemplate> model) {
        VMHelper.transfer(vm, model, el -> new TemplateReportPageTemplate(), (paramVM, param) -> {
            param.setName(paramVM.getName());
            if (paramVM.getScript() == null) {
                param.setContent(null);
            } else {
                if (param.getContent() == null) {
                    param.setContent(new BinaryData());
                }
                param.getContent().setContentType(paramVM.getScript().getContentType());
                param.getContent().setData(paramVM.getScript().getContent());
            }
        });
    }

    public static void toVMAdditionalCriterion(List<SearchCriterion> criterions, RestrictionsData vm, Class<?> type, List<TemplateReportRequestedParameter> parameters) {
        List dynamicValueHandlers = RestrictionsHelper.createDynamicValueHandlers(parameters, null);
        vm.setRestrictionId(type.getName());
        vm.getRestrictions().clear();
        vm.getRestrictions().addAll(RestrictionsUtil.toRestrictionGroupsFromQuery(criterions, type, (Collection)dynamicValueHandlers));
    }

    public static void toVMPagesCriterion(List<SearchCriterion> criterions, RestrictionsData vm, Class<?> type, List<TemplateReportRequestedParameter> parameters) {
        List dynamicValueHandlers = RestrictionsHelper.createDynamicValueHandlers(parameters, null);
        vm.setRestrictionId(type.getName());
        vm.getRestrictions().clear();
        try {
            RestrictionResourcesRegistry registry = type.getName().endsWith("Index") ? com.gridnine.xtrip.common.model.restriction.helper.RestrictionsHelper.createRegistry((IndexType)((IndexType)MetaRegistry.get().getIndexes().get(type.getName()))) : com.gridnine.xtrip.common.model.restriction.helper.RestrictionsHelper.createRegistry((EntityType)((EntityType)MetaRegistry.get().getEntities().get(type.getName())));
            vm.getRestrictions().addAll(RestrictionsUtil.toRestrictionGroupsFromQuery(criterions, type, (Collection)dynamicValueHandlers, (RestrictionResourcesRegistry)registry));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public static void fromVMAdditionalCriterion(RestrictionsData vm, List<SearchCriterion> criterions, Class<?> type, List<TemplateReportRequestedParameter> parameters) {
        List dynamicValueHandlers = RestrictionsHelper.createDynamicValueHandlers(parameters, null);
        criterions.clear();
        criterions.addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)vm.getRestrictions(), type, (Collection)dynamicValueHandlers));
    }

    public static void fromVMPagesCriterion(RestrictionsData vm, List<SearchCriterion> criterions, String type, List<TemplateReportRequestedParameter> parameters) {
        try {
            Class<?> indexClass = Class.forName(type);
            TemplateReportHelper.fromVMPagesCriterion(vm, criterions, indexClass, parameters);
        }
        catch (ClassNotFoundException e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public static void fromVMPagesCriterion(RestrictionsData vm, List<SearchCriterion> criterions, Class<?> type, List<TemplateReportRequestedParameter> parameters) {
        List dynamicValueHandlers = RestrictionsHelper.createDynamicValueHandlers(parameters, null);
        criterions.clear();
        try {
            RestrictionResourcesRegistry registry = type.getName().endsWith("Index") ? com.gridnine.xtrip.common.model.restriction.helper.RestrictionsHelper.createRegistry((IndexType)((IndexType)MetaRegistry.get().getIndexes().get(type.getName()))) : com.gridnine.xtrip.common.model.restriction.helper.RestrictionsHelper.createRegistry((EntityType)((EntityType)MetaRegistry.get().getEntities().get(type.getName())));
            criterions.addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)vm.getRestrictions(), type, (Collection)dynamicValueHandlers, (RestrictionResourcesRegistry)registry));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public static void fromVMMainControls(BaseSingleFileTemplateReportDescription model, TemplateReportControlStatusesContainerVM vm) {
        model.setAllowEmpty(vm.isAllowEmptyValue());
        model.setDisabled(vm.isDisabledValue());
        model.setDuplicateDisallowed(vm.isDublicateValue());
        model.setPeriodIntersectionDisallowed(vm.isPeriodIntersectionValue());
    }

    public static void fromVMMainRequestParameters(BaseSingleFileTemplateReportDescription model, TemplateReportRequestedParametersContainerVM vm) {
        VMHelper.transfer((Collection)vm.getContent(), (Collection)model.getRequestedParameters(), el -> new TemplateReportRequestedParameter(), (paramVM, param) -> {
            param.setBusinessType(paramVM.getBusinessType());
            param.setControlType(paramVM.getControlType());
            param.setKey(paramVM.getKey());
            param.setName(paramVM.getName());
            param.setSubtype(paramVM.getSubType());
            param.setType(paramVM.getType());
        });
    }

    public static void toVMCustomParameters(List<TemplateReportPageCustomParameterValue> param, List<TemplateReportPagesContainerCustomParametersVM> paramVM) {
        VMHelper.transfer(param, paramVM, el -> new TemplateReportPagesContainerCustomParametersVM(), (cust, custVM) -> {
            custVM.setKey(cust.getKey());
            custVM.setType(cust.getType());
            custVM.setValueObject(cust.getValue());
        });
    }

    public static void fromVMCustomParameters(List<TemplateReportPagesContainerCustomParametersVM> paramVM, List<TemplateReportPageCustomParameterValue> param) {
        VMHelper.transfer(paramVM, param, el -> new TemplateReportPageCustomParameterValue(), (custVM, cust) -> {
            cust.setKey(custVM.getKey());
            cust.setType(custVM.getType());
            cust.setValue(custVM.getValueObject());
        });
    }
}

