/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.ReportControllerInterceptorHelper;
import com.gridnine.xtrip.client.fx.reports.model.MainAgentTemplateReportParametersPane;
import com.gridnine.xtrip.client.fx.reports.model.MainAgentTemplateReportParametersPaneController;
import com.gridnine.xtrip.client.fx.reports.model.MainAgentTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.common.reports.model.GeneralAgentTemplateReportFilteringParameters;
import java.util.List;
import javafx.collections.ObservableMap;

public class AgentTemplateReportParametersControllerInterceptor
extends ControllerInterceptor<MainAgentTemplateReportParametersPaneVM, MainAgentTemplateReportParametersPaneController> {
    protected Class<MainAgentTemplateReportParametersPaneController> getControllerClass() {
        return MainAgentTemplateReportParametersPaneController.class;
    }

    protected void onCreate(MainAgentTemplateReportParametersPaneController controller) {
        controller.getView().getAgentNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgents);
        controller.getView().getSubagencyNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        controller.getView().getSalesPointNode().setListParametersSupplier(ControllerInterceptorsHelper::getSalesPoints);
    }

    protected void beforeReadData(MainAgentTemplateReportParametersPaneController controller, MainAgentTemplateReportParametersPaneVM model) {
        if (model.getDescription() != null) {
            AgentTemplateReportParametersControllerInterceptor.filterGlobalParameters(controller.getView(), model.getDescription().getGlobalFilteringParameters());
        }
        ReportControllerInterceptorHelper.addRequestedParameters((ObservableMap<Object, Object>)controller.getView().getProperties(), controller.getView().getCells(), model.getRequestedParameters());
    }

    private static void filterGlobalParameters(MainAgentTemplateReportParametersPane content, List<GeneralAgentTemplateReportFilteringParameters> params) {
        if (!params.contains(GeneralAgentTemplateReportFilteringParameters.CASH)) {
            content.getCells().remove((Object)content.getCashCell());
        }
        if (!params.contains(GeneralAgentTemplateReportFilteringParameters.AGENT)) {
            content.getCells().remove((Object)content.getAgentCell());
        }
        if (!params.contains(GeneralAgentTemplateReportFilteringParameters.CASH_REGISTER)) {
            content.getCells().remove((Object)content.getCashRegisterCell());
        }
        if (!params.contains(GeneralAgentTemplateReportFilteringParameters.CASH_REGISTER_WORKPLACE)) {
            content.getCells().remove((Object)content.getCashRegisterWorkplaceCell());
        }
        if (!params.contains(GeneralAgentTemplateReportFilteringParameters.SALES_POINT)) {
            content.getCells().remove((Object)content.getSalesPointCell());
        }
        if (!params.contains(GeneralAgentTemplateReportFilteringParameters.SUBAGENCY)) {
            content.getCells().remove((Object)content.getSubagencyCell());
        }
        if (!params.contains(GeneralAgentTemplateReportFilteringParameters.WORKLOG)) {
            content.getCells().remove((Object)content.getWorklogCell());
        }
        if (!params.contains(GeneralAgentTemplateReportFilteringParameters.USE_NEW_CASH_REMAINS)) {
            content.getCells().remove((Object)content.getUseNewCashRemainsCell());
        }
    }
}

