/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors;

import com.google.common.base.Supplier;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.CompactGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportPagesContainer;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportRequestedParametersTableVM;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportTemplatesContainer;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportTemplatesContainerVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.restriction.BasicRestrictionsWidget;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.reports.model.TemplateReportRequestedParameter;
import com.gridnine.xtrip.common.reports.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.common.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;

public class ReportControllerInterceptorHelper {
    private static final String REQUESTED_PARAMS_KEY = "REQUESTED_PARAMS_KEY";

    static void setContentTypeSupplier(ComboBoxWidget<ContentType> contentTypeValueNode) {
        contentTypeValueNode.setItemsSupplier(() -> Arrays.asList(ContentType.JASPERPRINT, ContentType.EXCEL, ContentType.EXCEL_2007, ContentType.XML, ContentType.DBF));
    }

    static void setSelectConverter(BooleanValueWidget selectNode) {
        selectNode.setConverter(Converters.boolConverter((String)"CONSTRUCTOR", (String)"SCRIPT"));
    }

    static void setTemplatesAndPagesConverter(Tile<Node, CompactGroupsWidget<TemplateReportTemplatesContainer>> templatesTile, Tile<Node, CompactGroupsWidget<TemplateReportPagesContainer>> pagesTile) {
        ((CompactGroupsWidget)templatesTile.getFullNode()).setConverter((obj, idx) -> String.valueOf(idx + 1) + ". " + obj.getNameNode().getValue());
        ((CompactGroupsWidget)pagesTile.getFullNode()).setConverter((obj, idx) -> String.valueOf(idx + 1) + ". " + obj.getNameNode().getValue());
    }

    static void setDynamicValueHandlersToWidget(List<TemplateReportRequestedParametersTableVM> tables, BasicRestrictionsWidget widget) {
        ArrayList params = new ArrayList();
        VMHelper.transfer(tables, params, el -> new TemplateReportRequestedParameter(), (paramVM, param) -> {
            param.setBusinessType(paramVM.getBusinessType());
            param.setControlType(paramVM.getControlType());
            param.setKey(paramVM.getKey());
            param.setName(paramVM.getName());
            param.setSubtype(paramVM.getSubType());
            param.setType(paramVM.getType());
        });
        widget.setDynamicValueHandlersSupplier(() -> RestrictionsHelper.createDynamicValueHandlers((List)params, null));
    }

    static void setPagesListener(Tile<Node, CompactGroupsWidget<TemplateReportPagesContainer>> pagesTile, Supplier<List<TemplateReportTemplatesContainerVM>> templatesVmList, String resourceId) {
        ((CompactGroupsWidget)pagesTile.getFullNode()).getViews().addListener(c -> {
            c.next();
            List addedSubList = c.getAddedSubList();
            addedSubList.forEach(panel -> {
                panel.getTemplateNode().setItemsSupplier(() -> ((List)templatesVmList.get()).stream().map(el -> new Pair((Object)el.getName(), (Object)el.getUid())).collect(Collectors.toList()));
                ComboBoxWidgetColumn sortOrderColumn = (ComboBoxWidgetColumn)((TableWidget)panel.getSortOrderNode().getContent()).getColumn("field");
                sortOrderColumn.setItemsSupplier(() -> ReportControllerInterceptorHelper.getDescriptions(resourceId));
            });
        });
    }

    static void addRequestedParameters(ObservableMap<Object, Object> properties, ObservableList<GridCell<?>> cells, HashMap<String, Object> paramsMap) {
        if (!properties.containsKey((Object)REQUESTED_PARAMS_KEY)) {
            properties.put((Object)REQUESTED_PARAMS_KEY, new ArrayList());
        }
        List alreadyAddedProperties = (List)properties.get((Object)REQUESTED_PARAMS_KEY);
        for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
            if (alreadyAddedProperties.contains(entry.getKey())) continue;
            cells.add((Object)((GridCell)entry.getValue()));
            alreadyAddedProperties.add(entry.getKey());
        }
    }

    private static List<String> getDescriptions(String clsName) {
        EntityType et = (EntityType)MetaRegistry.get().getEntities().get(clsName);
        ArrayList<String> descriptions = new ArrayList<String>();
        if (et != null) {
            et.getProperties().values().forEach(el -> descriptions.add(el.getId()));
        }
        return descriptions;
    }
}

