/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentInfo;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.AgentReportParametersControllerInterceptor;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Date;

class AgentReportDocumentHandler
implements ReportDocumentHandler<AgentReportDocument, AgentReportDocumentIndex> {
    AgentReportDocumentHandler() {
        ControllersRegistry.register((ControllerInterceptor)new AgentReportParametersControllerInterceptor());
    }

    @Override
    public Class<AgentReportDocument> getEntityType() {
        return AgentReportDocument.class;
    }

    @Override
    public Class<AgentReportDocumentIndex> getIndexType() {
        return AgentReportDocumentIndex.class;
    }

    @Override
    public SearchQuery createRecentDocumentsQuery() {
        SearchQuery result = new SearchQuery();
        result.getCriteria().getOrders().put(AgentReportDocumentIndex.Property.created.name(), SortOrder.DESC);
        result.getPreferredProperties().add(AgentReportDocumentIndex.Property.created.name());
        result.getPreferredProperties().add(AgentReportDocumentIndex.Property.periodBegin.name());
        result.getPreferredProperties().add(AgentReportDocumentIndex.Property.periodEnd.name());
        return result;
    }

    @Override
    public ReportDocumentInfo<AgentReportDocument> buildDocumentInfo(AgentReportDocumentIndex idx) {
        ReportDocumentInfo<AgentReportDocument> result = new ReportDocumentInfo<AgentReportDocument>();
        result.setSource(idx.getSource());
        result.setCreated(DateUtils.asLocalDate((Date)idx.getCreated()));
        result.setPeriodBegin(DateUtils.asLocalDate((Date)idx.getPeriodBegin()));
        result.setPeriodEnd(DateUtils.asLocalDate((Date)idx.getPeriodEnd()));
        return result;
    }

    @Override
    public BaseReportParameters getReportParameters(AgentReportDocument document) {
        return document.getParameters();
    }

    @Override
    public String getReportLaunchHandlerUid(AgentReportDocument document) {
        return document.getParameters().getReportId();
    }
}

