/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentInfo;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.AgentTemplateReportParametersControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.handlers.TemplateReportsHelper;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Date;

public class AgentTemplateReportDocumentHandler
implements ReportDocumentHandler<BaseTemplateReportDocument, AgentTemplateReportDocumentIndex> {
    AgentTemplateReportDocumentHandler() {
        ControllersRegistry.register((ControllerInterceptor)new AgentTemplateReportParametersControllerInterceptor());
    }

    @Override
    public Class<BaseTemplateReportDocument> getEntityType() {
        return BaseTemplateReportDocument.class;
    }

    @Override
    public Class<AgentTemplateReportDocumentIndex> getIndexType() {
        return AgentTemplateReportDocumentIndex.class;
    }

    @Override
    public SearchQuery createRecentDocumentsQuery() {
        SearchQuery result = new SearchQuery();
        result.getCriteria().getOrders().put(AgentTemplateReportDocumentIndex.Property.created.name(), SortOrder.DESC);
        result.getPreferredProperties().add(AgentTemplateReportDocumentIndex.Property.created.name());
        result.getPreferredProperties().add(AgentTemplateReportDocumentIndex.Property.periodBegin.name());
        result.getPreferredProperties().add(AgentTemplateReportDocumentIndex.Property.periodEnd.name());
        return result;
    }

    @Override
    public ReportDocumentInfo<BaseTemplateReportDocument> buildDocumentInfo(AgentTemplateReportDocumentIndex idx) {
        ReportDocumentInfo<BaseTemplateReportDocument> result = new ReportDocumentInfo<BaseTemplateReportDocument>();
        result.setSource(idx.getSource());
        result.setCreated(DateUtils.asLocalDate((Date)idx.getCreated()));
        result.setPeriodBegin(DateUtils.asLocalDate((Date)idx.getPeriodBegin()));
        result.setPeriodEnd(DateUtils.asLocalDate((Date)idx.getPeriodEnd()));
        return result;
    }

    @Override
    public BaseReportParameters getReportParameters(BaseTemplateReportDocument document) {
        return TemplateReportsHelper.getReportParameters(document);
    }

    @Override
    public String getReportLaunchHandlerUid(BaseTemplateReportDocument document) {
        return TemplateReportsHelper.getReportLaunchHandlerUid(document);
    }
}

