/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentInfo;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.ProductReportParametersControllerInterceptor;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ProductReportDocument;
import com.gridnine.xtrip.common.reports.model.ProductReportDocumentIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Date;

class ProductReportDocumentHandler
implements ReportDocumentHandler<ProductReportDocument, ProductReportDocumentIndex> {
    ProductReportDocumentHandler() {
        ControllersRegistry.register((ControllerInterceptor)new ProductReportParametersControllerInterceptor());
    }

    @Override
    public Class<ProductReportDocument> getEntityType() {
        return ProductReportDocument.class;
    }

    @Override
    public Class<ProductReportDocumentIndex> getIndexType() {
        return ProductReportDocumentIndex.class;
    }

    @Override
    public SearchQuery createRecentDocumentsQuery() {
        SearchQuery result = new SearchQuery();
        result.getCriteria().getOrders().put(ProductReportDocumentIndex.Property.created.name(), SortOrder.DESC);
        result.getPreferredProperties().add(ProductReportDocumentIndex.Property.created.name());
        result.getPreferredProperties().add(ProductReportDocumentIndex.Property.periodBegin.name());
        result.getPreferredProperties().add(ProductReportDocumentIndex.Property.periodEnd.name());
        return result;
    }

    @Override
    public ReportDocumentInfo<ProductReportDocument> buildDocumentInfo(ProductReportDocumentIndex idx) {
        ReportDocumentInfo<ProductReportDocument> result = new ReportDocumentInfo<ProductReportDocument>();
        result.setSource(idx.getSource());
        result.setCreated(DateUtils.asLocalDate((Date)idx.getCreated()));
        result.setPeriodBegin(DateUtils.asLocalDate((Date)idx.getPeriodBegin()));
        result.setPeriodEnd(DateUtils.asLocalDate((Date)idx.getPeriodEnd()));
        return result;
    }

    @Override
    public BaseReportParameters getReportParameters(ProductReportDocument document) {
        return document.getParameters();
    }

    @Override
    public String getReportLaunchHandlerUid(ProductReportDocument document) {
        return document.getParameters().getReportId();
    }
}

